/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.security;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.security.ExtendedSecurityService;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

public class ExtendedSecurityServiceImpl
extends ServiceBaseImpl
implements ExtendedSecurityService,
RecordsManagementModel,
ApplicationListener<ContextRefreshedEvent> {
    static final String ROOT_IPR_GROUP = "INPLACE_RECORD_MANAGEMENT";
    static final String READER_GROUP_PREFIX = "IPRR";
    static final String WRITER_GROUP_PREFIX = "IPRW";
    private static final int MAX_ITEMS = 50;
    private FilePlanService filePlanService;
    private FilePlanRoleService filePlanRoleService;
    private AuthorityService authorityService;
    private PermissionService permissionService;
    private TransactionService transactionService;
    private boolean enableUsernameNormalization;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setEnableUsernameNormalization(boolean enableUsernameNormalization) {
        this.enableUsernameNormalization = enableUsernameNormalization;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() {
                        if (!ExtendedSecurityServiceImpl.this.authorityService.authorityExists(ExtendedSecurityServiceImpl.this.getRootIRPGroup())) {
                            ExtendedSecurityServiceImpl.this.authorityService.createAuthority(AuthorityType.GROUP, ExtendedSecurityServiceImpl.ROOT_IPR_GROUP, ExtendedSecurityServiceImpl.ROOT_IPR_GROUP, Collections.singleton("APP.RM"));
                        }
                        return null;
                    }
                };
                ExtendedSecurityServiceImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private String getRootIRPGroup() {
        return "GROUP_INPLACE_RECORD_MANAGEMENT";
    }

    @Override
    public boolean hasExtendedSecurity(NodeRef nodeRef) {
        return this.getIPRGroups(nodeRef) != null;
    }

    @Override
    public Set<String> getReaders(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        Set<String> result = Collections.EMPTY_SET;
        Pair<String, String> iprGroups = this.getIPRGroups(nodeRef);
        if (iprGroups != null) {
            result = this.getAuthorities((String)iprGroups.getFirst());
        }
        return result;
    }

    @Override
    public Set<String> getWriters(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        Set<String> result = Collections.EMPTY_SET;
        Pair<String, String> iprGroups = this.getIPRGroups(nodeRef);
        if (iprGroups != null) {
            result = this.getAuthorities((String)iprGroups.getSecond());
        }
        return result;
    }

    private Set<String> getAuthorities(String group) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.authorityService.getContainedAuthorities(null, group, true));
        return result;
    }

    @Override
    public void set(NodeRef nodeRef, Pair<Set<String>, Set<String>> readersAndWriters) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        this.set(nodeRef, (Set)readersAndWriters.getFirst(), (Set)readersAndWriters.getSecond());
    }

    @Override
    public void set(NodeRef nodeRef, Set<String> readers, Set<String> writers) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        this.remove(nodeRef);
        Pair<String, String> iprGroups = this.createOrFindIPRGroups(readers, writers);
        NodeRef filePlan = this.filePlanService.getFilePlan(nodeRef);
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "ExtendedReaders", (String)iprGroups.getFirst());
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "ExtendedWriters", (String)iprGroups.getSecond());
        this.assignIPRGroupsToNode(iprGroups, nodeRef);
        if (this.isRecord(nodeRef)) {
            List assocs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef assoc : assocs) {
                NodeRef child = assoc.getChildRef();
                this.assignIPRGroupsToNode(iprGroups, child);
            }
        }
    }

    private Pair<String, String> getIPRGroups(NodeRef nodeRef) {
        Pair result = null;
        String iprReaderGroup = null;
        String iprWriterGroup = null;
        Set permissions = this.permissionService.getAllSetPermissions(nodeRef);
        for (AccessPermission permission : permissions) {
            if (permission.getAuthority().startsWith("GROUP_IPRR")) {
                iprReaderGroup = permission.getAuthority();
                continue;
            }
            if (!permission.getAuthority().startsWith("GROUP_IPRW")) continue;
            iprWriterGroup = permission.getAuthority();
        }
        if (iprReaderGroup != null && iprWriterGroup != null) {
            result = new Pair(iprReaderGroup, iprWriterGroup);
        }
        return result;
    }

    private Pair<String, String> createOrFindIPRGroups(Set<String> readers, Set<String> writers) {
        return new Pair((Object)this.createOrFindIPRGroup(READER_GROUP_PREFIX, readers), (Object)this.createOrFindIPRGroup(WRITER_GROUP_PREFIX, writers));
    }

    private String createOrFindIPRGroup(String groupPrefix, Set<String> authorities) {
        String group = null;
        Set<String> authoritySet = this.normalizeAuthorities(authorities);
        Pair<String, Integer> groupResult = this.findIPRGroup(groupPrefix, authoritySet);
        group = groupResult.getFirst() == null ? this.createIPRGroup(groupPrefix, authoritySet, (Integer)groupResult.getSecond()) : (String)groupResult.getFirst();
        return group;
    }

    private Pair<String, Integer> findIPRGroup(String groupPrefix, Set<String> authorities) {
        Object iprGroup = null;
        int nextGroupIndex = 0;
        boolean hasMoreItems = true;
        int pageCount = 0;
        String groupShortNamePrefix = this.getIPRGroupPrefixShortName(groupPrefix, authorities);
        while (hasMoreItems) {
            PagingResults results = this.authorityService.getAuthorities(AuthorityType.GROUP, "APP.RM", groupShortNamePrefix, false, false, new PagingRequest(50 * pageCount, 50));
            nextGroupIndex += results.getPage().size();
            for (String group : results.getPage()) {
                if (!this.isIPRGroupTrueMatch(group, authorities)) continue;
                return new Pair((Object)group, (Object)nextGroupIndex);
            }
            hasMoreItems = results.hasMoreItems();
            ++pageCount;
        }
        return new Pair(iprGroup, (Object)nextGroupIndex);
    }

    private Set<String> normalizeAuthorities(Set<String> authNames) {
        if (!this.enableUsernameNormalization || authNames == null || authNames.isEmpty()) {
            return authNames;
        }
        HashSet<String> normalizedAuthorities = new HashSet<String>();
        for (String authorityName : authNames) {
            normalizedAuthorities.add(this.normalizeAuthorityName(authorityName));
        }
        return normalizedAuthorities;
    }

    private String normalizeAuthorityName(String authorityName) {
        if (authorityName == null || authorityName.startsWith("GROUP_")) {
            return authorityName;
        }
        if (this.authorityService.authorityExists(authorityName)) {
            try {
                NodeRef authorityNodeRef = this.authorityService.getAuthorityNodeRef(authorityName);
                if (authorityNodeRef != null) {
                    String username = (String)((Object)this.nodeService.getProperty(authorityNodeRef, ContentModel.PROP_USERNAME));
                    return username != null ? username : authorityName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return authorityName;
    }

    private boolean isIPRGroupTrueMatch(String group, Set<String> authorities) {
        HashSet<String> plainAuthorities = new HashSet<String>();
        if (authorities != null) {
            plainAuthorities.addAll(authorities);
            plainAuthorities.remove("GROUP_EVERYONE");
        }
        Set contained = this.authorityService.getContainedAuthorities(null, group, true);
        return contained.equals(plainAuthorities);
    }

    String getIPRGroupPrefixShortName(String prefix, Set<String> authorities) {
        StringBuilder builder = new StringBuilder(128).append(prefix).append(this.getAuthoritySetHashCode(authorities));
        return builder.toString();
    }

    String getIPRGroupShortName(String prefix, Set<String> authorities, int index) {
        return this.getIPRGroupShortName(prefix, authorities, Integer.toString(index));
    }

    private String getIPRGroupShortName(String prefix, Set<String> authorities, String index) {
        StringBuilder builder = new StringBuilder(128).append(this.getIPRGroupPrefixShortName(prefix, authorities)).append(index);
        return builder.toString();
    }

    private int getAuthoritySetHashCode(Set<String> authorities) {
        int result = 0;
        if (authorities != null && !authorities.isEmpty()) {
            result = StringUtils.join((Object[])authorities.toArray(), (String)"").hashCode();
        }
        return result;
    }

    private String createIPRGroup(String groupNamePrefix, Set<String> children, int index) {
        String group;
        ParameterCheck.mandatory((String)"groupNamePrefix", (Object)groupNamePrefix);
        String groupShortName = this.getIPRGroupShortName(groupNamePrefix, children, index);
        try {
            group = this.authorityService.createAuthority(AuthorityType.GROUP, groupShortName, groupShortName, Collections.singleton("APP.RM"));
            this.authorityService.addAuthority(this.getRootIRPGroup(), group);
            if (children != null) {
                for (String child : children) {
                    if (!this.authorityService.authorityExists(child) || "GROUP_EVERYONE".equals(child)) continue;
                    this.authorityService.addAuthority(group, child);
                }
            }
        }
        catch (DuplicateChildNodeNameException ex) {
            throw new ConcurrencyFailureException("IPR group creation failed due to concurrent duplicate group name creation: " + groupShortName);
        }
        return group;
    }

    private void assignIPRGroupsToNode(Pair<String, String> iprGroups, NodeRef nodeRef) {
        this.permissionService.setPermission(nodeRef, (String)iprGroups.getFirst(), "ReadRecords", true);
        this.permissionService.setPermission(nodeRef, (String)iprGroups.getSecond(), "Filing", true);
    }

    @Override
    public void remove(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        Pair<String, String> iprGroups = this.getIPRGroups(nodeRef);
        if (iprGroups != null) {
            this.clearPermissions(nodeRef, iprGroups);
            if (this.isRecord(nodeRef)) {
                List assocs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL);
                for (ChildAssociationRef assoc : assocs) {
                    NodeRef child = assoc.getChildRef();
                    this.clearPermissions(child, iprGroups);
                }
            }
        }
    }

    private void clearPermissions(NodeRef nodeRef, Pair<String, String> iprGroups) {
        this.permissionService.clearPermission(nodeRef, (String)iprGroups.getFirst());
        this.permissionService.clearPermission(nodeRef, (String)iprGroups.getSecond());
    }

    @Override
    @Deprecated
    public Set<String> getExtendedReaders(NodeRef nodeRef) {
        return this.getReaders(nodeRef);
    }

    @Override
    @Deprecated
    public Set<String> getExtendedWriters(NodeRef nodeRef) {
        return this.getWriters(nodeRef);
    }

    @Override
    @Deprecated
    public void addExtendedSecurity(NodeRef nodeRef, Set<String> readers, Set<String> writers) {
        this.set(nodeRef, readers, writers);
    }

    @Override
    @Deprecated
    public void addExtendedSecurity(NodeRef nodeRef, Set<String> readers, Set<String> writers, boolean applyToParents) {
        this.set(nodeRef, readers, writers);
    }

    @Override
    @Deprecated
    public void removeAllExtendedSecurity(NodeRef nodeRef) {
        this.remove(nodeRef);
    }

    @Override
    @Deprecated
    public void removeExtendedSecurity(NodeRef nodeRef, Set<String> readers, Set<String> writers) {
        this.remove(nodeRef);
    }

    @Override
    @Deprecated
    public void removeExtendedSecurity(NodeRef nodeRef, Set<String> readers, Set<String> writers, boolean applyToParents) {
        this.remove(nodeRef);
    }

    @Override
    @Deprecated
    public void removeAllExtendedSecurity(NodeRef nodeRef, boolean applyToParents) {
        this.remove(nodeRef);
    }
}

