/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockAuthenticationUtilHelper {
    public static final String SYSTEM_USER = "system";
    public static final String ADMIN_USER = "admin";
    public static final String GUEST_USER = "guest";

    public static void setup(AuthenticationUtil mockAuthenticationUtil) {
        MockAuthenticationUtilHelper.setup(mockAuthenticationUtil, ADMIN_USER);
    }

    public static void setup(AuthenticationUtil mockAuthenticationUtil, String fullyAuthenticatedUser) {
        Mockito.reset((Object[])new AuthenticationUtil[]{mockAuthenticationUtil});
        ((AuthenticationUtil)Mockito.lenient().doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                AuthenticationUtil.RunAsWork work = (AuthenticationUtil.RunAsWork)invocation.getArguments()[0];
                return work.doWork();
            }
        }).when((Object)mockAuthenticationUtil)).runAsSystem((AuthenticationUtil.RunAsWork)ArgumentMatchers.any(AuthenticationUtil.RunAsWork.class));
        ((AuthenticationUtil)Mockito.lenient().doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                AuthenticationUtil.RunAsWork work = (AuthenticationUtil.RunAsWork)invocation.getArguments()[0];
                return work.doWork();
            }
        }).when((Object)mockAuthenticationUtil)).runAs((AuthenticationUtil.RunAsWork)ArgumentMatchers.any(AuthenticationUtil.RunAsWork.class), ArgumentMatchers.anyString());
        Mockito.lenient().when((Object)mockAuthenticationUtil.getAdminUserName()).thenReturn((Object)ADMIN_USER);
        Mockito.lenient().when((Object)mockAuthenticationUtil.getFullyAuthenticatedUser()).thenReturn((Object)fullyAuthenticatedUser);
        Mockito.lenient().when((Object)mockAuthenticationUtil.getRunAsUser()).thenReturn((Object)fullyAuthenticatedUser);
        Mockito.lenient().when((Object)mockAuthenticationUtil.getSystemUserName()).thenReturn((Object)SYSTEM_USER);
        Mockito.lenient().when((Object)mockAuthenticationUtil.getGuestUserName()).thenReturn((Object)GUEST_USER);
    }
}

