/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.site.SiteRole;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM804Test
extends BaseRMTestCase {
    @Override
    protected void initServices() {
        super.initServices();
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isUserTest() {
        return true;
    }

    public void testUsersHaveDeletePermissionsOnFilePlan() throws Exception {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RM804Test.this.capabilityService.getCapabilityAccessState(RM804Test.this.filePlan, "Delete"));
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RM804Test.this.capabilityService.getCapabilityAccessState(RM804Test.this.filePlan, "Delete"));
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RM804Test.this.capabilityService.getCapabilityAccessState(RM804Test.this.filePlan, "Delete"));
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM804Test.this.capabilityService.getCapabilityAccessState(RM804Test.this.filePlan, "Delete"));
                return null;
            }
        }, this.rmUserName);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM804Test.this.capabilityService.getCapabilityAccessState(RM804Test.this.filePlan, "Delete"));
                return null;
            }
        }, this.userName);
    }

    public void testTryAndDeleteSiteAsSiteManagerOnly() {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM804Test.this.siteService.setMembership(RM804Test.this.siteId, RM804Test.this.userName, SiteRole.SiteManager.toString());
                return null;
            }
        }, "admin");
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Should not be able to delete site as a site manager only.", AlfrescoRuntimeException.class){

            public void run() throws Exception {
                RM804Test.this.siteService.deleteSite(RM804Test.this.siteId);
            }
        }, this.userName);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM804Test.this.filePlanRoleService.assignRoleToAuthority(RM804Test.this.filePlan, "User", RM804Test.this.userName);
                return null;
            }
        }, "admin");
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Should not be able to delete site as a site manager with an RM role that doesn't have the capability.", AlfrescoRuntimeException.class){

            public void run() throws Exception {
                RM804Test.this.siteService.deleteSite(RM804Test.this.siteId);
            }
        }, this.userName);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM804Test.this.filePlanRoleService.assignRoleToAuthority(RM804Test.this.filePlan, "Administrator", RM804Test.this.userName);
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM804Test.this.siteService.deleteSite(RM804Test.this.siteId);
                return null;
            }
        }, this.userName);
    }
}

