/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.record;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;

public class RecordUtils {
    private RecordUtils() {
    }

    public static void generateRecordIdentifier(NodeService nodeService, IdentifierService identifierService, NodeRef record) {
        if (nodeService.getProperty(record, RecordsManagementModel.PROP_IDENTIFIER) == null) {
            String recordId = identifierService.generateIdentifier(RecordsManagementModel.ASPECT_RECORD, nodeService.getPrimaryParent(record).getParentRef());
            String name = (String)((Object)nodeService.getProperty(record, ContentModel.PROP_NAME));
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(RecordsManagementModel.PROP_IDENTIFIER, recordId);
            props.put(RecordsManagementModel.PROP_ORIGIONAL_NAME, name);
            nodeService.addProperties(record, props);
        }
        RecordUtils.appendIdentifierToName(nodeService, record);
    }

    public static void appendIdentifierToName(NodeService nodeService, NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeService", (Object)nodeService);
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (nodeService.hasAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT)) {
            return;
        }
        String recordId = (String)((Object)nodeService.getProperty(nodeRef, RecordsManagementModel.PROP_IDENTIFIER));
        if (StringUtils.isNotBlank((CharSequence)recordId)) {
            String name = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            if (name.contains(" (" + recordId + ")")) {
                return;
            }
            int dotIndex = name.lastIndexOf(46);
            String prefix = name;
            String postfix = "";
            if (dotIndex > 0) {
                prefix = name.substring(0, dotIndex);
                postfix = name.substring(dotIndex);
            }
            String recordName = prefix + " (" + recordId + ")" + postfix;
            nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)recordName));
        }
    }
}

