/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.content.cleanser;

import java.io.File;
import org.alfresco.module.org_alfresco_module_rm.content.cleanser.ContentCleanser;
import org.alfresco.module.org_alfresco_module_rm.content.cleanser.ContentCleanserSevenPass;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

public class ContentCleanserSevenPassUnitTest
extends BaseUnitTest {
    @InjectMocks
    @Spy
    private ContentCleanserSevenPass contentCleanserSevenPass = new ContentCleanserSevenPass(){

        protected void overwrite(File file, ContentCleanser.OverwriteOperation overwriteOperation) {
        }
    };
    @Mock
    private File mockedFile;

    @Test
    public void cleanseFile() {
        Mockito.when((Object)this.mockedFile.exists()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedFile.canWrite()).thenReturn((Object)true);
        this.contentCleanserSevenPass.cleanse(this.mockedFile);
        ((ContentCleanserSevenPass)Mockito.verify((Object)this.contentCleanserSevenPass, (VerificationMode)Mockito.times((int)2))).overwrite(this.mockedFile, this.contentCleanserSevenPass.overwriteOnes);
        ((ContentCleanserSevenPass)Mockito.verify((Object)this.contentCleanserSevenPass, (VerificationMode)Mockito.times((int)3))).overwrite(this.mockedFile, this.contentCleanserSevenPass.overwriteZeros);
        ((ContentCleanserSevenPass)Mockito.verify((Object)this.contentCleanserSevenPass, (VerificationMode)Mockito.times((int)2))).overwrite(this.mockedFile, this.contentCleanserSevenPass.overwriteRandom);
    }

    @Test(expected=ContentIOException.class)
    public void fileDoesNotExist() {
        Mockito.when((Object)this.mockedFile.exists()).thenReturn((Object)false);
        Mockito.when((Object)this.mockedFile.canWrite()).thenReturn((Object)true);
        this.contentCleanserSevenPass.cleanse(this.mockedFile);
    }

    @Test(expected=ContentIOException.class)
    public void cantWriteToFile() {
        Mockito.when((Object)this.mockedFile.exists()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedFile.canWrite()).thenReturn((Object)false);
        this.contentCleanserSevenPass.cleanse(this.mockedFile);
    }
}

