/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.compatibility;

import java.io.Serializable;
import org.alfresco.module.org_alfresco_module_rm.patch.ModulePatchExecuterImpl;
import org.alfresco.repo.admin.registry.RegistryKey;
import org.alfresco.repo.admin.registry.RegistryService;
import org.alfresco.repo.module.AbstractModuleComponent;
import org.alfresco.repo.module.ModuleVersionNumber;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class ModulePatchComponent
extends AbstractModuleComponent {
    private static final String REGISTRY_PATH_MODULES = "modules";
    private static final String REGISTRY_PROPERTY_INSTALLED_VERSION = "installedVersion";
    private static final String REGISTRY_PROPERTY_CURRENT_VERSION = "currentVersion";
    protected static final Logger LOGGER = LoggerFactory.getLogger(ModulePatchComponent.class);
    protected RetryingTransactionHelper retryingTransactionHelper;
    protected BehaviourFilter behaviourFilter;
    protected ModulePatchExecuterImpl modulePatchExecuter;
    protected RegistryService registryService;

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setModulePatchExecuter(ModulePatchExecuterImpl modulePatchExecuter) {
        this.modulePatchExecuter = modulePatchExecuter;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public void init() {
        super.init();
        this.modulePatchExecuter.getDependsOn().add(this);
    }

    protected void executeInternal() {
        String moduleId = this.modulePatchExecuter.getModuleId();
        ModuleVersionNumber moduleNewVersionNumber = this.moduleService.getModule(moduleId).getModuleVersionNumber();
        ModuleVersionNumber moduleCurrentVersionNumber = this.getModuleVersionNumber(REGISTRY_PROPERTY_CURRENT_VERSION, moduleId);
        String moduleName = this.getName();
        if (moduleCurrentVersionNumber.equals((Object)ModuleVersionNumber.VERSION_ZERO) || moduleCurrentVersionNumber.equals((Object)moduleNewVersionNumber)) {
            LOGGER.info("Module patch component '{}' is skipped, no previous version found.", (Object)moduleName);
        } else if (this.isVersionLaterThan(moduleCurrentVersionNumber, moduleNewVersionNumber)) {
            LOGGER.info("Module patch component '{}' is skipped for upgrade from version {} to version {}", new Object[]{moduleName, moduleCurrentVersionNumber, moduleNewVersionNumber});
        } else {
            try {
                LOGGER.info("Module patch component '{}' is executing ...", (Object)moduleName);
                this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() {
                        ModulePatchComponent.this.behaviourFilter.disableBehaviour();
                        try {
                            ModulePatchComponent.this.executePatch();
                        }
                        finally {
                            ModulePatchComponent.this.behaviourFilter.enableBehaviour();
                        }
                        return null;
                    }
                }, false, true);
                LOGGER.info(" ... completed module patch '{}'", (Object)moduleName);
            }
            catch (Exception exception) {
                LOGGER.info("  ... error encountered.  {}", (Object)exception.getMessage(), (Object)exception);
                throw exception;
            }
        }
    }

    private ModuleVersionNumber getModuleVersionNumber(String registryProperty, String moduleId) {
        RegistryKey moduleKeyVersion = new RegistryKey("http://www.alfresco.org/system/modules/1.0", new String[]{REGISTRY_PATH_MODULES, moduleId, registryProperty});
        Serializable moduleVersion = this.registryService.getProperty(moduleKeyVersion);
        if (moduleVersion == null) {
            return ModuleVersionNumber.VERSION_ZERO;
        }
        return new ModuleVersionNumber(moduleVersion.toString());
    }

    private boolean isVersionLaterThan(ModuleVersionNumber moduleCurrentVersionNumber, ModuleVersionNumber moduleNewVersionNumber) {
        boolean versionLaterThan = false;
        if (moduleCurrentVersionNumber.compareTo(moduleNewVersionNumber) < 0) {
            ModuleVersionNumber minVersion = this.getAppliesFromVersionNumber();
            if (moduleCurrentVersionNumber.compareTo(minVersion) >= 0) {
                versionLaterThan = true;
            }
        } else {
            versionLaterThan = true;
        }
        return versionLaterThan;
    }

    protected abstract void executePatch();
}

