/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.dod;

import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM1147DODRMSiteTest
extends BaseRMTestCase
implements DOD5015Model {
    @Override
    protected boolean isRMSiteTest() {
        return false;
    }

    public void testCreateDODFilePlan() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                return RM1147DODRMSiteTest.this.filePlanService.createFilePlan(RM1147DODRMSiteTest.this.folder, "myDODfileplan", DOD5015Model.TYPE_DOD_5015_FILE_PLAN);
            }

            public void test(NodeRef filePlan) throws Exception {
                TestCase.assertNotNull((Object)filePlan);
                TestCase.assertEquals((Object)DOD5015Model.TYPE_DOD_5015_FILE_PLAN, (Object)RM1147DODRMSiteTest.this.nodeService.getType(filePlan));
                TestCase.assertTrue((boolean)RM1147DODRMSiteTest.this.filePlanService.isFilePlanComponent(filePlan));
                TestCase.assertTrue((boolean)RM1147DODRMSiteTest.this.filePlanService.isFilePlan(filePlan));
                TestCase.assertEquals((Object)FilePlanComponentKind.FILE_PLAN, (Object)RM1147DODRMSiteTest.this.filePlanService.getFilePlanComponentKind(filePlan));
                TestCase.assertNotNull((Object)RM1147DODRMSiteTest.this.filePlanService.getUnfiledContainer(filePlan));
                TestCase.assertNotNull((Object)RM1147DODRMSiteTest.this.filePlanService.getHoldContainer(filePlan));
                TestCase.assertNotNull((Object)RM1147DODRMSiteTest.this.filePlanService.getTransferContainer(filePlan));
                TestCase.assertTrue((boolean)RM1147DODRMSiteTest.this.filePlanService.getFilePlans().contains(filePlan));
                TestCase.assertFalse((boolean)RM1147DODRMSiteTest.this.filePlanRoleService.getRoles(filePlan).isEmpty());
            }
        });
    }

    public void testCreateDODRMSite() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<SiteInfo>(){
            String siteId;
            {
                this.siteId = GUID.generate();
            }

            public SiteInfo run() throws Exception {
                return RM1147DODRMSiteTest.this.siteService.createSite("dodrmsite", this.siteId, "title", "description", SiteVisibility.PUBLIC, DOD5015Model.TYPE_DOD_5015_SITE);
            }

            public void test(SiteInfo siteInfo) throws Exception {
                TestCase.assertNotNull((Object)siteInfo);
                TestCase.assertEquals((Object)DOD5015Model.TYPE_DOD_5015_SITE, (Object)RM1147DODRMSiteTest.this.nodeService.getType(siteInfo.getNodeRef()));
                NodeRef filePlan = RM1147DODRMSiteTest.this.siteService.getContainer(this.siteId, "documentLibrary");
                TestCase.assertNotNull((Object)filePlan);
                TestCase.assertEquals((Object)DOD5015Model.TYPE_DOD_5015_FILE_PLAN, (Object)RM1147DODRMSiteTest.this.nodeService.getType(filePlan));
                TestCase.assertTrue((boolean)RM1147DODRMSiteTest.this.filePlanService.isFilePlanComponent(filePlan));
                TestCase.assertTrue((boolean)RM1147DODRMSiteTest.this.filePlanService.isFilePlan(filePlan));
                TestCase.assertEquals((Object)FilePlanComponentKind.FILE_PLAN, (Object)RM1147DODRMSiteTest.this.filePlanService.getFilePlanComponentKind(filePlan));
                TestCase.assertNotNull((Object)RM1147DODRMSiteTest.this.filePlanService.getUnfiledContainer(filePlan));
                TestCase.assertNotNull((Object)RM1147DODRMSiteTest.this.filePlanService.getHoldContainer(filePlan));
                TestCase.assertNotNull((Object)RM1147DODRMSiteTest.this.filePlanService.getTransferContainer(filePlan));
                TestCase.assertTrue((boolean)RM1147DODRMSiteTest.this.filePlanService.getFilePlans().contains(filePlan));
                TestCase.assertFalse((boolean)RM1147DODRMSiteTest.this.filePlanRoleService.getRoles(filePlan).isEmpty());
            }
        });
    }

    public void testDODRecord() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){
            String siteId;
            {
                this.siteId = GUID.generate();
            }

            public NodeRef run() throws Exception {
                RM1147DODRMSiteTest.this.siteService.createSite("dodrmsite", this.siteId, "title", "description", SiteVisibility.PUBLIC, DOD5015Model.TYPE_DOD_5015_SITE);
                NodeRef filePlan = RM1147DODRMSiteTest.this.siteService.getContainer(this.siteId, "documentlibrary");
                TestCase.assertNotNull((Object)filePlan);
                NodeRef recordCategory = RM1147DODRMSiteTest.this.filePlanService.createRecordCategory(filePlan, "testOne");
                NodeRef recordFolder = RM1147DODRMSiteTest.this.recordFolderService.createRecordFolder(recordCategory, "testOne");
                NodeRef record = RM1147DODRMSiteTest.this.utils.createRecord(recordFolder, "testOne.txt", "Test One");
                return record;
            }

            public void test(NodeRef record) throws Exception {
                TestCase.assertNotNull((Object)record);
                TestCase.assertTrue((boolean)RM1147DODRMSiteTest.this.nodeService.hasAspect(record, DOD5015Model.ASPECT_DOD_5015_RECORD));
            }
        });
    }

    public void testVanillaRecord() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){
            String siteId;
            {
                this.siteId = GUID.generate();
            }

            public NodeRef run() throws Exception {
                RM1147DODRMSiteTest.this.siteService.createSite("rmsite", this.siteId, "title", "description", SiteVisibility.PUBLIC, RecordsManagementModel.TYPE_RM_SITE);
                NodeRef filePlan = RM1147DODRMSiteTest.this.siteService.getContainer(this.siteId, "documentlibrary");
                TestCase.assertNotNull((Object)filePlan);
                NodeRef recordCategory = RM1147DODRMSiteTest.this.filePlanService.createRecordCategory(filePlan, "testOne");
                NodeRef recordFolder = RM1147DODRMSiteTest.this.recordFolderService.createRecordFolder(recordCategory, "testOne");
                NodeRef record = RM1147DODRMSiteTest.this.utils.createRecord(recordFolder, "testOne.txt", "Test One");
                return record;
            }

            public void test(NodeRef record) throws Exception {
                TestCase.assertNotNull((Object)record);
                TestCase.assertFalse((boolean)RM1147DODRMSiteTest.this.nodeService.hasAspect(record, DOD5015Model.ASPECT_DOD_5015_RECORD));
            }
        });
    }
}

