/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.content.cleanser;

import java.io.File;
import org.alfresco.module.org_alfresco_module_rm.content.cleanser.ContentCleanser;
import org.alfresco.module.org_alfresco_module_rm.content.cleanser.ContentCleanser522022M;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;

public class ContentCleanser522022MUnitTest
extends BaseUnitTest {
    @InjectMocks
    @Spy
    private ContentCleanser522022M contentCleanser522022M = new ContentCleanser522022M(){

        protected void overwrite(File file, ContentCleanser.OverwriteOperation overwriteOperation) {
        }
    };
    @Mock
    private File mockedFile;

    @Test
    public void cleanseFile() {
        Mockito.when((Object)this.mockedFile.exists()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedFile.canWrite()).thenReturn((Object)true);
        this.contentCleanser522022M.cleanse(this.mockedFile);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.contentCleanser522022M});
        ((ContentCleanser522022M)inOrder.verify((Object)this.contentCleanser522022M)).overwrite(this.mockedFile, this.contentCleanser522022M.overwriteOnes);
        ((ContentCleanser522022M)inOrder.verify((Object)this.contentCleanser522022M)).overwrite(this.mockedFile, this.contentCleanser522022M.overwriteZeros);
        ((ContentCleanser522022M)inOrder.verify((Object)this.contentCleanser522022M)).overwrite(this.mockedFile, this.contentCleanser522022M.overwriteRandom);
    }

    @Test(expected=ContentIOException.class)
    public void fileDoesNotExist() {
        Mockito.when((Object)this.mockedFile.exists()).thenReturn((Object)false);
        Mockito.when((Object)this.mockedFile.canWrite()).thenReturn((Object)true);
        this.contentCleanser522022M.cleanse(this.mockedFile);
    }

    @Test(expected=ContentIOException.class)
    public void cantWriteToFile() {
        Mockito.when((Object)this.mockedFile.exists()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedFile.canWrite()).thenReturn((Object)false);
        this.contentCleanser522022M.cleanse(this.mockedFile);
    }
}

