/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.aspect;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.util.PropertyModificationAllowedCheck;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

@BehaviourBean(defaultType="rma:frozen")
public class FrozenAspect
extends BaseBehaviourBean
implements NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeMoveNodePolicy {
    private static final String ON_UPDATE_PROP_FROZEN_BEHAVIOUR_NAME = "onUpdatePropertiesFrozenAspect";
    protected FreezeService freezeService;
    private PropertyModificationAllowedCheck propertyModificationAllowedCheck;

    public void setFreezeService(FreezeService freezeService) {
        this.freezeService = freezeService;
    }

    public void setPropertyModificationAllowedCheck(PropertyModificationAllowedCheck propertyModificationAllowedCheck) {
        this.propertyModificationAllowedCheck = propertyModificationAllowedCheck;
    }

    public void disableOnPropUpdateFrozenAspect() {
        Behaviour behaviour = this.getBehaviour(ON_UPDATE_PROP_FROZEN_BEHAVIOUR_NAME);
        if (behaviour != null) {
            behaviour.disable();
        }
    }

    public void enableOnPropUpdateFrozenAspect() {
        Behaviour behaviour = this.getBehaviour(ON_UPDATE_PROP_FROZEN_BEHAVIOUR_NAME);
        if (behaviour != null && !behaviour.isEnabled()) {
            behaviour.enable();
        }
    }

    @org.alfresco.repo.policy.annotation.Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void beforeDeleteNode(NodeRef nodeRef) {
        AuthenticationUtil.runAsSystem(() -> {
            if (this.nodeService.exists(nodeRef) && this.freezeService.isFrozen(nodeRef)) {
                throw new PermissionDeniedException(I18NUtil.getMessage((String)"rm.hold.delete-frozen-node"));
            }
            this.checkChildren(this.nodeService.getChildAssocs(nodeRef));
            return null;
        });
    }

    private void checkChildren(List<ChildAssociationRef> assocs) {
        for (ChildAssociationRef assoc : assocs) {
            if (!assoc.isPrimary()) continue;
            NodeRef nodeRef = assoc.getChildRef();
            if (this.freezeService.isFrozen(nodeRef)) {
                throw new PermissionDeniedException(I18NUtil.getMessage((String)"rm.hold.delete-node-frozen-children"));
            }
            this.checkChildren(this.nodeService.getChildAssocs(nodeRef));
        }
    }

    @org.alfresco.repo.policy.annotation.Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        AuthenticationUtil.runAsSystem(() -> {
            if (this.nodeService.exists(nodeRef) && this.instanceOf(nodeRef, ContentModel.TYPE_CONTENT)) {
                NodeRef parentRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
                if (this.nodeService.hasAspect(parentRef, ASPECT_HELD_CHILDREN)) {
                    int currentCount = (Integer)this.nodeService.getProperty(parentRef, PROP_HELD_CHILDREN_COUNT);
                    this.nodeService.setProperty(parentRef, PROP_HELD_CHILDREN_COUNT, (Serializable)Integer.valueOf(++currentCount));
                } else if (this.instanceOf(parentRef, ContentModel.TYPE_FOLDER) && !this.nodeService.hasAspect(parentRef, SiteModel.ASPECT_SITE_CONTAINER)) {
                    HashMap<QName, Integer> props = new HashMap<QName, Integer>(1);
                    props.put(PROP_HELD_CHILDREN_COUNT, 1);
                    this.getInternalNodeService().addAspect(parentRef, ASPECT_HELD_CHILDREN, props);
                }
            }
            return null;
        });
    }

    @org.alfresco.repo.policy.annotation.Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        AuthenticationUtil.runAsSystem(() -> {
            int currentCount;
            NodeRef owningFolder;
            if (this.nodeService.exists(nodeRef) && this.instanceOf(nodeRef, ContentModel.TYPE_CONTENT) && this.nodeService.hasAspect(owningFolder = this.nodeService.getPrimaryParent(nodeRef).getParentRef(), ASPECT_HELD_CHILDREN) && (currentCount = ((Integer)this.nodeService.getProperty(owningFolder, PROP_HELD_CHILDREN_COUNT)).intValue()) > 0) {
                this.nodeService.setProperty(owningFolder, PROP_HELD_CHILDREN_COUNT, (Serializable)Integer.valueOf(currentCount - 1));
            }
            return null;
        });
    }

    @org.alfresco.repo.policy.annotation.Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void beforeMoveNode(ChildAssociationRef oldChildAssocRef, NodeRef newParentRef) {
        AuthenticationUtil.runAsSystem(() -> {
            if (this.nodeService.exists(oldChildAssocRef.getChildRef()) && this.freezeService.isFrozen(oldChildAssocRef.getChildRef())) {
                throw new PermissionDeniedException(I18NUtil.getMessage((String)"rm.hold.move-frozen-node"));
            }
            return null;
        });
    }

    @org.alfresco.repo.policy.annotation.Behaviour(kind=BehaviourKind.CLASS, name="onUpdatePropertiesFrozenAspect", notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        AuthenticationUtil.runAsSystem(() -> {
            if (this.nodeService.exists(nodeRef) && this.freezeService.isFrozen(nodeRef) && !this.transactionalResourceHelper.getSet("frozen").contains(nodeRef) && !this.propertyModificationAllowedCheck.check(before, after)) {
                throw new PermissionDeniedException(I18NUtil.getMessage((String)"rm.hold.update-frozen-node"));
            }
            return null;
        });
    }
}

