/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.sites;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.rest.api.model.SiteUpdate;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rm.rest.api.RMSites;
import org.alfresco.rm.rest.api.model.RMSite;
import org.alfresco.rm.rest.api.model.RMSiteCompliance;
import org.alfresco.rm.rest.api.sites.RMSiteEntityResource;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class RMSiteEntityResourceUnitTest
extends BaseUnitTest {
    private static final String NON_RM_SITE_ID = "not_rm";
    private static final String PERMANENT_PARAMETER = "permanent";
    private static final String RM_SITE_ID = "rm";
    private static final String RM_SITE_DESCRIPTION = "RM Site Description";
    private static final String RM_SITE_TITLE = "RM Site Title";
    @Mock
    private RMSites mockedRMSites;
    @InjectMocks
    private RMSiteEntityResource rmSiteEntityResource;

    @Override
    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void create() throws Exception {
        RMSite rmSite = new RMSite();
        rmSite.setTitle(RM_SITE_TITLE);
        rmSite.setId(RM_SITE_ID);
        rmSite.setDescription(RM_SITE_DESCRIPTION);
        rmSite.setCompliance(RMSiteCompliance.STANDARD);
        ArrayList<RMSite> entity = new ArrayList<RMSite>();
        Params parameters = (Params)Mockito.mock(Params.class);
        entity.add(rmSite);
        Mockito.when((Object)this.mockedRMSites.createRMSite(rmSite, (Parameters)parameters)).thenReturn((Object)rmSite);
        List createdRMSites = this.rmSiteEntityResource.create(entity, (Parameters)parameters);
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.times((int)1))).createRMSite(rmSite, (Parameters)parameters);
        Assert.assertEquals((String)"Created sites size should be 1.", (long)1L, (long)createdRMSites.size());
        Assert.assertNotNull(createdRMSites.get(0));
        Assert.assertEquals((Object)rmSite, createdRMSites.get(0));
    }

    @Test
    public void happyPathDelete() throws Exception {
        String siteId = RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        Mockito.when((Object)parameters.getParameter(PERMANENT_PARAMETER)).thenReturn(null);
        this.rmSiteEntityResource.delete(siteId, (Parameters)parameters);
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.times((int)1))).deleteRMSite(siteId, (Parameters)parameters);
    }

    @Test
    public void deleteNonRMSite() throws Exception {
        String siteId = NON_RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        Mockito.when((Object)parameters.getParameter(PERMANENT_PARAMETER)).thenReturn(null);
        try {
            this.rmSiteEntityResource.delete(siteId, (Parameters)parameters);
            Assert.fail((String)"Expected ecxeption as siteId was different than rm");
        }
        catch (InvalidParameterException ex) {
            Assert.assertEquals((Object)"The Deletion is supported only for siteId = rm.", (Object)ex.getMessage());
        }
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.never())).deleteRMSite(siteId, (Parameters)parameters);
    }

    @Test
    public void deleteRMSiteWithPermanentParam() throws Exception {
        String siteId = RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        Mockito.when((Object)parameters.getParameter(PERMANENT_PARAMETER)).thenReturn((Object)Boolean.toString(true));
        try {
            this.rmSiteEntityResource.delete(siteId, (Parameters)parameters);
            Assert.fail((String)"Expected ecxeption as parameter permanent was present in the request.");
        }
        catch (InvalidArgumentException ex) {
            Assert.assertEquals((Object)"DELETE does not support parameter: permanent", (Object)ex.getMsgId());
        }
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.never())).deleteSite(siteId, (Parameters)parameters);
    }

    @Test
    public void happyPathGet() throws Exception {
        String siteId = RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        this.rmSiteEntityResource.readById(siteId, (Parameters)parameters);
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.times((int)1))).getRMSite(siteId);
    }

    @Test
    public void getNonRMSite() throws Exception {
        String siteId = NON_RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        try {
            this.rmSiteEntityResource.readById(siteId, (Parameters)parameters);
            Assert.fail((String)"Expected ecxeption as siteId was different than rm");
        }
        catch (InvalidParameterException ex) {
            Assert.assertEquals((Object)"GET is supported only for siteId = rm.", (Object)ex.getMessage());
        }
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.never())).getRMSite(siteId);
    }

    @Test
    public void happyPathUpdate() throws Exception {
        String siteId = RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        RMSite site = new RMSite();
        site.setTitle("New Title");
        site.setDescription("New Description");
        this.rmSiteEntityResource.update(siteId, site, (Parameters)parameters);
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.times((int)1))).updateRMSite((String)ArgumentMatchers.any(String.class), (SiteUpdate)ArgumentMatchers.any(SiteUpdate.class), (Parameters)ArgumentMatchers.any(Parameters.class));
    }

    @Test
    public void updateNonRMSite() throws Exception {
        String siteId = NON_RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        RMSite site = new RMSite();
        site.setTitle("New Title");
        site.setDescription("New Description");
        try {
            this.rmSiteEntityResource.update(siteId, site, (Parameters)parameters);
            Assert.fail((String)"Expected ecxeption as siteId was different than rm");
        }
        catch (InvalidParameterException ex) {
            Assert.assertEquals((Object)"The Update is supported only for siteId = rm.", (Object)ex.getMessage());
        }
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.never())).updateRMSite((String)ArgumentMatchers.any(String.class), (SiteUpdate)ArgumentMatchers.any(SiteUpdate.class), (Parameters)ArgumentMatchers.any(Parameters.class));
    }

    @Test
    public void updateRMSiteId() throws Exception {
        String siteId = RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        RMSite site = new RMSite();
        site.setTitle("New Title");
        site.setDescription("New Description");
        site.setId("newSiteID");
        try {
            this.rmSiteEntityResource.update(siteId, site, (Parameters)parameters);
            Assert.fail((String)"Expected ecxeption as rm site id cannot be changed.");
        }
        catch (InvalidArgumentException ex) {
            Assert.assertEquals((Object)"Site update does not support field: id", (Object)ex.getMsgId());
        }
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.never())).updateRMSite((String)ArgumentMatchers.any(String.class), (SiteUpdate)ArgumentMatchers.any(SiteUpdate.class), (Parameters)ArgumentMatchers.any(Parameters.class));
    }

    @Test
    public void updateRMSiteGuid() throws Exception {
        String siteId = RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        RMSite site = new RMSite();
        site.setTitle("New Title");
        site.setDescription("New Description");
        site.setGuid("newGUID");
        try {
            this.rmSiteEntityResource.update(siteId, site, (Parameters)parameters);
            Assert.fail((String)"Expected ecxeption as rm site guid cannot be changed.");
        }
        catch (InvalidArgumentException ex) {
            Assert.assertEquals((Object)"Site update does not support field: guid", (Object)ex.getMsgId());
        }
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.never())).updateRMSite((String)ArgumentMatchers.any(String.class), (SiteUpdate)ArgumentMatchers.any(SiteUpdate.class), (Parameters)ArgumentMatchers.any(Parameters.class));
    }

    @Test
    public void updateRMSiteRole() throws Exception {
        String siteId = RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        RMSite site = new RMSite();
        site.setTitle("New Title");
        site.setDescription("New Description");
        site.setRole("newRole");
        try {
            this.rmSiteEntityResource.update(siteId, site, (Parameters)parameters);
            Assert.fail((String)"Expected ecxeption as rm site role cannot be changed.");
        }
        catch (InvalidArgumentException ex) {
            Assert.assertEquals((Object)"Site update does not support field: role", (Object)ex.getMsgId());
        }
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.never())).updateRMSite((String)ArgumentMatchers.any(String.class), (SiteUpdate)ArgumentMatchers.any(SiteUpdate.class), (Parameters)ArgumentMatchers.any(Parameters.class));
    }

    @Test
    public void updateRMSiteCompliance() throws Exception {
        String siteId = RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        RMSite site = new RMSite();
        site.setTitle("New Title");
        site.setDescription("New Description");
        site.setCompliance(RMSiteCompliance.STANDARD);
        try {
            this.rmSiteEntityResource.update(siteId, site, (Parameters)parameters);
            Assert.fail((String)"Expected ecxeption as rm site compliance cannot be changed.");
        }
        catch (InvalidArgumentException ex) {
            Assert.assertEquals((Object)"Site update does not support field: compliance", (Object)ex.getMsgId());
        }
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.never())).updateRMSite((String)ArgumentMatchers.any(String.class), (SiteUpdate)ArgumentMatchers.any(SiteUpdate.class), (Parameters)ArgumentMatchers.any(Parameters.class));
    }

    @Test
    public void updateRMSiteVisibility() throws Exception {
        String siteId = RM_SITE_ID;
        Params parameters = (Params)Mockito.mock(Params.class);
        RMSite site = new RMSite();
        site.setTitle("New Title");
        site.setDescription("New Description");
        site.setVisibility(SiteVisibility.PRIVATE);
        try {
            this.rmSiteEntityResource.update(siteId, site, (Parameters)parameters);
            Assert.fail((String)"Expected ecxeption as rm site visibility cannot be changed.");
        }
        catch (InvalidArgumentException ex) {
            Assert.assertEquals((Object)"Site update does not support field: visibility", (Object)ex.getMsgId());
        }
        ((RMSites)Mockito.verify((Object)this.mockedRMSites, (VerificationMode)Mockito.never())).updateRMSite((String)ArgumentMatchers.any(String.class), (SiteUpdate)ArgumentMatchers.any(SiteUpdate.class), (Parameters)ArgumentMatchers.any(Parameters.class));
    }
}

