/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import org.alfresco.module.org_alfresco_module_rm.model.rma.type.HoldContainerType;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;

public class HoldContainerTypeUnitTest
extends BaseUnitTest {
    @InjectMocks
    private HoldContainerType holdContainerType;

    @Test(expected=IntegrityException.class)
    public void testAddNonHoldTypeToHoldContainer() {
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_HOLD)).thenReturn((Object)false);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type);
        NodeRef holdContainer = this.generateNodeRef(TYPE_HOLD_CONTAINER, true);
        ChildAssociationRef mockedChildAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)mockedChildAssoc.getChildRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)mockedChildAssoc.getParentRef()).thenReturn((Object)holdContainer);
        this.holdContainerType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testAddHoldTypeToHoldContainer() {
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_HOLD)).thenReturn((Object)true);
        NodeRef holdFolder = AlfMock.generateNodeRef(this.mockedNodeService, type);
        NodeRef holdContainer = this.generateNodeRef(TYPE_HOLD_CONTAINER, true);
        ChildAssociationRef mockedChildAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)mockedChildAssoc.getChildRef()).thenReturn((Object)holdFolder);
        Mockito.when((Object)mockedChildAssoc.getParentRef()).thenReturn((Object)holdContainer);
        this.holdContainerType.onCreateChildAssociation(mockedChildAssoc, true);
    }
}

