/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.script.AbstractRmWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DispositionAbstractBase
extends AbstractRmWebScript {
    public static final String COMBINE_DISPOSITION_STEP_CONDITIONS = "combineDispositionStepConditions";

    protected DispositionSchedule parseRequestForSchedule(WebScriptRequest req) {
        NodeRef nodeRef = this.parseRequestForNodeRef(req);
        boolean inherited = true;
        String inheritedString = req.getParameter("inherited");
        if (inheritedString != null) {
            inherited = Boolean.parseBoolean(inheritedString);
        }
        DispositionSchedule schedule = null;
        schedule = inherited ? this.getDispositionService().getDispositionSchedule(nodeRef) : this.getDispositionService().getAssociatedDispositionSchedule(nodeRef);
        if (schedule == null) {
            throw new WebScriptException(404, "Node " + nodeRef.toString() + " does not have a disposition schedule");
        }
        return schedule;
    }

    protected DispositionActionDefinition parseRequestForActionDefinition(WebScriptRequest req, DispositionSchedule schedule) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String actionDefId = (String)templateVars.get("action_def_id");
        DispositionActionDefinition actionDef = schedule.getDispositionActionDefinition(actionDefId);
        if (actionDef == null) {
            throw new WebScriptException(404, "Requested disposition action definition (id:" + actionDefId + ") does not exist");
        }
        return actionDef;
    }

    protected Map<String, Object> createActionDefModel(DispositionActionDefinition actionDef, String url) {
        List<RecordsManagementEvent> events;
        HashMap<String, Object> model = new HashMap<String, Object>(8);
        model.put("id", actionDef.getId());
        model.put("index", actionDef.getIndex());
        model.put("url", url);
        model.put("name", actionDef.getName());
        model.put("label", actionDef.getLabel());
        model.put("eligibleOnFirstCompleteEvent", actionDef.eligibleOnFirstCompleteEvent());
        if (actionDef.getDescription() != null) {
            model.put("description", actionDef.getDescription());
        }
        if (actionDef.getPeriod() != null) {
            model.put("period", actionDef.getPeriod().toString());
        }
        if (actionDef.getPeriodProperty() != null) {
            model.put("periodProperty", actionDef.getPeriodProperty().toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
        }
        if (actionDef.getLocation() != null) {
            model.put("location", actionDef.getLocation());
        }
        if (actionDef.getGhostOnDestroy() != null) {
            model.put("ghostOnDestroy", actionDef.getGhostOnDestroy());
        }
        if ((events = actionDef.getEvents()) != null && events.size() > 0) {
            ArrayList<String> eventNames = new ArrayList<String>(events.size());
            for (RecordsManagementEvent event : events) {
                eventNames.add(event.getName());
            }
            model.put("events", eventNames);
        }
        if (this.getNodeService().getProperty(actionDef.getNodeRef(), RecordsManagementModel.PROP_COMBINE_DISPOSITION_STEP_CONDITIONS) != null) {
            model.put(COMBINE_DISPOSITION_STEP_CONDITIONS, this.getNodeService().getProperty(actionDef.getNodeRef(), RecordsManagementModel.PROP_COMBINE_DISPOSITION_STEP_CONDITIONS));
        }
        return model;
    }

    protected Map<String, Object> getDispositionScheduleModel(WebScriptRequest req) {
        DispositionSchedule schedule = this.parseRequestForSchedule(req);
        HashMap<String, Object> scheduleModel = new HashMap<String, Object>(8);
        String serviceUrl = req.getServiceContextPath() + req.getPathInfo();
        scheduleModel.put("url", serviceUrl);
        String actionsUrl = serviceUrl + "/dispositionactiondefinitions";
        scheduleModel.put("actionsUrl", actionsUrl);
        scheduleModel.put("nodeRef", schedule.getNodeRef().toString());
        scheduleModel.put("recordLevelDisposition", schedule.isRecordLevelDisposition());
        scheduleModel.put("canStepsBeRemoved", !this.getDispositionService().hasDisposableItems(schedule));
        if (schedule.getDispositionAuthority() != null) {
            scheduleModel.put("authority", schedule.getDispositionAuthority());
        }
        if (schedule.getDispositionInstructions() != null) {
            scheduleModel.put("instructions", schedule.getDispositionInstructions());
        }
        boolean unpublishedUpdates = false;
        boolean publishInProgress = false;
        ArrayList<Map<String, Object>> actions = new ArrayList<Map<String, Object>>();
        for (DispositionActionDefinition actionDef : schedule.getDispositionActionDefinitions()) {
            NodeRef actionDefNodeRef = actionDef.getNodeRef();
            if (this.getNodeService().hasAspect(actionDefNodeRef, RecordsManagementModel.ASPECT_UNPUBLISHED_UPDATE)) {
                unpublishedUpdates = true;
                publishInProgress = (Boolean)this.getNodeService().getProperty(actionDefNodeRef, RecordsManagementModel.PROP_PUBLISH_IN_PROGRESS);
            }
            actions.add(this.createActionDefModel(actionDef, actionsUrl + "/" + actionDef.getId()));
        }
        scheduleModel.put("actions", actions);
        scheduleModel.put("unpublishedUpdates", unpublishedUpdates);
        scheduleModel.put("publishInProgress", publishInProgress);
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("schedule", scheduleModel);
        return model;
    }
}

