/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import java.util.Arrays;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.namespace.QName;

@BehaviourBean(defaultType="rma:unfiledRecordContainer")
public class UnfiledRecordContainerType
extends BaseBehaviourBean
implements NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnDeleteNodePolicy {
    private static final String BEHAVIOUR_NAME = "onDeleteUnfiledRecordContainer";
    private static final List<QName> ACCEPTED_NON_UNIQUE_CHILD_TYPES = Arrays.asList(TYPE_UNFILED_RECORD_FOLDER, ContentModel.TYPE_CONTENT, TYPE_NON_ELECTRONIC_DOCUMENT);

    public void disable() {
        this.getBehaviour(BEHAVIOUR_NAME).disable();
    }

    public void enable() {
        this.getBehaviour(BEHAVIOUR_NAME).enable();
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION)
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        QName childType = this.nodeService.getType(childAssocRef.getChildRef());
        if (childType.equals((Object)ContentModel.TYPE_FOLDER)) {
            this.nodeService.setType(childAssocRef.getChildRef(), TYPE_UNFILED_RECORD_FOLDER);
        }
        this.validateNewChildAssociationSubTypesIncluded(childAssocRef.getChildRef(), ACCEPTED_NON_UNIQUE_CHILD_TYPES);
    }

    @Behaviour(kind=BehaviourKind.CLASS, name="onDeleteUnfiledRecordContainer")
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        throw new IntegrityException("Operation failed. Deletion of Unfiled Record Container is not allowed.", null);
    }
}

