/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import java.io.Serializable;
import java.util.UUID;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM4101Test
extends BaseRMTestCase {
    private RuleService ruleService;

    @Override
    protected void initServices() {
        super.initServices();
        this.ruleService = (RuleService)this.applicationContext.getBean("RuleService");
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testRunRuleNotInBackground() throws Exception {
        final String categoryName = "category1" + UUID.randomUUID().toString();
        final NodeRef category1 = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                return RM4101Test.this.filePlanService.createRecordCategory(RM4101Test.this.filePlan, categoryName);
            }
        });
        final NodeRef folder1 = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                return RM4101Test.this.recordFolderService.createRecordFolder(category1, "folder1WithRule" + UUID.randomUUID().toString());
            }
        });
        final String folder2Name = "folder2FolderToLinkTo" + UUID.randomUUID().toString();
        final NodeRef folder2 = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                return RM4101Test.this.recordFolderService.createRecordFolder(category1, folder2Name);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Action linkToAction = RM4101Test.this.actionService.createAction("linkTo");
                linkToAction.setParameterValue("path", (Serializable)((Object)("/" + categoryName + "/" + folder2Name)));
                Rule rule = new Rule();
                rule.setRuleType("inbound");
                rule.setTitle("LinkTo");
                rule.setAction(linkToAction);
                rule.setExecuteAsynchronously(false);
                RM4101Test.this.ruleService.saveRule(folder1, rule);
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM4101Test.this.utils.createRecord(folder1, "record1" + UUID.randomUUID().toString());
                return null;
            }

            public void test(Void result) throws Exception {
                TestCase.assertEquals((int)1, (int)RM4101Test.this.nodeService.getChildAssocs(folder2).size());
            }
        });
    }
}

