/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.disposition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementServiceRegistry;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinitionImpl;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class DispositionScheduleImpl
implements DispositionSchedule,
RecordsManagementModel {
    private NodeService nodeService;
    private RecordsManagementServiceRegistry services;
    private NodeRef dispositionDefinitionNodeRef;
    private AuthenticationUtil authenticationUtil;
    private List<DispositionActionDefinition> actions;
    private Map<String, DispositionActionDefinition> actionsById;
    private Map<String, DispositionActionDefinition> actionsByName;
    private Map<String, DispositionActionDefinition> actionsByDispositionActionName;

    public void setAuthenticationUtil(AuthenticationUtil authenticationUtil) {
        this.authenticationUtil = authenticationUtil;
    }

    public DispositionScheduleImpl(RecordsManagementServiceRegistry services, NodeService nodeService, NodeRef nodeRef) {
        this.dispositionDefinitionNodeRef = nodeRef;
        this.nodeService = nodeService;
        this.services = services;
    }

    @Override
    public NodeRef getNodeRef() {
        return this.dispositionDefinitionNodeRef;
    }

    @Override
    public String getDispositionAuthority() {
        return (String)((Object)this.nodeService.getProperty(this.dispositionDefinitionNodeRef, PROP_DISPOSITION_AUTHORITY));
    }

    @Override
    public String getDispositionInstructions() {
        return (String)((Object)this.nodeService.getProperty(this.dispositionDefinitionNodeRef, PROP_DISPOSITION_INSTRUCTIONS));
    }

    @Override
    public boolean isRecordLevelDisposition() {
        return (Boolean)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                Boolean value = (Boolean)DispositionScheduleImpl.this.nodeService.getProperty(DispositionScheduleImpl.this.dispositionDefinitionNodeRef, RecordsManagementModel.PROP_RECORD_LEVEL_DISPOSITION);
                if (value != null) {
                    return value;
                }
                return false;
            }
        });
    }

    @Override
    public DispositionActionDefinition getDispositionActionDefinition(String id) {
        DispositionActionDefinition actionDef;
        if (this.actions == null) {
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    DispositionScheduleImpl.this.getDispositionActionsImpl();
                    return null;
                }
            });
        }
        if ((actionDef = this.actionsById.get(id)) == null) {
            actionDef = this.actionsByName.get(id);
        }
        return actionDef;
    }

    @Override
    public DispositionActionDefinition getDispositionActionDefinitionByName(String name) {
        if (this.actionsByDispositionActionName == null) {
            this.getDispositionActionsImpl();
        }
        return this.actionsByDispositionActionName.get(name);
    }

    @Override
    public List<DispositionActionDefinition> getDispositionActionDefinitions() {
        if (this.actions == null) {
            this.getDispositionActionsImpl();
        }
        return this.actions;
    }

    private void getDispositionActionsImpl() {
        List assocs = this.nodeService.getChildAssocs(this.dispositionDefinitionNodeRef, (QNamePattern)ASSOC_DISPOSITION_ACTION_DEFINITIONS, RegexQNamePattern.MATCH_ALL);
        this.actions = new ArrayList<DispositionActionDefinition>(assocs.size());
        this.actionsById = new HashMap<String, DispositionActionDefinition>(assocs.size());
        this.actionsByName = new HashMap<String, DispositionActionDefinition>(assocs.size());
        this.actionsByDispositionActionName = new HashMap<String, DispositionActionDefinition>(assocs.size());
        int index = 0;
        for (ChildAssociationRef assoc : assocs) {
            String actionDefintionName;
            DispositionActionDefinitionImpl da = new DispositionActionDefinitionImpl(this.services.getRecordsManagementEventService(), this.services.getRecordsManagementActionService(), this.nodeService, assoc.getChildRef(), index);
            this.actions.add(da);
            this.actionsById.put(da.getId(), da);
            ++index;
            String actionNodeName = (String)((Object)this.nodeService.getProperty(assoc.getChildRef(), ContentModel.PROP_NAME));
            if (!actionNodeName.equals(da.getId())) {
                this.actionsByName.put(actionNodeName, da);
            }
            if ((actionDefintionName = (String)((Object)this.nodeService.getProperty(assoc.getChildRef(), PROP_DISPOSITION_ACTION_NAME))) == null) continue;
            this.actionsByDispositionActionName.put(actionDefintionName, da);
        }
    }
}

