/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class CustomLocalDateDeserializer
extends StdDeserializer<LocalDate> {
    private static final DateTimeFormatter LOCAL_DATE_OPTIONAL_TIME_PARSER = ISODateTimeFormat.localDateOptionalTimeParser();

    public CustomLocalDateDeserializer() {
        super(LocalDate.class);
    }

    public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String str = jp.getText().trim();
        if (str.length() == 0) {
            return null;
        }
        return LOCAL_DATE_OPTIONAL_TIME_PARSER.parseLocalDate(str);
    }
}

