/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.jscript.app.evaluator;

import java.util.Iterator;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.jscript.app.BaseEvaluator;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransferEvaluator
extends BaseEvaluator {
    private static Log logger = LogFactory.getLog(TransferEvaluator.class);
    private boolean transferAccessionIndicator = false;

    public void setTransferAccessionIndicator(boolean transferAccessionIndicator) {
        this.transferAccessionIndicator = transferAccessionIndicator;
    }

    @Override
    protected boolean evaluateImpl(NodeRef nodeRef) {
        boolean result = false;
        NodeRef transfer = this.getTransferNodeRef(nodeRef);
        if (transfer != null) {
            try {
                boolean actual = (Boolean)this.nodeService.getProperty(transfer, RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR);
                result = actual == this.transferAccessionIndicator;
            }
            catch (AccessDeniedException ade) {
                logger.info((Object)("The user '" + AuthenticationUtil.getFullyAuthenticatedUser() + "' does not have permissions on the node '" + String.valueOf(transfer) + "'."));
            }
        }
        return result;
    }

    private NodeRef getTransferNodeRef(NodeRef nodeRef) {
        NodeRef result;
        block2: {
            NodeRef recordFolder;
            block1: {
                result = null;
                List parents = this.nodeService.getParentAssocs(nodeRef, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
                if (parents.size() != 1) break block1;
                result = ((ChildAssociationRef)parents.get(0)).getParentRef();
                break block2;
            }
            if (!this.recordService.isRecord(nodeRef)) break block2;
            Iterator<NodeRef> iterator = this.recordFolderService.getRecordFolders(nodeRef).iterator();
            while (iterator.hasNext() && (result = this.getTransferNodeRef(recordFolder = iterator.next())) == null) {
            }
        }
        return result;
    }
}

