/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.vital;

import java.util.Date;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Period;

public class VitalRecordDefinitionImpl
implements VitalRecordDefinition,
RecordsManagementModel {
    private boolean enabled = false;
    private Period reviewPeriod = new Period("none|0");

    VitalRecordDefinitionImpl(boolean enabled, Period reviewPeriod) {
        this.enabled = enabled;
        if (reviewPeriod != null) {
            this.reviewPeriod = reviewPeriod;
        }
    }

    static VitalRecordDefinition create(NodeService nodeService, NodeRef nodeRef) {
        Boolean enabled = (Boolean)nodeService.getProperty(nodeRef, PROP_VITAL_RECORD_INDICATOR);
        if (enabled == null) {
            enabled = Boolean.FALSE;
        }
        Period reviewPeriod = (Period)nodeService.getProperty(nodeRef, PROP_REVIEW_PERIOD);
        return new VitalRecordDefinitionImpl(enabled, reviewPeriod);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Date getNextReviewDate() {
        return this.getReviewPeriod().getNextDate(new Date());
    }

    @Override
    public Period getReviewPeriod() {
        return this.reviewPeriod;
    }
}

