/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class RMDispositionActionExecuterAbstractBase
extends RMActionExecuterAbstractBase {
    private static final String MSG_RECORD_NOT_DECLARED = "rm.action.record-not-declared";
    private static final String MSG_EXPECTED_RECORD_LEVEL = "rm.action.expected-record-level";
    private static final String MSG_NOT_ALL_RECORDS_DECLARED = "rm.action.not-all-records-declared";
    private static final String MSG_NOT_ELIGIBLE = "rm.action.not-eligible";
    private static final String MSG_NO_DISPOITION_INSTRUCTIONS = "rm.action.no-disposition-instructions";
    private static final String MSG_NO_DIS_LIFECYCLE_SET = "rm.action.no-disposition-lisfecycle-set";
    private static final String MSG_NEXT_DISP_NOT_SET = "rm.action.next-disp-not-set";
    private static final String MSG_NOT_NEXT_DISP = "rm.action.not-next-disp";
    private static final String MSG_NOT_RECORD_FOLDER = "rm.action.not-record-folder";
    public static final String PARAM_NO_ERROR_CHECK = "rm.no-error-check";

    @Override
    public boolean isDispositionAction() {
        return true;
    }

    public boolean getSetDispositionActionComplete() {
        return true;
    }

    protected boolean checkNextDispositionAction(NodeRef actionedUponNodeRef) {
        return true;
    }

    protected boolean checkEligibility(NodeRef actionedUponNodeRef) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        DispositionSchedule di;
        NodeRef nextDispositionActionNodeRef = this.getNextDispostionAction(actionedUponNodeRef);
        boolean checkError = true;
        Boolean checkErrorValue = (Boolean)action.getParameterValue(PARAM_NO_ERROR_CHECK);
        if (checkErrorValue != null) {
            checkError = checkErrorValue;
        }
        if ((di = this.checkDispositionActionExecutionValidity(actionedUponNodeRef, nextDispositionActionNodeRef, checkError)) == null) return;
        if (this.checkEligibility(actionedUponNodeRef) && !this.getDispositionService().isNextDispositionActionEligible(actionedUponNodeRef)) throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_NOT_ELIGIBLE, (Object[])new Object[]{this.getName(), actionedUponNodeRef.toString()}));
        if (di.isRecordLevelDisposition()) {
            if (!this.getRecordService().isRecord(actionedUponNodeRef)) throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_EXPECTED_RECORD_LEVEL, (Object[])new Object[]{this.getName(), actionedUponNodeRef.toString()}));
            if (!this.getRecordService().isDeclared(actionedUponNodeRef)) throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_RECORD_NOT_DECLARED, (Object[])new Object[]{this.getName(), actionedUponNodeRef.toString()}));
            this.getNodeService().setProperty(nextDispositionActionNodeRef, PROP_DISPOSITION_ACTION_STARTED_AT, (Serializable)new Date());
            this.getNodeService().setProperty(nextDispositionActionNodeRef, PROP_DISPOSITION_ACTION_STARTED_BY, (Serializable)((Object)AuthenticationUtil.getRunAsUser()));
            this.executeRecordLevelDisposition(action, actionedUponNodeRef);
            if (this.getNodeService().exists(nextDispositionActionNodeRef) && this.getSetDispositionActionComplete()) {
                this.getNodeService().setProperty(nextDispositionActionNodeRef, PROP_DISPOSITION_ACTION_COMPLETED_AT, (Serializable)new Date());
                this.getNodeService().setProperty(nextDispositionActionNodeRef, PROP_DISPOSITION_ACTION_COMPLETED_BY, (Serializable)((Object)AuthenticationUtil.getRunAsUser()));
            }
        } else {
            if (!this.getRecordFolderService().isRecordFolder(actionedUponNodeRef)) throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_NOT_RECORD_FOLDER, (Object[])new Object[]{this.getName(), actionedUponNodeRef.toString()}));
            if (!this.getRecordFolderService().isRecordFolderDeclared(actionedUponNodeRef)) throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_NOT_ALL_RECORDS_DECLARED, (Object[])new Object[]{this.getName(), actionedUponNodeRef.toString()}));
            this.getNodeService().setProperty(nextDispositionActionNodeRef, PROP_DISPOSITION_ACTION_STARTED_AT, (Serializable)new Date());
            this.getNodeService().setProperty(nextDispositionActionNodeRef, PROP_DISPOSITION_ACTION_STARTED_BY, (Serializable)((Object)AuthenticationUtil.getRunAsUser()));
            this.executeRecordFolderLevelDisposition(action, actionedUponNodeRef);
            if (this.getNodeService().exists(nextDispositionActionNodeRef) && this.getSetDispositionActionComplete()) {
                this.getNodeService().setProperty(nextDispositionActionNodeRef, PROP_DISPOSITION_ACTION_COMPLETED_AT, (Serializable)new Date());
                this.getNodeService().setProperty(nextDispositionActionNodeRef, PROP_DISPOSITION_ACTION_COMPLETED_BY, (Serializable)((Object)AuthenticationUtil.getRunAsUser()));
            }
        }
        if (!this.getNodeService().exists(actionedUponNodeRef) || !this.getSetDispositionActionComplete()) return;
        this.getDispositionService().updateNextDispositionAction(actionedUponNodeRef);
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }

    protected abstract void executeRecordLevelDisposition(Action var1, NodeRef var2);

    protected abstract void executeRecordFolderLevelDisposition(Action var1, NodeRef var2);

    protected DispositionSchedule checkDispositionActionExecutionValidity(NodeRef nodeRef, NodeRef nextDispositionActionNodeRef, boolean throwError) {
        DispositionSchedule di = this.getDispositionService().getDispositionSchedule(nodeRef);
        if (di == null) {
            if (throwError) {
                throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_NO_DISPOITION_INSTRUCTIONS, (Object[])new Object[]{this.getName(), nodeRef.toString()}));
            }
            return null;
        }
        if (!this.getNodeService().hasAspect(nodeRef, ASPECT_DISPOSITION_LIFECYCLE)) {
            if (throwError) {
                throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_NO_DIS_LIFECYCLE_SET, (Object[])new Object[]{this.getName(), nodeRef.toString()}));
            }
            return null;
        }
        if (this.checkNextDispositionAction(nodeRef)) {
            NodeRef nextDispositionAction = nextDispositionActionNodeRef;
            if (nextDispositionAction == null) {
                if (throwError) {
                    throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_NEXT_DISP_NOT_SET, (Object[])new Object[]{this.getName(), nodeRef.toString()}));
                }
                return null;
            }
            String actionName = (String)((Object)this.getNodeService().getProperty(nextDispositionAction, PROP_DISPOSITION_ACTION));
            if (actionName == null || !actionName.equals(this.getName())) {
                if (throwError) {
                    throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_NOT_NEXT_DISP, (Object[])new Object[]{this.getName(), nodeRef.toString()}));
                }
                return null;
            }
        }
        return di;
    }

    private NodeRef getNextDispostionAction(NodeRef nodeRef) {
        NodeRef result = null;
        List assocs = this.getNodeService().getChildAssocs(nodeRef, (QNamePattern)ASSOC_NEXT_DISPOSITION_ACTION, RegexQNamePattern.MATCH_ALL);
        if (assocs.size() != 0) {
            result = ((ChildAssociationRef)assocs.get(0)).getChildRef();
        }
        return result;
    }
}

