/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.module.org_alfresco_module_rm.script.AbstractRmWebScript;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CustomPropertyDefinitionDelete
extends AbstractRmWebScript {
    private static final String PROP_ID = "propId";
    private static Log logger = LogFactory.getLog(CustomPropertyDefinitionDelete.class);
    private RecordsManagementAdminService rmAdminService;

    public void setRecordsManagementAdminService(RecordsManagementAdminService rmAdminService) {
        this.rmAdminService = rmAdminService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map<String, Object> ftlModel = null;
        try {
            QName propQName = this.getPropertyFromReq(req);
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Deleting property definition ").append(propQName);
                logger.debug((Object)msg.toString());
            }
            ftlModel = this.removePropertyDefinition(propQName);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        return ftlModel;
    }

    private QName getPropertyFromReq(WebScriptRequest req) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String propIdString = (String)templateVars.get(PROP_ID);
        QName propQName = this.rmAdminService.getQNameForClientId(propIdString);
        Map<QName, PropertyDefinition> existingPropDefs = this.rmAdminService.getCustomPropertyDefinitions();
        if (!existingPropDefs.containsKey(propQName)) {
            throw new WebScriptException(404, "Requested property definition (id:" + propIdString + ") does not exist");
        }
        return propQName;
    }

    protected Map<String, Object> removePropertyDefinition(QName propQName) throws JSONException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.rmAdminService.removeCustomPropertyDefinition(propQName);
        result.put("propertyqname", propQName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
        return result;
    }
}

