/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.destroy;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.content.ContentDestructionComponent;
import org.alfresco.module.org_alfresco_module_rm.content.EagerContentStoreCleaner;
import org.alfresco.module.org_alfresco_module_rm.content.cleanser.ContentCleanser;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.TestContentCleanser;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;

public class DestroyContentTest
extends BaseRMTestCase {
    private static final String BEAN_NAME_CONTENT_CLEANSER = "contentCleanser.test";
    protected ContentStore contentStore;
    protected TestContentCleanser contentCleanser;
    protected ContentDestructionComponent contentDestructionComponent;
    private EagerContentStoreCleaner eagerContentStoreCleaner;
    private RenditionService renditionService;

    @Override
    protected void initServices() {
        super.initServices();
        this.contentStore = (ContentStore)this.applicationContext.getBean("fileContentStore");
        this.contentCleanser = (TestContentCleanser)((Object)this.applicationContext.getBean(BEAN_NAME_CONTENT_CLEANSER));
        this.eagerContentStoreCleaner = (EagerContentStoreCleaner)this.applicationContext.getBean("eagerContentStoreCleaner");
        this.contentDestructionComponent = (ContentDestructionComponent)this.applicationContext.getBean("contentDestructionComponent");
        this.renditionService = (RenditionService)this.applicationContext.getBean("renditionService");
        this.eagerContentStoreCleaner.setContentCleanser((ContentCleanser)this.contentCleanser);
    }

    public void testRecordFolderDestroy() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef recordCategoryFolderLevel;
            private NodeRef destroyableFolder;
            private NodeRef subRecord;

            @Override
            public void given() throws Exception {
                this.recordCategoryFolderLevel = DestroyContentTest.this.filePlanService.createRecordCategory(DestroyContentTest.this.filePlan, GUID.generate());
                DestroyContentTest.this.utils.createBasicDispositionSchedule(this.recordCategoryFolderLevel, "disposition instructions", "disposition authority", false, true);
                this.destroyableFolder = DestroyContentTest.this.recordFolderService.createRecordFolder(this.recordCategoryFolderLevel, GUID.generate());
                HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
                props.put(ContentModel.PROP_TITLE, (Serializable)((Object)GUID.generate()));
                InputStream is = DestroyContentTest.class.getResourceAsStream("/alfresco/test/content/Image.jpg");
                this.subRecord = DestroyContentTest.this.utils.createRecord(this.destroyableFolder, GUID.generate(), props, "image/jpeg", is);
                DestroyContentTest.this.utils.completeRecord(this.subRecord);
                DestroyContentTest.this.utils.completeEvent(this.destroyableFolder, "case_closed");
                DestroyContentTest.this.rmActionService.executeRecordsManagementAction(this.destroyableFolder, "cutoff");
                TestCase.assertEquals((String)"destroy", (String)DestroyContentTest.this.dispositionService.getNextDispositionAction(this.destroyableFolder).getName());
                TestCase.assertTrue((boolean)DestroyContentTest.this.dispositionService.isNextDispositionActionEligible(this.destroyableFolder));
                DestroyContentTest.this.contentCleanser.reset();
                TestCase.assertFalse((boolean)DestroyContentTest.this.contentDestructionComponent.isCleansingEnabled());
            }

            @Override
            public void when() throws Exception {
                DestroyContentTest.this.rmActionService.executeRecordsManagementAction(this.destroyableFolder, "destroy");
            }

            @Override
            public void then() throws Exception {
                TestCase.assertTrue((boolean)DestroyContentTest.this.nodeService.exists(this.destroyableFolder));
                TestCase.assertTrue((boolean)DestroyContentTest.this.nodeService.hasAspect(this.destroyableFolder, RecordsManagementModel.ASPECT_GHOSTED));
                TestCase.assertTrue((boolean)DestroyContentTest.this.nodeService.exists(this.subRecord));
                TestCase.assertTrue((boolean)DestroyContentTest.this.nodeService.hasAspect(this.subRecord, RecordsManagementModel.ASPECT_GHOSTED));
                ContentReader reader = DestroyContentTest.this.contentService.getReader(this.subRecord, ContentModel.PROP_CONTENT);
                TestCase.assertNull((Object)reader);
                TestCase.assertFalse((boolean)DestroyContentTest.this.contentCleanser.hasCleansed());
                NodeRef archiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, this.subRecord.getId());
                TestCase.assertFalse((boolean)DestroyContentTest.this.nodeService.exists(archiveNodeRef));
            }
        });
    }

    public void testRecordDestroy() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef recordCategoryRecordLevel;
            private NodeRef recordFolder;
            private NodeRef destroyableRecord;

            @Override
            public void given() throws Exception {
                this.recordCategoryRecordLevel = DestroyContentTest.this.filePlanService.createRecordCategory(DestroyContentTest.this.filePlan, GUID.generate());
                DestroyContentTest.this.utils.createBasicDispositionSchedule(this.recordCategoryRecordLevel, "disposition instructions", "disposition authority", true, true);
                this.recordFolder = DestroyContentTest.this.recordFolderService.createRecordFolder(this.recordCategoryRecordLevel, GUID.generate());
                this.destroyableRecord = DestroyContentTest.this.utils.createRecord(this.recordFolder, GUID.generate(), GUID.generate());
                DestroyContentTest.this.utils.completeRecord(this.destroyableRecord);
                DestroyContentTest.this.utils.completeEvent(this.destroyableRecord, "case_closed");
                DestroyContentTest.this.rmActionService.executeRecordsManagementAction(this.destroyableRecord, "cutoff");
                TestCase.assertEquals((String)"destroy", (String)DestroyContentTest.this.dispositionService.getNextDispositionAction(this.destroyableRecord).getName());
                TestCase.assertTrue((boolean)DestroyContentTest.this.dispositionService.isNextDispositionActionEligible(this.destroyableRecord));
                DestroyContentTest.this.contentCleanser.reset();
                TestCase.assertFalse((boolean)DestroyContentTest.this.contentDestructionComponent.isCleansingEnabled());
            }

            @Override
            public void when() throws Exception {
                DestroyContentTest.this.rmActionService.executeRecordsManagementAction(this.destroyableRecord, "destroy");
            }

            @Override
            public void then() throws Exception {
                TestCase.assertTrue((boolean)DestroyContentTest.this.nodeService.exists(this.destroyableRecord));
                TestCase.assertTrue((boolean)DestroyContentTest.this.nodeService.hasAspect(this.destroyableRecord, RecordsManagementModel.ASPECT_GHOSTED));
                ContentReader reader = DestroyContentTest.this.contentService.getReader(this.destroyableRecord, ContentModel.PROP_CONTENT);
                TestCase.assertNull((Object)reader);
                TestCase.assertFalse((boolean)DestroyContentTest.this.contentCleanser.hasCleansed());
                NodeRef archiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, this.destroyableRecord.getId());
                TestCase.assertFalse((boolean)DestroyContentTest.this.nodeService.exists(archiveNodeRef));
            }
        });
    }

    public void testRecordDestroyAndCleanse() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef recordCategoryRecordLevel;
            private NodeRef recordFolder;
            private NodeRef destroyableRecord;

            @Override
            public void given() throws Exception {
                this.recordCategoryRecordLevel = DestroyContentTest.this.filePlanService.createRecordCategory(DestroyContentTest.this.filePlan, GUID.generate());
                DestroyContentTest.this.utils.createBasicDispositionSchedule(this.recordCategoryRecordLevel, "disposition instructions", "disposition authority", true, true);
                this.recordFolder = DestroyContentTest.this.recordFolderService.createRecordFolder(this.recordCategoryRecordLevel, GUID.generate());
                this.destroyableRecord = DestroyContentTest.this.utils.createRecord(this.recordFolder, GUID.generate(), GUID.generate());
                DestroyContentTest.this.utils.completeRecord(this.destroyableRecord);
                DestroyContentTest.this.utils.completeEvent(this.destroyableRecord, "case_closed");
                DestroyContentTest.this.rmActionService.executeRecordsManagementAction(this.destroyableRecord, "cutoff");
                TestCase.assertEquals((String)"destroy", (String)DestroyContentTest.this.dispositionService.getNextDispositionAction(this.destroyableRecord).getName());
                TestCase.assertTrue((boolean)DestroyContentTest.this.dispositionService.isNextDispositionActionEligible(this.destroyableRecord));
                DestroyContentTest.this.contentCleanser.reset();
                DestroyContentTest.this.contentDestructionComponent.setCleansingEnabled(true);
                TestCase.assertTrue((boolean)DestroyContentTest.this.contentDestructionComponent.isCleansingEnabled());
            }

            @Override
            public void when() throws Exception {
                DestroyContentTest.this.rmActionService.executeRecordsManagementAction(this.destroyableRecord, "destroy");
            }

            @Override
            public void then() throws Exception {
                TestCase.assertTrue((boolean)DestroyContentTest.this.nodeService.exists(this.destroyableRecord));
                TestCase.assertTrue((boolean)DestroyContentTest.this.nodeService.hasAspect(this.destroyableRecord, RecordsManagementModel.ASPECT_GHOSTED));
                ContentReader reader = DestroyContentTest.this.contentService.getReader(this.destroyableRecord, ContentModel.PROP_CONTENT);
                TestCase.assertNull((Object)reader);
                TestCase.assertTrue((boolean)DestroyContentTest.this.contentCleanser.hasCleansed());
                NodeRef archiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, this.destroyableRecord.getId());
                TestCase.assertFalse((boolean)DestroyContentTest.this.nodeService.exists(archiveNodeRef));
            }

            @Override
            public void after() throws Exception {
                DestroyContentTest.this.contentDestructionComponent.setCleansingEnabled(false);
            }
        });
    }

    public void testContentDelete() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef deleteableContent;
            private ContentData contentData;

            @Override
            public void given() throws Exception {
                TestCase.assertTrue((boolean)DestroyContentTest.this.nodeService.exists(DestroyContentTest.this.folder));
                this.deleteableContent = DestroyContentTest.this.fileFolderService.create(DestroyContentTest.this.folder, "myDocument.txt", ContentModel.TYPE_CONTENT).getNodeRef();
                ContentWriter writer = DestroyContentTest.this.fileFolderService.getWriter(this.deleteableContent);
                writer.setEncoding("UTF-8");
                writer.setMimetype("text/plain");
                writer.putContent(GUID.generate());
                this.contentData = (ContentData)DestroyContentTest.this.nodeService.getProperty(this.deleteableContent, ContentModel.PROP_CONTENT);
                TestCase.assertNotNull((Object)this.contentData);
                TestCase.assertTrue((boolean)DestroyContentTest.this.contentStore.exists(this.contentData.getContentUrl()));
                DestroyContentTest.this.contentCleanser.reset();
                TestCase.assertFalse((boolean)DestroyContentTest.this.contentDestructionComponent.isCleansingEnabled());
            }

            @Override
            public void when() throws Exception {
                DestroyContentTest.this.nodeService.deleteNode(this.deleteableContent);
            }

            @Override
            public void then() throws Exception {
                TestCase.assertFalse((boolean)DestroyContentTest.this.nodeService.exists(this.deleteableContent));
                TestCase.assertTrue((boolean)DestroyContentTest.this.contentStore.exists(this.contentData.getContentUrl()));
                TestCase.assertFalse((boolean)DestroyContentTest.this.contentCleanser.hasCleansed());
                NodeRef archiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, this.deleteableContent.getId());
                TestCase.assertTrue((boolean)DestroyContentTest.this.nodeService.exists(archiveNodeRef));
            }
        });
    }
}

