/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.util.PropertyModificationAllowedCheck;
import org.alfresco.service.namespace.QName;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class PropertyModificationAllowedCheckUnitTest {
    private PropertyModificationAllowedCheck propertyModificationAllowedCheck;
    private Map<QName, Serializable> before;
    private Map<QName, Serializable> after;
    private QName qName;
    private QName qName2;
    private List<QName> list;
    private List<String> editableURIs;
    @Mock
    private Serializable serializable;
    @Mock
    private Serializable serializable2;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.propertyModificationAllowedCheck = new PropertyModificationAllowedCheck();
        this.before = new HashMap<QName, Serializable>();
        this.after = new HashMap<QName, Serializable>();
        this.qName = QName.createQName((String)"foo", (String)"bar");
        this.qName2 = QName.createQName((String)"bar", (String)"foo");
        this.before.put(this.qName, this.serializable);
        this.after.put(this.qName, this.serializable2);
        this.list = new ArrayList<QName>();
        this.editableURIs = new ArrayList<String>();
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        this.propertyModificationAllowedCheck.setEditableURIs(this.editableURIs);
    }

    @Test
    public void testCheckMethodReturnsTrueWhenPropertyInList() {
        this.list.add(this.qName);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertTrue((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testCheckMethodReturnsFalseIfAnyNonAllowedPropertyInListIsChanged() {
        this.list.add(this.qName);
        this.before.put(this.qName2, this.serializable2);
        this.after.put(this.qName2, this.serializable);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertFalse((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testCheckMethodReturnsFalseIfFirstPropertyInListIsChangedWithoutWhitelist() {
        this.list.add(this.qName2);
        this.before.put(this.qName2, this.serializable2);
        this.after.put(this.qName2, this.serializable);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertFalse((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testCheckMethodReturnsTrueIfAllEditedPropertiesInWhitelist() {
        this.list.add(this.qName);
        this.list.add(this.qName2);
        this.before.put(this.qName2, this.serializable2);
        this.after.put(this.qName2, this.serializable);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertTrue((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testCheckMethodReturnsFalseIfPropertyNotInBeforeList() {
        this.list.add(this.qName);
        this.after.put(this.qName2, this.serializable);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertFalse((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testCheckMethodReturnsTrueIfAllowedPropertyNotInBeforeList() {
        this.list.add(this.qName2);
        this.after.put(this.qName2, this.serializable);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertFalse((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testCheckMethodReturnsFalseIfPropertyNotInAfterList() {
        this.list.add(this.qName);
        this.before.put(this.qName2, this.serializable);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertFalse((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testCheckMethodReturnsTrueIfAllowedPropertyNotInAfterList() {
        this.list.add(this.qName);
        this.list.add(this.qName2);
        this.before.put(this.qName2, this.serializable);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertTrue((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testNullValueInBeforeList() {
        this.before.put(this.qName, null);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertFalse((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testNullValueInAfterList() {
        this.after.put(this.qName, null);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertFalse((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testNullValueInBeforeListWithAllowedProperty() {
        this.list.add(this.qName);
        this.before.put(this.qName, null);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertTrue((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testNullValueInAfterListWithAllowedProperty() {
        this.list.add(this.qName);
        this.after.put(this.qName, null);
        this.propertyModificationAllowedCheck.setWhiteList(this.list);
        TestCase.assertTrue((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testNullValueInBoth() {
        this.before.put(this.qName, null);
        this.after.put(this.qName, null);
        TestCase.assertTrue((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testUpdatePropertyFromAllowedModelURI() {
        this.editableURIs.add("foo");
        this.propertyModificationAllowedCheck.setEditableURIs(this.editableURIs);
        TestCase.assertTrue((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }

    @Test
    public void testUpdatePropertyFromNotAllowedModelURI() {
        this.editableURIs.add("bar");
        this.propertyModificationAllowedCheck.setEditableURIs(this.editableURIs);
        TestCase.assertFalse((boolean)this.propertyModificationAllowedCheck.check(this.before, this.after));
    }
}

