/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.holds;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.holds.HoldsEntityResource;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.HoldChild;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.I18NUtil;

@RelationshipResource(name="children", entityResource=HoldsEntityResource.class, title="Children of a hold")
public class HoldsChildrenRelation
implements RelationshipResourceAction.Create<HoldChild>,
RelationshipResourceAction.Read<HoldChild>,
RelationshipResourceAction.Delete,
InitializingBean {
    private HoldService holdService;
    private FilePlanComponentsApiUtils apiUtils;
    private ApiNodesModelFactory nodesModelFactory;
    private TransactionService transactionService;
    private FileFolderService fileFolderService;
    private PermissionService permissionService;

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"holdService", (Object)this.holdService);
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"nodesModelFactory", (Object)this.nodesModelFactory);
        ParameterCheck.mandatory((String)"transactionService", (Object)this.transactionService);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
    }

    @WebApiDescription(title="Add one (or more) children as children of a hold identified by 'holdId'")
    public List<HoldChild> create(String holdId, List<HoldChild> children, Parameters parameters) {
        RMParameterCheck.checkNotBlank("holdId", holdId);
        ParameterCheck.mandatory((String)"children", children);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(holdId, RecordsManagementModel.TYPE_HOLD);
        RetryingTransactionHelper.RetryingTransactionCallback callback = () -> {
            List<NodeRef> createdNodes = children.stream().map(holdChild -> new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, holdChild.id())).collect(Collectors.toList());
            try {
                this.holdService.addToHold(parentNodeRef, createdNodes);
            }
            catch (IntegrityException exception) {
                throw new InvalidArgumentException(exception.getMsgId()).initCause((Throwable)exception);
            }
            return createdNodes;
        };
        List nodeInfos = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
        return nodeInfos.stream().map(nodeRef -> new HoldChild(nodeRef.getId())).collect(Collectors.toCollection(LinkedList::new));
    }

    @WebApiDescription(title="Return a paged list of hold children for the hold identified by 'holdId'")
    public CollectionWithPagingInfo<HoldChild> readAll(String holdId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("holdId", holdId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(holdId, RecordsManagementModel.TYPE_HOLD);
        List<NodeRef> children = this.holdService.getHeld(parentNodeRef);
        List page = children.stream().map(NodeRef::getId).map(HoldChild::new).skip(parameters.getPaging().getSkipCount()).limit(parameters.getPaging().getMaxItems()).collect(Collectors.toCollection(LinkedList::new));
        int totalItems = children.size();
        boolean hasMore = parameters.getPaging().getSkipCount() + parameters.getPaging().getMaxItems() < totalItems;
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), (Collection)page, (boolean)hasMore, (Integer)totalItems);
    }

    @WebApiDescription(title="Remove a child from a hold", description="Remove a child with id 'childId' from a hold with id 'holdId'")
    public void delete(String holdId, String childId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("holdId", holdId);
        RMParameterCheck.checkNotBlank("childId", childId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(holdId, RecordsManagementModel.TYPE_HOLD);
        NodeRef childRef = this.apiUtils.lookupByPlaceholder(childId);
        if (this.permissionService.hasReadPermission(childRef) == AccessStatus.DENIED) {
            throw new PermissionDeniedException(I18NUtil.getMessage((String)"permissions.err_access_denied"));
        }
        RetryingTransactionHelper.RetryingTransactionCallback callback = () -> {
            try {
                this.holdService.removeFromHold(nodeRef, childRef);
            }
            catch (IntegrityException exception) {
                throw new InvalidArgumentException(exception.getMsgId()).initCause((Throwable)exception);
            }
            return null;
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
    }

    public void setHoldService(HoldService holdService) {
        this.holdService = holdService;
    }

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

