/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.version;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementCustomModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.CmObjectType;
import org.alfresco.module.org_alfresco_module_rm.model.security.ModelSecurityService;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.security.ExtendedSecurityService;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionPolicy;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionService;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.impl.ExtendedPermissionService;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.Version2ServiceImpl;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.ReservedVersionNameException;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.extensions.surf.util.I18NUtil;

public class RecordableVersionServiceImpl
extends Version2ServiceImpl
implements RecordableVersionModel,
RecordableVersionService {
    private static Log logger = LogFactory.getLog(Version2ServiceImpl.class);
    public static final String KEY_RECORDABLE_VERSION = "recordable-version";
    public static final String KEY_FILE_PLAN = "file-plan";
    protected static final String PROP_VERSION_RECORD = "RecordVersion";
    protected static final String PROP_RECORDED_VERSION_DESTROYED = "RecordedVersionDestroyed";
    private static final String AUTO_VERSION_ON_RECORD_CREATION = "rm.service.enable-autoversion-on-record-creation";
    private boolean isEnableAutoVersionOnRecordCreation = false;
    private static final String[] VERSION_PROPERTY_NAMES = new String[]{Version2Model.PROP_CREATED_DATE, "versionLabel", "versionDescription", "frozenNodeDbId", "frozenNodeRef", "frozenCreated", "frozenCreator", "frozenModified", "frozenModifier", "frozenAccessed"};
    private FilePlanService filePlanService;
    private AuthenticationUtil authenticationUtil;
    private RelationshipService relationshipService;
    private RecordService recordService;
    private ModelSecurityService modelSecurityService;
    private CmObjectType cmObjectType;
    private ExtendedPermissionService extendedPermissionService;
    private ExtendedSecurityService extendedSecurityService;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setAuthenticationUtil(AuthenticationUtil authenticationUtil) {
        this.authenticationUtil = authenticationUtil;
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setModelSecurityService(ModelSecurityService modelSecurityService) {
        this.modelSecurityService = modelSecurityService;
    }

    public void setCmObjectType(CmObjectType cmObjectType) {
        this.cmObjectType = cmObjectType;
    }

    public void setExtendedPermissionService(ExtendedPermissionService extendedPermissionService) {
        this.extendedPermissionService = extendedPermissionService;
    }

    public void setExtendedSecurityService(ExtendedSecurityService extendedSecurityService) {
        this.extendedSecurityService = extendedSecurityService;
    }

    public void setEnableAutoVersionOnRecordCreation(boolean isEnableAutoVersionOnRecordCreation) {
        this.isEnableAutoVersionOnRecordCreation = isEnableAutoVersionOnRecordCreation;
    }

    @Override
    public boolean isEnableAutoVersionOnRecordCreation() {
        return this.isEnableAutoVersionOnRecordCreation;
    }

    protected Version createVersion(NodeRef nodeRef, Map<String, Serializable> origVersionProperties, int versionNumber) throws ReservedVersionNameException {
        if (origVersionProperties == null) {
            origVersionProperties = new HashMap<String, Serializable>(2);
        }
        if (!origVersionProperties.containsKey(KEY_RECORDABLE_VERSION)) {
            VersionType versionType = null;
            if (origVersionProperties != null) {
                versionType = (VersionType)origVersionProperties.get("versionType");
            }
            if (this.isCreateRecordedVersion(nodeRef, versionType)) {
                origVersionProperties.put(KEY_RECORDABLE_VERSION, Boolean.valueOf(true));
                if (!origVersionProperties.containsKey(KEY_FILE_PLAN)) {
                    origVersionProperties.put(KEY_FILE_PLAN, (Serializable)this.getFilePlan(nodeRef));
                }
            }
        } else if (!origVersionProperties.containsKey(KEY_FILE_PLAN)) {
            origVersionProperties.put(KEY_FILE_PLAN, (Serializable)this.getFilePlan(nodeRef));
        }
        return super.createVersion(nodeRef, origVersionProperties, versionNumber);
    }

    private NodeRef getFilePlan(NodeRef nodeRef) {
        NodeRef filePlan = (NodeRef)this.nodeService.getProperty(nodeRef, PROP_FILE_PLAN);
        if (filePlan == null) {
            filePlan = this.getFilePlan();
        }
        return filePlan;
    }

    private NodeRef getFilePlan() {
        return this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef filePlan = RecordableVersionServiceImpl.this.filePlanService.getFilePlanBySiteId("rm");
                if (filePlan == null) {
                    throw new AlfrescoRuntimeException("Can't create a recorded version, because there is no file plan.");
                }
                return filePlan;
            }
        });
    }

    private boolean isCreateRecordedVersion(NodeRef nodeRef, VersionType versionType) {
        RecordableVersionPolicy policy;
        String policyString;
        boolean result = false;
        if (this.nodeService.hasAspect(nodeRef, RecordableVersionModel.ASPECT_VERSIONABLE) && (policyString = (String)((Object)this.nodeService.getProperty(nodeRef, PROP_RECORDABLE_VERSION_POLICY))) != null && (RecordableVersionPolicy.ALL.equals((Object)(policy = RecordableVersionPolicy.valueOf(policyString.toUpperCase()))) || RecordableVersionPolicy.MAJOR_ONLY.equals((Object)policy) && VersionType.MAJOR.equals((Object)versionType))) {
            result = true;
        }
        return result;
    }

    protected NodeRef createNewVersion(QName sourceTypeRef, NodeRef versionHistoryRef, Map<QName, Serializable> standardVersionProperties, Map<String, Serializable> versionProperties, int versionNumber, PolicyScope nodeDetails) {
        NodeRef version = null;
        version = versionProperties.containsKey(KEY_RECORDABLE_VERSION) && (Boolean)versionProperties.get(KEY_RECORDABLE_VERSION) != false ? this.createNewRecordedVersion(sourceTypeRef, versionHistoryRef, standardVersionProperties, versionProperties, versionNumber, nodeDetails) : super.createNewVersion(sourceTypeRef, versionHistoryRef, standardVersionProperties, versionProperties, versionNumber, nodeDetails);
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeRef createNewRecordedVersion(QName sourceTypeRef, NodeRef versionHistoryRef, Map<QName, Serializable> standardVersionProperties, Map<String, Serializable> versionProperties, int versionNumber, PolicyScope nodeDetails) {
        NodeRef versionNodeRef = null;
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.TYPE_MULTILINGUAL_CONTAINER);
        this.modelSecurityService.disable();
        this.recordService.disablePropertyEditableCheck();
        try {
            NodeRef filePlan = (NodeRef)versionProperties.get(KEY_FILE_PLAN);
            if (filePlan == null) {
                throw new AlfrescoRuntimeException("Can't create a new recorded version, because no file plan has been specified in the version properties.");
            }
            NodeRef nodeRef = (NodeRef)standardVersionProperties.get(Version2Model.PROP_QNAME_FROZEN_NODE_REF);
            this.cmObjectType.disableCopy();
            try {
                final NodeRef record = this.recordService.createRecordFromCopy(filePlan, nodeRef);
                final PropertyMap versionRecordProps = new PropertyMap(3);
                versionRecordProps.put((Object)PROP_VERSIONED_NODEREF, (Object)nodeRef);
                versionRecordProps.put((Object)RecordableVersionModel.PROP_VERSION_LABEL, (Object)standardVersionProperties.get(QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)"versionLabel")));
                versionRecordProps.put((Object)RecordableVersionModel.PROP_VERSION_DESCRIPTION, (Object)standardVersionProperties.get(QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)"versionDescription")));
                this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        RecordableVersionServiceImpl.this.nodeService.addAspect(record, RecordableVersionModel.ASPECT_VERSION_RECORD, (Map)versionRecordProps);
                        return null;
                    }
                });
                this.linkToPreviousVersionRecord(nodeRef, record);
                ChildAssociationRef childAssocRef = this.dbNodeService.createNode(versionHistoryRef, Version2Model.CHILD_QNAME_VERSIONS, QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)("version-" + versionNumber)), sourceTypeRef, null);
                if (this.isUseVersionAssocIndex()) {
                    this.nodeService.setChildAssociationIndex(childAssocRef, this.getAllVersions(versionHistoryRef).size());
                }
                versionNodeRef = childAssocRef.getChildRef();
                this.nodeService.addAspect(versionNodeRef, Version2Model.ASPECT_VERSION, standardVersionProperties);
                this.nodeService.addAspect(versionNodeRef, ASPECT_RECORDED_VERSION, Collections.singletonMap(PROP_RECORD_NODE_REF, record));
                this.freezeAuditableAspect(nodeRef, versionNodeRef);
            }
            finally {
                this.cmObjectType.enableCopy();
            }
        }
        finally {
            this.modelSecurityService.enable();
            this.recordService.enablePropertyEditableCheck();
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.TYPE_MULTILINGUAL_CONTAINER);
        }
        if (!this.dbNodeService.hasAspect(versionNodeRef, ContentModel.ASPECT_AUDITABLE)) {
            this.dbNodeService.addAspect(versionNodeRef, ContentModel.ASPECT_AUDITABLE, null);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createNewRecordedVersion created (" + versionNumber + ") " + String.valueOf(versionNodeRef)));
        }
        return versionNodeRef;
    }

    private void linkToPreviousVersionRecord(NodeRef nodeRef, final NodeRef record) {
        final NodeRef latestRecordVersion = this.getLatestVersionRecord(nodeRef);
        if (latestRecordVersion != null) {
            this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    RecordableVersionServiceImpl.this.relationshipService.addRelationship(RecordsManagementCustomModel.CUSTOM_REF_VERSIONS.getLocalName(), record, latestRecordVersion);
                    return null;
                }
            });
        }
    }

    private NodeRef getLatestVersionRecord(NodeRef nodeRef) {
        NodeRef versionRecord = null;
        VersionHistory versionHistory = this.getVersionHistory(nodeRef);
        if (versionHistory != null) {
            Collection previousVersions = versionHistory.getAllVersions();
            for (Version previousVersion : previousVersions) {
                NodeRef previousRecord = (NodeRef)previousVersion.getVersionProperties().get(PROP_VERSION_RECORD);
                if (previousRecord == null || !this.nodeService.exists(previousRecord)) continue;
                versionRecord = previousRecord;
                break;
            }
        }
        return versionRecord;
    }

    @Override
    public Version getRecordedVersion(NodeRef versionRecord) {
        VersionHistory versionHistory;
        String versionLabel;
        Version version = null;
        NodeRef versionedNodeRef = (NodeRef)this.nodeService.getProperty(versionRecord, RecordableVersionModel.PROP_VERSIONED_NODEREF);
        if (versionedNodeRef != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(versionLabel = (String)((Object)this.nodeService.getProperty(versionRecord, RecordableVersionModel.PROP_VERSION_LABEL)))) && (versionHistory = this.getVersionHistory(versionedNodeRef)) != null) {
            version = versionHistory.getVersion(versionLabel);
        }
        return version;
    }

    private void freezeAuditableAspect(NodeRef nodeRef, NodeRef versionNodeRef) {
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_AUDITABLE)) {
            Map properties = this.dbNodeService.getProperties(nodeRef);
            this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_CREATOR, (Serializable)properties.get(ContentModel.PROP_CREATOR));
            this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_CREATED, (Serializable)properties.get(ContentModel.PROP_CREATED));
            this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_MODIFIER, (Serializable)properties.get(ContentModel.PROP_MODIFIER));
            this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_MODIFIED, (Serializable)properties.get(ContentModel.PROP_MODIFIED));
            this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_ACCESSED, (Serializable)properties.get(ContentModel.PROP_ACCESSED));
            if (properties.get(ContentModel.PROP_OWNER) != null) {
                this.dbNodeService.setProperty(versionNodeRef, PROP_FROZEN_OWNER, (Serializable)properties.get(ContentModel.PROP_OWNER));
            }
        }
    }

    protected Version getVersion(NodeRef versionRef) {
        Boolean destroyed;
        Version version = super.getVersion(versionRef);
        NodeRef record = (NodeRef)this.dbNodeService.getProperty(versionRef, PROP_RECORD_NODE_REF);
        if (record != null) {
            version.getVersionProperties().put(PROP_VERSION_RECORD, record);
        }
        if ((destroyed = (Boolean)this.dbNodeService.getProperty(versionRef, PROP_DESTROYED)) == null) {
            destroyed = Boolean.FALSE;
        }
        version.getVersionProperties().put(PROP_RECORDED_VERSION_DESTROYED, destroyed);
        return version;
    }

    public void revert(NodeRef nodeRef, Version version, boolean deep) {
        String versionPolicy = (String)((Object)this.dbNodeService.getProperty(nodeRef, PROP_RECORDABLE_VERSION_POLICY));
        super.revert(nodeRef, version, deep);
        if (StringUtils.isNotBlank((String)versionPolicy)) {
            this.dbNodeService.setProperty(nodeRef, PROP_RECORDABLE_VERSION_POLICY, (Serializable)((Object)versionPolicy));
        }
    }

    @Override
    public boolean isCurrentVersionRecorded(NodeRef nodeRef) {
        boolean result = false;
        Version version = this.getCurrentVersion(nodeRef);
        if (version != null) {
            result = this.isRecordedVersion(version);
        }
        return result;
    }

    @Override
    public boolean isRecordedVersion(Version version) {
        NodeRef versionNodeRef = this.getVersionNodeRef(version);
        return this.dbNodeService.hasAspect(versionNodeRef, RecordableVersionModel.ASPECT_RECORDED_VERSION);
    }

    @Override
    public NodeRef getVersionRecord(Version version) {
        NodeRef result = null;
        NodeRef versionNodeRef = this.getVersionNodeRef(version);
        if (this.dbNodeService.hasAspect(versionNodeRef, RecordableVersionModel.ASPECT_RECORDED_VERSION) && (result = (NodeRef)this.dbNodeService.getProperty(versionNodeRef, RecordableVersionModel.PROP_RECORD_NODE_REF)) != null && !this.dbNodeService.exists(result)) {
            throw new AlfrescoRuntimeException("Version record node doesn't exist.  Indicates version has not been updated when associated version record was deleted. (nodeRef=" + result.toString() + ")");
        }
        return result;
    }

    public StoreRef convertStoreRef(StoreRef storeRef) {
        return new StoreRef("workspace", storeRef.getIdentifier());
    }

    public NodeRef convertNodeRef(NodeRef nodeRef) {
        return new NodeRef(this.convertStoreRef(nodeRef.getStoreRef()), nodeRef.getId());
    }

    @Override
    public NodeRef createRecordFromLatestVersion(NodeRef filePlan, NodeRef nodeRef, boolean isEnableAutoVersionOnRecordCreation) {
        this.setEnableAutoVersionOnRecordCreation(isEnableAutoVersionOnRecordCreation);
        return this.createRecordFromLatestVersion(filePlan, nodeRef);
    }

    @Override
    public NodeRef createRecordFromLatestVersion(final NodeRef filePlan, final NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        NodeRef record = null;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            this.createSnapshotVersion(nodeRef);
            final Version currentVersion = this.getCurrentVersion(nodeRef);
            if (currentVersion != null && !this.isRecordedVersion(currentVersion)) {
                record = this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        Pair<Set<String>, Set<String>> readersAndWriters = RecordableVersionServiceImpl.this.extendedPermissionService.getReadersAndWriters(nodeRef);
                        NodeRef currentFrozenState = currentVersion.getFrozenStateNodeRef();
                        QName type = RecordableVersionServiceImpl.this.nodeService.getType(currentFrozenState);
                        Map properties = RecordableVersionServiceImpl.this.nodeService.getProperties(currentFrozenState);
                        Set aspects = RecordableVersionServiceImpl.this.nodeService.getAspects(currentFrozenState);
                        NodeRef record = RecordableVersionServiceImpl.this.recordService.createRecordFromContent(filePlan, (String)properties.get(ContentModel.PROP_NAME), type, properties, null);
                        for (QName aspect : aspects) {
                            RecordableVersionServiceImpl.this.nodeService.addAspect(record, aspect, null);
                        }
                        PropertyMap versionRecordProps = new PropertyMap(3);
                        versionRecordProps.put((Object)RecordableVersionModel.PROP_VERSIONED_NODEREF, (Object)nodeRef);
                        versionRecordProps.put((Object)RecordableVersionModel.PROP_VERSION_LABEL, (Object)currentVersion.getVersionLabel());
                        versionRecordProps.put((Object)RecordableVersionModel.PROP_VERSION_DESCRIPTION, (Object)currentVersion.getDescription());
                        versionRecordProps.put((Object)ContentModel.PROP_VERSION_TYPE, (Object)currentVersion.getVersionType());
                        RecordableVersionServiceImpl.this.nodeService.addAspect(record, RecordableVersionModel.ASPECT_VERSION_RECORD, (Map)versionRecordProps);
                        RecordableVersionServiceImpl.this.linkToPreviousVersionRecord(nodeRef, record);
                        RecordableVersionServiceImpl.this.extendedSecurityService.set(record, readersAndWriters);
                        return record;
                    }
                });
                NodeRef versionHistoryRef = this.getVersionHistoryNodeRef(nodeRef);
                int versionNumber = this.getVersionNumber(currentVersion);
                Map<QName, Serializable> versionProperties = this.getVersionAspectProperties(currentVersion);
                QName sourceTypeRef = this.getVersionType(currentVersion);
                String owner = (String)((Object)this.nodeService.getProperty(currentVersion.getFrozenStateNodeRef(), ContentModel.PROP_OWNER));
                if (owner != null) {
                    versionProperties.put(PROP_FROZEN_OWNER, (Serializable)((Object)owner));
                }
                this.dbNodeService.deleteNode(this.convertNodeRef(currentVersion.getFrozenStateNodeRef()));
                if (!this.nodeService.exists(versionHistoryRef)) {
                    versionHistoryRef = this.createVersionHistory(nodeRef);
                }
                ChildAssociationRef childAssocRef = this.dbNodeService.createNode(versionHistoryRef, Version2Model.CHILD_QNAME_VERSIONS, QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)("version-" + versionNumber)), sourceTypeRef, null);
                if (this.isUseVersionAssocIndex()) {
                    this.nodeService.setChildAssociationIndex(childAssocRef, this.getAllVersions(versionHistoryRef).size());
                }
                NodeRef versionNodeRef = childAssocRef.getChildRef();
                this.nodeService.addAspect(versionNodeRef, Version2Model.ASPECT_VERSION, versionProperties);
                this.nodeService.addAspect(versionNodeRef, ASPECT_RECORDED_VERSION, Collections.singletonMap(PROP_RECORD_NODE_REF, record));
            }
        }
        return record;
    }

    @Override
    public boolean isRecordedVersionDestroyed(Version version) {
        boolean result = false;
        NodeRef versionNodeRef = this.getVersionNodeRef(version);
        Boolean isDestroyed = (Boolean)this.dbNodeService.getProperty(versionNodeRef, PROP_DESTROYED);
        if (isDestroyed != null) {
            result = isDestroyed;
        }
        return result;
    }

    @Override
    public void destroyRecordedVersion(Version version) {
        NodeRef versionNodeRef = this.getVersionNodeRef(version);
        if (this.dbNodeService.hasAspect(versionNodeRef, ASPECT_RECORDED_VERSION)) {
            this.dbNodeService.setProperty(versionNodeRef, PROP_DESTROYED, (Serializable)Boolean.valueOf(true));
            this.dbNodeService.setProperty(versionNodeRef, RecordableVersionModel.PROP_RECORD_NODE_REF, null);
        }
    }

    private int getVersionNumber(Version version) {
        NodeRef versionNodeRef = this.getVersionNodeRef(version);
        ChildAssociationRef assoc = this.dbNodeService.getPrimaryParent(versionNodeRef);
        String fullVersionNumber = assoc.getQName().getLocalName();
        String versionNumber = fullVersionNumber.substring(fullVersionNumber.indexOf("-") + 1);
        return Integer.parseInt(versionNumber);
    }

    private Map<QName, Serializable> getVersionAspectProperties(Version version) {
        NodeRef versionNodeRef = this.getVersionNodeRef(version);
        Map versionProps = this.dbNodeService.getProperties(versionNodeRef);
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>(9);
        for (String propertyName : VERSION_PROPERTY_NAMES) {
            QName propertyQName = QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)propertyName);
            result.put(propertyQName, (Serializable)versionProps.get(propertyQName));
            if (!propertyName.equals("frozenNodeDbId")) continue;
            System.out.println(versionProps.get(propertyQName));
        }
        return result;
    }

    private QName getVersionType(Version version) {
        return this.nodeService.getType(this.getVersionNodeRef(version));
    }

    private NodeRef getVersionNodeRef(Version version) {
        return this.convertNodeRef(version.getFrozenStateNodeRef());
    }

    public boolean isCurrentVersionDirty(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            return false;
        }
        Version currentVersion = this.getCurrentVersion(nodeRef);
        Date modificationDate = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
        if (currentVersion == null) {
            return true;
        }
        NodeRef currentFrozenState = currentVersion.getFrozenStateNodeRef();
        Date frozenModificationDate = (Date)this.nodeService.getProperty(currentFrozenState, ContentModel.PROP_MODIFIED);
        boolean versionStoreOutdated = frozenModificationDate != null && modificationDate.getTime() > frozenModificationDate.getTime();
        return versionStoreOutdated;
    }

    @Override
    public void createSnapshotVersion(NodeRef nodeRef) {
        boolean autoVersion = this.isEnableAutoVersionOnRecordCreation();
        if (autoVersion && this.isCurrentVersionDirty(nodeRef)) {
            HashMap<String, Object> autoVersionProperties = new HashMap<String, Object>(2);
            autoVersionProperties.put("versionType", VersionType.MINOR);
            autoVersionProperties.put("description", I18NUtil.getMessage((String)AUTO_VERSION_ON_RECORD_CREATION));
            this.createVersion(nodeRef, autoVersionProperties);
        }
    }
}

