/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v21;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.v21.RMv21PatchComponent;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.security.FilePlanPermissionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.springframework.beans.factory.BeanNameAware;

public class RMv21InPlacePatch
extends RMv21PatchComponent
implements BeanNameAware,
RecordsManagementModel,
DOD5015Model {
    private static final String ROLE_READERS_LABEL = "In-Place Readers";
    private static final String[] ROLE_READERS_CAPABILITIES = new String[]{"ViewRecords"};
    private static final String ROLE_WRITERS_LABEL = "In-Place Writers";
    private static final String[] ROLE_WRITERS_CAPABILITIES = new String[]{"ViewRecords", "EditNonRecordMetadata"};
    private FilePlanRoleService filePlanRoleService;
    private FilePlanService filePlanService;
    private FilePlanPermissionService filePlanPermissionService;
    private CapabilityService capabilityService;
    private RuleService ruleService;
    private NodeService nodeService;

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setFilePlanPermissionService(FilePlanPermissionService filePlanPermissionService) {
        this.filePlanPermissionService = filePlanPermissionService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executePatch() {
        Set<NodeRef> filePlans = this.filePlanService.getFilePlans();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  ... updating " + filePlans.size() + " file plans");
        }
        for (NodeRef filePlan : filePlans) {
            if (this.filePlanService.getUnfiledContainer(filePlan) != null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  ... updating file plan " + filePlan.toString());
            }
            this.ruleService.disableRules();
            try {
                this.filePlanService.createHoldContainer(filePlan);
                this.filePlanService.createTransferContainer(filePlan);
                this.filePlanService.createUnfiledContainer(filePlan);
                this.moveExistingHolds(filePlan);
                this.moveExistingTransfers(filePlan);
                this.filePlanRoleService.createRole(filePlan, "ExtendedReaders", ROLE_READERS_LABEL, this.getCapabilities(ROLE_READERS_CAPABILITIES));
                this.filePlanRoleService.createRole(filePlan, "ExtendedWriters", ROLE_WRITERS_LABEL, this.getCapabilities(ROLE_WRITERS_CAPABILITIES));
            }
            finally {
                this.ruleService.enableRules();
            }
        }
    }

    private Set<Capability> getCapabilities(String[] capabilityNames) {
        HashSet<Capability> capabilities = new HashSet<Capability>(3);
        for (String capabilityName : capabilityNames) {
            capabilities.add(this.capabilityService.getCapability(capabilityName));
        }
        return capabilities;
    }

    private void moveExistingHolds(NodeRef filePlan) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  ... moving existing holds for file plan " + filePlan.toString());
        }
        NodeRef container = this.filePlanService.getHoldContainer(filePlan);
        List assocs = this.nodeService.getChildAssocs(filePlan, (QNamePattern)ASSOC_HOLDS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef assoc : assocs) {
            NodeRef hold = assoc.getChildRef();
            String name = (String)((Object)this.nodeService.getProperty(hold, ContentModel.PROP_NAME));
            this.nodeService.moveNode(hold, container, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)name));
        }
    }

    private void moveExistingTransfers(NodeRef filePlan) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  ... moving existing transfers for file plan " + filePlan.toString());
        }
        NodeRef container = this.filePlanService.getTransferContainer(filePlan);
        List assocs = this.nodeService.getChildAssocs(filePlan, (QNamePattern)ASSOC_TRANSFERS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef assoc : assocs) {
            NodeRef transfer = assoc.getChildRef();
            String name = (String)((Object)this.nodeService.getProperty(transfer, ContentModel.PROP_NAME));
            this.nodeService.moveNode(transfer, container, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)name));
        }
    }
}

