/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.job;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.job.DispositionLifecycleJobExecuter;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class DispositionLifecycleJobExecuterUnitTest
extends BaseUnitTest {
    private static final String CUTOFF = "cutoff";
    private static final String RETAIN = "retain";
    private static final String DESTROY = "destroy";
    private static final int BATCH_SIZE = 1;
    private static final String QUERY = "\"cutoff\" OR \"retain\"";
    @Mock
    ResultSet mockedResultSet;
    @InjectMocks
    DispositionLifecycleJobExecuter executer;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        Answer doInTransactionAnswer = invocation -> {
            RetryingTransactionHelper.RetryingTransactionCallback callback = (RetryingTransactionHelper.RetryingTransactionCallback)invocation.getArguments()[0];
            return callback.execute();
        };
        ((RetryingTransactionHelper)Mockito.doAnswer((Answer)doInTransactionAnswer).when((Object)this.mockedRetryingTransactionHelper)).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)ArgumentMatchers.any(RetryingTransactionHelper.RetryingTransactionCallback.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        List<String> dispositionActions = this.buildList(CUTOFF, RETAIN);
        this.executer.setDispositionActions(dispositionActions);
        this.executer.setBatchSize(1);
        ((SearchService)Mockito.doReturn((Object)this.mockedResultSet).when((Object)this.mockedSearchService)).query((SearchParameters)ArgumentMatchers.any(SearchParameters.class));
        Mockito.when((Object)this.mockedResultSet.hasMore()).thenReturn((Object)false);
    }

    private void verifyQueryTimes(int numberOfInvocation) {
        ArgumentCaptor paramsCaptor = ArgumentCaptor.forClass(SearchParameters.class);
        ((SearchService)Mockito.verify((Object)this.mockedSearchService, (VerificationMode)Mockito.times((int)numberOfInvocation))).query((SearchParameters)paramsCaptor.capture());
        Assert.assertTrue((boolean)((SearchParameters)paramsCaptor.getValue()).getQuery().contains(QUERY));
        ((ResultSet)Mockito.verify((Object)this.mockedResultSet, (VerificationMode)Mockito.times((int)numberOfInvocation))).getNodeRefs();
        ((ResultSet)Mockito.verify((Object)this.mockedResultSet, (VerificationMode)Mockito.times((int)numberOfInvocation))).close();
    }

    @Test
    public void noResultsInQuery() {
        ((ResultSet)Mockito.doReturn((Object)Collections.EMPTY_LIST).when((Object)this.mockedResultSet)).getNodeRefs();
        this.executer.executeImpl();
        this.verifyQueryTimes(1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedNodeService, this.mockedRecordFolderService, this.mockedRetryingTransactionHelper});
    }

    @Test
    public void dispositionActionDoesNotMatch() {
        NodeRef node1 = this.generateNodeRef();
        NodeRef node2 = this.generateNodeRef();
        ((NodeService)Mockito.doReturn((Object)DESTROY).when((Object)this.mockedNodeService)).getProperty(node1, RecordsManagementModel.PROP_DISPOSITION_ACTION);
        ((NodeService)Mockito.doReturn((Object)DESTROY).when((Object)this.mockedNodeService)).getProperty(node2, RecordsManagementModel.PROP_DISPOSITION_ACTION);
        Mockito.when((Object)this.mockedResultSet.getNodeRefs()).thenReturn(this.buildList(node1)).thenReturn(this.buildList(node2));
        Mockito.when((Object)this.mockedResultSet.hasMore()).thenReturn((Object)true).thenReturn((Object)false);
        this.executer.executeImpl();
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)2))).getPrimaryParent((NodeRef)ArgumentMatchers.any(NodeRef.class));
        this.verifyQueryTimes(2);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)2))).exists((NodeRef)ArgumentMatchers.any(NodeRef.class));
        ((RetryingTransactionHelper)Mockito.verify((Object)this.mockedRetryingTransactionHelper, (VerificationMode)Mockito.times((int)2))).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)ArgumentMatchers.any(RetryingTransactionHelper.RetryingTransactionCallback.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getProperty(node1, RecordsManagementModel.PROP_DISPOSITION_ACTION);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getProperty(node2, RecordsManagementModel.PROP_DISPOSITION_ACTION);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedNodeService});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedRecordsManagementActionService});
    }

    @Test
    public void nodeDoesNotExist() {
        NodeRef node1 = this.generateNodeRef(null, false);
        List<NodeRef> nodeRefs = this.buildList(node1);
        ((ResultSet)Mockito.doReturn(nodeRefs).when((Object)this.mockedResultSet)).getNodeRefs();
        this.executer.executeImpl();
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getPrimaryParent((NodeRef)ArgumentMatchers.any(NodeRef.class));
        this.verifyQueryTimes(1);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).exists((NodeRef)ArgumentMatchers.any(NodeRef.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedNodeService});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedRecordsManagementActionService});
    }

    @Test
    public void dispositionActionProcessed() {
        NodeRef node1 = this.generateNodeRef();
        NodeRef node2 = this.generateNodeRef();
        NodeRef parent = this.generateNodeRef();
        ChildAssociationRef parentAssoc = new ChildAssociationRef(ASSOC_NEXT_DISPOSITION_ACTION, parent, AlfMock.generateQName(), this.generateNodeRef());
        ((NodeService)Mockito.doReturn((Object)CUTOFF).when((Object)this.mockedNodeService)).getProperty(node1, RecordsManagementModel.PROP_DISPOSITION_ACTION);
        ((NodeService)Mockito.doReturn((Object)RETAIN).when((Object)this.mockedNodeService)).getProperty(node2, RecordsManagementModel.PROP_DISPOSITION_ACTION);
        ((NodeService)Mockito.doReturn((Object)parentAssoc).when((Object)this.mockedNodeService)).getPrimaryParent((NodeRef)ArgumentMatchers.any(NodeRef.class));
        ((RecordFolderService)Mockito.doReturn((Object)false).when((Object)this.mockedRecordFolderService)).isRecordFolder(parentAssoc.getParentRef());
        ((RecordService)Mockito.doReturn((Object)true).when((Object)this.mockedRecordService)).isRecord(parentAssoc.getParentRef());
        ((FreezeService)Mockito.doReturn((Object)false).when((Object)this.mockedFreezeService)).isFrozen(parentAssoc.getParentRef());
        Mockito.when((Object)this.mockedResultSet.getNodeRefs()).thenReturn(this.buildList(node1)).thenReturn(this.buildList(node2));
        Mockito.when((Object)this.mockedResultSet.hasMore()).thenReturn((Object)true).thenReturn((Object)false);
        this.executer.executeImpl();
        this.verifyQueryTimes(2);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)2))).exists((NodeRef)ArgumentMatchers.any(NodeRef.class));
        ((RetryingTransactionHelper)Mockito.verify((Object)this.mockedRetryingTransactionHelper, (VerificationMode)Mockito.times((int)2))).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)ArgumentMatchers.any(RetryingTransactionHelper.RetryingTransactionCallback.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getProperty(node1, RecordsManagementModel.PROP_DISPOSITION_ACTION);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).getPrimaryParent(node1);
        ((RecordsManagementActionService)Mockito.verify((Object)this.mockedRecordsManagementActionService, (VerificationMode)Mockito.times((int)1))).executeRecordsManagementAction((NodeRef)ArgumentMatchers.eq((Object)parent), (String)ArgumentMatchers.eq((Object)CUTOFF), ArgumentMatchers.anyMap());
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).getProperty(node2, RecordsManagementModel.PROP_DISPOSITION_ACTION);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).getPrimaryParent(node2);
        ((RecordsManagementActionService)Mockito.verify((Object)this.mockedRecordsManagementActionService, (VerificationMode)Mockito.times((int)1))).executeRecordsManagementAction((NodeRef)ArgumentMatchers.eq((Object)parent), (String)ArgumentMatchers.eq((Object)RETAIN), ArgumentMatchers.anyMap());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedNodeService, this.mockedRecordsManagementActionService});
    }

    @Test
    public void testGetQuery() {
        String actual = this.executer.getQuery();
        String expected = "TYPE:\"rma:dispositionAction\" AND (@rma\\:dispositionAction:(\"cutoff\" OR \"retain\")) AND ISUNSET:\"rma:dispositionActionCompletedAt\"  AND ( @rma\\:dispositionEventsEligible:true OR @rma\\:dispositionAsOf:[MIN TO NOW] ) ";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testPagination() {
        NodeRef node1 = this.generateNodeRef();
        NodeRef node2 = this.generateNodeRef();
        NodeRef node3 = this.generateNodeRef();
        NodeRef node4 = this.generateNodeRef();
        Mockito.when((Object)this.mockedSearchService.query((SearchParameters)ArgumentMatchers.any(SearchParameters.class))).thenAnswer(invocation -> {
            SearchParameters params = (SearchParameters)invocation.getArgument(0, SearchParameters.class);
            if (params.getSkipCount() == 0) {
                ResultSet result1 = (ResultSet)Mockito.mock(ResultSet.class);
                Mockito.when((Object)result1.getNodeRefs()).thenReturn(Arrays.asList(node1, node2));
                Mockito.when((Object)result1.hasMore()).thenReturn((Object)true);
                return result1;
            }
            if (params.getSkipCount() == 2) {
                ResultSet result2 = (ResultSet)Mockito.mock(ResultSet.class);
                Mockito.when((Object)result2.getNodeRefs()).thenReturn(Arrays.asList(node3, node4));
                Mockito.when((Object)result2.hasMore()).thenReturn((Object)false);
                return result2;
            }
            throw new IndexOutOfBoundsException("Pagination did not stop after the second page!");
        });
        this.executer.executeImpl();
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).exists(node1);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).exists(node2);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).exists(node3);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).exists(node4);
        ((SearchService)Mockito.verify((Object)this.mockedSearchService, (VerificationMode)Mockito.times((int)2))).query((SearchParameters)ArgumentMatchers.any(SearchParameters.class));
    }

    @Test
    public void testInvalidBatchSize() {
        this.executer.setBatchSize(0);
        this.executer.executeImpl();
        ArgumentCaptor paramsCaptor = ArgumentCaptor.forClass(SearchParameters.class);
        ((SearchService)Mockito.verify((Object)this.mockedSearchService, (VerificationMode)Mockito.times((int)1))).query((SearchParameters)paramsCaptor.capture());
        Assert.assertEquals((long)500L, (long)((SearchParameters)paramsCaptor.getValue()).getMaxItems());
        ((ResultSet)Mockito.verify((Object)this.mockedResultSet, (VerificationMode)Mockito.times((int)1))).close();
        this.executer.setBatchSize(1);
    }
}

