/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import java.util.Arrays;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

@BehaviourBean(defaultType="rma:holdContainer")
public class HoldContainerType
extends BaseBehaviourBean
implements NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnDeleteNodePolicy {
    private static final String MSG_ERROR_ADD_CONTENT_CONTAINER = "rm.service.error-add-content-container";
    private static final List<QName> ACCEPTED_NON_UNIQUE_CHILD_TYPES = Arrays.asList(TYPE_HOLD);
    private static final String DELETE_BEHAVIOUR_NAME = "onDeleteHoldContainer";

    public void disable() {
        this.getBehaviour(DELETE_BEHAVIOUR_NAME).disable();
    }

    public void enable() {
        this.getBehaviour(DELETE_BEHAVIOUR_NAME).enable();
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION)
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean bNew) {
        this.validateNewChildAssociationSubTypesIncluded(childAssocRef.getChildRef(), ACCEPTED_NON_UNIQUE_CHILD_TYPES);
    }

    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef = childAssocRef.getChildRef();
        if (this.instanceOf(nodeRef, ContentModel.TYPE_CONTENT)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_ERROR_ADD_CONTENT_CONTAINER));
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, name="onDeleteHoldContainer")
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        throw new IntegrityException("Operation failed. Deletion of Hold Container is not allowed.", null);
    }
}

