/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.hold;

import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.GUID;

public class AddActiveContentToHoldTest
extends BaseRMTestCase {
    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isUserTest() {
        return true;
    }

    public void testAddDocumentToHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;

            @Override
            public void given() {
                this.hold = AddActiveContentToHoldTest.this.holdService.createHold(AddActiveContentToHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
            }

            @Override
            public void when() {
                AddActiveContentToHoldTest.this.holdService.addToHold(this.hold, AddActiveContentToHoldTest.this.dmDocument);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)AddActiveContentToHoldTest.this.freezeService.isFrozen(AddActiveContentToHoldTest.this.dmDocument));
                TestCase.assertFalse((boolean)AddActiveContentToHoldTest.this.freezeService.isFrozen(AddActiveContentToHoldTest.this.dmFolder));
                TestCase.assertTrue((boolean)AddActiveContentToHoldTest.this.freezeService.hasFrozenChildren(AddActiveContentToHoldTest.this.dmFolder));
                TestCase.assertFalse((boolean)AddActiveContentToHoldTest.this.holdService.getHeld(this.hold).contains(AddActiveContentToHoldTest.this.dmFolder));
                TestCase.assertFalse((boolean)AddActiveContentToHoldTest.this.holdService.heldBy(AddActiveContentToHoldTest.this.dmFolder, true).contains(this.hold));
                TestCase.assertTrue((boolean)AddActiveContentToHoldTest.this.holdService.getHeld(this.hold).contains(AddActiveContentToHoldTest.this.dmDocument));
                TestCase.assertTrue((boolean)AddActiveContentToHoldTest.this.holdService.heldBy(AddActiveContentToHoldTest.this.dmDocument, true).contains(this.hold));
                TestCase.assertTrue((boolean)AddActiveContentToHoldTest.this.nodeService.hasAspect(AddActiveContentToHoldTest.this.dmFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)1, (Object)AddActiveContentToHoldTest.this.nodeService.getProperty(AddActiveContentToHoldTest.this.dmFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }
        });
    }

    public void testAddDocumentToHoldAsNonRMUser() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class){
            private NodeRef hold;

            @Override
            public void given() {
                this.hold = AddActiveContentToHoldTest.this.holdService.createHold(AddActiveContentToHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
            }

            @Override
            public void when() {
                AuthenticationUtil.runAs(() -> {
                    AddActiveContentToHoldTest.this.holdService.addToHold(this.hold, AddActiveContentToHoldTest.this.dmDocument);
                    return null;
                }, (String)AddActiveContentToHoldTest.this.dmCollaborator);
            }
        });
    }

    public void testAddDocumentToHoldNoWritePermissionOnDoc() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class){
            private NodeRef hold;

            @Override
            public void given() {
                this.hold = AddActiveContentToHoldTest.this.holdService.createHold(AddActiveContentToHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                AddActiveContentToHoldTest.this.siteService.setMembership(AddActiveContentToHoldTest.this.collabSiteId, AddActiveContentToHoldTest.this.rmAdminName, "SiteConsumer");
            }

            @Override
            public void when() {
                AuthenticationUtil.runAs(() -> {
                    AddActiveContentToHoldTest.this.holdService.addToHold(this.hold, AddActiveContentToHoldTest.this.dmDocument);
                    return null;
                }, (String)AddActiveContentToHoldTest.this.rmAdminName);
            }
        });
    }

    public void testAddDocumentToHoldNoFilingPermissionOnHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class, this.recordsManagerName, false){
            private NodeRef hold;

            @Override
            public void given() {
                AuthenticationUtil.runAs(() -> {
                    this.hold = AddActiveContentToHoldTest.this.holdService.createHold(AddActiveContentToHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                    AddActiveContentToHoldTest.this.filePlanPermissionService.setPermission(this.hold, AddActiveContentToHoldTest.this.recordsManagerName, "ReadRecords");
                    AddActiveContentToHoldTest.this.siteService.setMembership(AddActiveContentToHoldTest.this.collabSiteId, AddActiveContentToHoldTest.this.recordsManagerName, "SiteManager");
                    return null;
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() {
                AddActiveContentToHoldTest.this.holdService.addToHold(this.hold, AddActiveContentToHoldTest.this.dmDocument);
            }
        });
    }

    public void testAddDocumentToHoldNoCapability() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class, this.powerUserName, false){
            private NodeRef hold;

            @Override
            public void given() {
                AuthenticationUtil.runAs(() -> {
                    this.hold = AddActiveContentToHoldTest.this.holdService.createHold(AddActiveContentToHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                    AddActiveContentToHoldTest.this.siteService.setMembership(AddActiveContentToHoldTest.this.collabSiteId, AddActiveContentToHoldTest.this.powerUserName, "SiteManager");
                    AddActiveContentToHoldTest.this.filePlanPermissionService.setPermission(this.hold, AddActiveContentToHoldTest.this.powerUserName, "Filing");
                    return null;
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() {
                AddActiveContentToHoldTest.this.holdService.addToHold(this.hold, AddActiveContentToHoldTest.this.dmDocument);
            }
        });
    }

    public void testAddDocumentToAnotherHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef hold2;

            @Override
            public void given() {
                this.hold = AddActiveContentToHoldTest.this.holdService.createHold(AddActiveContentToHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                this.hold2 = AddActiveContentToHoldTest.this.holdService.createHold(AddActiveContentToHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                AddActiveContentToHoldTest.this.holdService.addToHold(this.hold, AddActiveContentToHoldTest.this.dmDocument);
            }

            @Override
            public void when() {
                AddActiveContentToHoldTest.this.holdService.addToHold(this.hold2, AddActiveContentToHoldTest.this.dmDocument);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)AddActiveContentToHoldTest.this.freezeService.isFrozen(AddActiveContentToHoldTest.this.dmDocument));
                TestCase.assertTrue((boolean)AddActiveContentToHoldTest.this.holdService.heldBy(AddActiveContentToHoldTest.this.dmDocument, true).contains(this.hold));
                TestCase.assertTrue((boolean)AddActiveContentToHoldTest.this.holdService.heldBy(AddActiveContentToHoldTest.this.dmDocument, true).contains(this.hold2));
            }
        });
    }
}

