/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.query.RecordsManagementQueryDAO;
import org.alfresco.module.org_alfresco_module_rm.util.ContentBinDuplicationUtility;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class ContentBinDuplicationUtilityUnitTest {
    private static final NodeRef NODE_REF = new NodeRef("some://test/noderef");
    private static final NodeRef NODE_REF2 = new NodeRef("some://test/anothernoderef");
    private static final String CONTENT_URL = "someContentUrl";
    @Mock
    private ContentService mockContentService;
    @Mock
    private BehaviourFilter mockBehaviourFilter;
    @Mock
    private ContentReader mockContentReader;
    @Mock
    private ContentWriter mockContentWriter;
    @Mock
    private NodeService mockNodeService;
    @Mock
    private RecordsManagementQueryDAO recordsManagementQueryDAO;
    @InjectMocks
    private ContentBinDuplicationUtility contentBinDuplicationUtility;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.contentBinDuplicationUtility.setNodeService(this.mockNodeService);
    }

    @Test
    public void testContentUrlIsUpdated() {
        Mockito.when((Object)this.mockContentService.getReader(NODE_REF, ContentModel.PROP_CONTENT)).thenReturn((Object)this.mockContentReader);
        Mockito.when((Object)this.mockContentService.getWriter(NODE_REF, ContentModel.PROP_CONTENT, true)).thenReturn((Object)this.mockContentWriter);
        this.contentBinDuplicationUtility.duplicate(NODE_REF);
        ((ContentWriter)Mockito.verify((Object)this.mockContentWriter, (VerificationMode)Mockito.times((int)1))).putContent(this.mockContentReader);
        this.checkBehaviours(1);
    }

    @Test
    public void testDuplicationDoesntHappenWithNoContent() {
        Mockito.when((Object)this.mockContentService.getReader(NODE_REF, ContentModel.PROP_CONTENT)).thenReturn(null);
        this.contentBinDuplicationUtility.duplicate(NODE_REF);
        ((ContentWriter)Mockito.verify((Object)this.mockContentWriter, (VerificationMode)Mockito.times((int)0))).putContent(this.mockContentReader);
        this.checkBehaviours(1);
    }

    @Test
    public void testBinFileNotDuplicatedForArchivedContent() {
        NodeRef nodeRef = new NodeRef("some://test/noderef");
        Mockito.when((Object)this.mockNodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_ARCHIVED)).thenReturn((Object)true);
        this.contentBinDuplicationUtility.duplicate(nodeRef);
        ((ContentReader)Mockito.verify((Object)this.mockContentReader, (VerificationMode)Mockito.times((int)0))).getReader();
        this.checkBehaviours(0);
    }

    @Test
    public void testHasAtLeastOneOtherReference() {
        HashSet multipleReferences = new HashSet();
        Collections.addAll(multipleReferences, NODE_REF, NODE_REF2);
        Mockito.when((Object)this.mockContentService.getReader(NODE_REF, ContentModel.PROP_CONTENT)).thenReturn((Object)this.mockContentReader);
        Mockito.when((Object)this.mockContentService.getReader(NODE_REF, ContentModel.PROP_CONTENT).getContentUrl()).thenReturn((Object)CONTENT_URL);
        Mockito.when((Object)this.recordsManagementQueryDAO.getNodeRefsWhichReferenceContentUrl(CONTENT_URL)).thenReturn(multipleReferences);
        Assert.assertTrue((boolean)this.contentBinDuplicationUtility.hasAtLeastOneOtherReference(NODE_REF));
    }

    @Test
    public void testHasNoOtherReference() {
        Set<NodeRef> singleReference = Collections.singleton(NODE_REF);
        Mockito.when((Object)this.mockContentService.getReader(NODE_REF, ContentModel.PROP_CONTENT)).thenReturn((Object)this.mockContentReader);
        Mockito.when((Object)this.mockContentService.getReader(NODE_REF, ContentModel.PROP_CONTENT).getContentUrl()).thenReturn((Object)CONTENT_URL);
        Mockito.when((Object)this.recordsManagementQueryDAO.getNodeRefsWhichReferenceContentUrl(CONTENT_URL)).thenReturn(singleReference);
        Assert.assertFalse((boolean)this.contentBinDuplicationUtility.hasAtLeastOneOtherReference(NODE_REF));
    }

    @Test
    public void testHasNoReferences() {
        Set noReferences = Collections.emptySet();
        Mockito.when((Object)this.mockContentService.getReader(NODE_REF, ContentModel.PROP_CONTENT)).thenReturn((Object)this.mockContentReader);
        Mockito.when((Object)this.mockContentService.getReader(NODE_REF, ContentModel.PROP_CONTENT).getContentUrl()).thenReturn((Object)CONTENT_URL);
        Mockito.when((Object)this.recordsManagementQueryDAO.getNodeRefsWhichReferenceContentUrl(CONTENT_URL)).thenReturn(noReferences);
        Assert.assertFalse((boolean)this.contentBinDuplicationUtility.hasAtLeastOneOtherReference(NODE_REF));
    }

    private void checkBehaviours(int times) {
        ((BehaviourFilter)Mockito.verify((Object)this.mockBehaviourFilter, (VerificationMode)Mockito.times((int)times))).disableBehaviour();
        ((BehaviourFilter)Mockito.verify((Object)this.mockBehaviourFilter, (VerificationMode)Mockito.times((int)times))).enableBehaviour();
    }
}

