/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v21;

import java.io.InputStream;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.patch.v21.RMv21PatchComponent;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.springframework.beans.factory.BeanNameAware;

public class RMv21ReportServicePatch
extends RMv21PatchComponent
implements BeanNameAware {
    private static final NodeRef TEMPLATE_ROOT = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "rm_report_templates");
    private static final NodeRef RM_CONFIG_FOLDER = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "rm_config_folder");
    private static final String PATH_DESTRUCTION_TEMPLATE = "alfresco/module/org_alfresco_module_rm/bootstrap/report/report_rmr_destructionReport.html.ftl";
    private NodeService nodeService;
    private ContentService contentService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    protected void executePatch() {
        if (this.nodeService.exists(RM_CONFIG_FOLDER) && !this.nodeService.exists(TEMPLATE_ROOT)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" ... adding template root folder");
            }
            NodeRef reportTemplates = this.createNode(RM_CONFIG_FOLDER, ContentModel.TYPE_FOLDER, "rm_report_templates", "Records Management Report Templates", "rm_report_templates", "Records Management Report Templates", "Records Management Report Templates");
            this.nodeService.addAspect(reportTemplates, ContentModel.ASPECT_TITLED, null);
            this.nodeService.addAspect(reportTemplates, ContentModel.ASPECT_AUTHOR, null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" ... adding destruction report template");
            }
            NodeRef destructionTemplate = this.createNode(TEMPLATE_ROOT, ContentModel.TYPE_CONTENT, "rmr_destructionReport", "report_rmr_destructionReport.html.ftl", "report_rmr_destructionReport.html.ftl", "Destruction Report Template", "Desruction report template.");
            this.nodeService.addAspect(destructionTemplate, ContentModel.ASPECT_TITLED, null);
            this.nodeService.addAspect(destructionTemplate, ContentModel.ASPECT_AUTHOR, null);
            ContentWriter writer = this.contentService.getWriter(destructionTemplate, ContentModel.PROP_CONTENT, true);
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PATH_DESTRUCTION_TEMPLATE);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/plain");
            writer.putContent(is);
        }
    }

    private NodeRef createNode(NodeRef parent, QName type, String id, String name, String assocName, String title, String description) {
        HashMap<QName, String> props = new HashMap<QName, String>(4);
        props.put(ContentModel.PROP_DESCRIPTION, description);
        props.put(ContentModel.PROP_TITLE, title);
        props.put(ContentModel.PROP_NAME, name);
        props.put(ContentModel.PROP_NODE_UUID, id);
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)assocName));
        return this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, assocQName, type, props).getChildRef();
    }
}

