/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.record;

import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.GUID;

public class MoveRecordTest
extends BaseRMTestCase {
    private static final String OTHER_EVENT = "abolished";

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testMoveRecordEventDispositinoToNoDisposition() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef sourceCategory;
            NodeRef sourceRecordFolder;
            NodeRef destinationCategory;
            NodeRef destinationRecordFolder;
            NodeRef record;

            @Override
            public void given() {
                this.sourceCategory = MoveRecordTest.this.filePlanService.createRecordCategory(MoveRecordTest.this.filePlan, GUID.generate());
                MoveRecordTest.this.utils.createBasicDispositionSchedule(this.sourceCategory, GUID.generate(), GUID.generate(), true, true);
                this.sourceRecordFolder = MoveRecordTest.this.recordFolderService.createRecordFolder(this.sourceCategory, GUID.generate());
                this.destinationCategory = MoveRecordTest.this.filePlanService.createRecordCategory(MoveRecordTest.this.filePlan, GUID.generate());
                this.destinationRecordFolder = MoveRecordTest.this.recordFolderService.createRecordFolder(this.destinationCategory, GUID.generate());
                this.record = MoveRecordTest.this.utils.createRecord(this.sourceRecordFolder, GUID.generate());
                TestCase.assertFalse((boolean)MoveRecordTest.this.nodeService.hasAspect(this.sourceRecordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                DispositionAction dispositionAction = MoveRecordTest.this.dispositionService.getNextDispositionAction(this.record);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertNotNull((String)"cutoff", (Object)dispositionAction.getName());
                TestCase.assertNull((Object)dispositionAction.getAsOfDate());
                TestCase.assertFalse((boolean)MoveRecordTest.this.dispositionService.isNextDispositionActionEligible(this.record));
                TestCase.assertNotNull((Object)dispositionAction.getEventCompletionDetails("case_closed"));
            }

            @Override
            public void when() throws Exception {
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_RM_SEARCH));
                TestCase.assertEquals((Object)"cutoff", (Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                TestCase.assertNull((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                TestCase.assertTrue((boolean)((List)((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS))).contains("case_closed"));
                MoveRecordTest.this.fileFolderService.move(this.record, this.destinationRecordFolder, null);
            }

            @Override
            public void then() {
                TestCase.assertFalse((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                TestCase.assertNull((Object)MoveRecordTest.this.dispositionService.getNextDispositionAction(this.record));
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_RM_SEARCH));
            }
        });
    }

    public void testMoveRecordEventDisToEventDis() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef sourceCategory;
            NodeRef sourceRecordFolder;
            NodeRef destinationCategory;
            NodeRef destinationRecordFolder;
            NodeRef record;

            @Override
            public void given() {
                this.sourceCategory = MoveRecordTest.this.filePlanService.createRecordCategory(MoveRecordTest.this.filePlan, GUID.generate());
                MoveRecordTest.this.utils.createBasicDispositionSchedule(this.sourceCategory, GUID.generate(), GUID.generate(), true, true);
                this.sourceRecordFolder = MoveRecordTest.this.recordFolderService.createRecordFolder(this.sourceCategory, GUID.generate());
                this.destinationCategory = MoveRecordTest.this.filePlanService.createRecordCategory(MoveRecordTest.this.filePlan, GUID.generate());
                MoveRecordTest.this.utils.createDispositionSchedule(this.destinationCategory, GUID.generate(), GUID.generate(), true, true, false, MoveRecordTest.OTHER_EVENT);
                this.destinationRecordFolder = MoveRecordTest.this.recordFolderService.createRecordFolder(this.destinationCategory, GUID.generate());
                this.record = MoveRecordTest.this.utils.createRecord(this.sourceRecordFolder, GUID.generate());
                TestCase.assertFalse((boolean)MoveRecordTest.this.nodeService.hasAspect(this.sourceRecordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                DispositionAction dispositionAction = MoveRecordTest.this.dispositionService.getNextDispositionAction(this.record);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertNotNull((String)"cutoff", (Object)dispositionAction.getName());
                TestCase.assertNull((Object)dispositionAction.getAsOfDate());
                TestCase.assertFalse((boolean)MoveRecordTest.this.dispositionService.isNextDispositionActionEligible(this.record));
                TestCase.assertNotNull((Object)dispositionAction.getEventCompletionDetails("case_closed"));
                TestCase.assertNull((Object)dispositionAction.getEventCompletionDetails(MoveRecordTest.OTHER_EVENT));
            }

            @Override
            public void when() throws Exception {
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_RM_SEARCH));
                TestCase.assertEquals((Object)"cutoff", (Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                TestCase.assertNull((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                TestCase.assertTrue((boolean)((List)((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS))).contains("case_closed"));
                MoveRecordTest.this.fileFolderService.move(this.record, this.destinationRecordFolder, null);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                DispositionAction dispositionAction = MoveRecordTest.this.dispositionService.getNextDispositionAction(this.record);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertNotNull((String)"cutoff", (Object)dispositionAction.getName());
                TestCase.assertNull((Object)dispositionAction.getAsOfDate());
                TestCase.assertFalse((boolean)MoveRecordTest.this.dispositionService.isNextDispositionActionEligible(this.record));
                TestCase.assertNull((Object)dispositionAction.getEventCompletionDetails("case_closed"));
                TestCase.assertNotNull((Object)dispositionAction.getEventCompletionDetails(MoveRecordTest.OTHER_EVENT));
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_RM_SEARCH));
                TestCase.assertEquals((Object)"cutoff", (Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                TestCase.assertNull((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                TestCase.assertTrue((boolean)((List)((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS))).contains(MoveRecordTest.OTHER_EVENT));
                TestCase.assertNotNull((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOITION_INSTRUCTIONS));
                TestCase.assertNotNull((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOITION_AUTHORITY));
                TestCase.assertTrue((boolean)((Boolean)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_HAS_DISPOITION_SCHEDULE)));
            }
        });
    }

    public void testMoveRecordEventDisToTimeDis() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef sourceCategory;
            NodeRef sourceRecordFolder;
            NodeRef destinationCategory;
            NodeRef destinationRecordFolder;
            NodeRef record;

            @Override
            public void given() {
                this.sourceCategory = MoveRecordTest.this.filePlanService.createRecordCategory(MoveRecordTest.this.filePlan, GUID.generate());
                MoveRecordTest.this.utils.createBasicDispositionSchedule(this.sourceCategory, GUID.generate(), GUID.generate(), true, true);
                this.sourceRecordFolder = MoveRecordTest.this.recordFolderService.createRecordFolder(this.sourceCategory, GUID.generate());
                this.destinationCategory = MoveRecordTest.this.filePlanService.createRecordCategory(MoveRecordTest.this.filePlan, GUID.generate());
                DispositionSchedule dis = MoveRecordTest.this.utils.createBasicDispositionSchedule(this.destinationCategory, GUID.generate(), GUID.generate(), true, false);
                HashMap<QName, String> adParams = new HashMap<QName, String>(3);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "cutoff");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, GUID.generate());
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, "immediately|0");
                MoveRecordTest.this.dispositionService.addDispositionActionDefinition(dis, adParams);
                this.destinationRecordFolder = MoveRecordTest.this.recordFolderService.createRecordFolder(this.destinationCategory, GUID.generate());
                this.record = MoveRecordTest.this.utils.createRecord(this.sourceRecordFolder, GUID.generate());
                TestCase.assertFalse((boolean)MoveRecordTest.this.nodeService.hasAspect(this.sourceRecordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                DispositionAction dispositionAction = MoveRecordTest.this.dispositionService.getNextDispositionAction(this.record);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertNotNull((String)"cutoff", (Object)dispositionAction.getName());
                TestCase.assertNull((Object)dispositionAction.getAsOfDate());
                TestCase.assertFalse((boolean)MoveRecordTest.this.dispositionService.isNextDispositionActionEligible(this.record));
                TestCase.assertNotNull((Object)dispositionAction.getEventCompletionDetails("case_closed"));
                TestCase.assertNull((Object)dispositionAction.getEventCompletionDetails(MoveRecordTest.OTHER_EVENT));
            }

            @Override
            public void when() throws Exception {
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_RM_SEARCH));
                TestCase.assertEquals((Object)"cutoff", (Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                TestCase.assertNull((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                TestCase.assertTrue((boolean)((List)((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS))).contains("case_closed"));
                MoveRecordTest.this.fileFolderService.move(this.record, this.destinationRecordFolder, null);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                DispositionAction dispositionAction = MoveRecordTest.this.dispositionService.getNextDispositionAction(this.record);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertNotNull((String)"cutoff", (Object)dispositionAction.getName());
                TestCase.assertNotNull((Object)dispositionAction.getAsOfDate());
                TestCase.assertTrue((boolean)MoveRecordTest.this.dispositionService.isNextDispositionActionEligible(this.record));
                TestCase.assertNull((Object)dispositionAction.getEventCompletionDetails("case_closed"));
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_RM_SEARCH));
                TestCase.assertEquals((Object)"cutoff", (Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                TestCase.assertNotNull((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                TestCase.assertNull((Object)((List)((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS))));
                TestCase.assertNotNull((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOITION_INSTRUCTIONS));
                TestCase.assertNotNull((Object)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOITION_AUTHORITY));
                TestCase.assertTrue((boolean)((Boolean)MoveRecordTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_HAS_DISPOITION_SCHEDULE)));
            }
        });
    }

    public void testMoveDMtoRM() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef destinationCategory;
            NodeRef destinationRecordFolder;

            @Override
            public void given() {
                this.destinationCategory = MoveRecordTest.this.filePlanService.createRecordCategory(MoveRecordTest.this.filePlan, GUID.generate());
                DispositionSchedule dis = MoveRecordTest.this.utils.createBasicDispositionSchedule(this.destinationCategory, GUID.generate(), GUID.generate(), true, false);
                HashMap<QName, String> adParams = new HashMap<QName, String>(3);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "cutoff");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, GUID.generate());
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, "immediately|0");
                MoveRecordTest.this.dispositionService.addDispositionActionDefinition(dis, adParams);
                this.destinationRecordFolder = MoveRecordTest.this.recordFolderService.createRecordFolder(this.destinationCategory, GUID.generate());
            }

            @Override
            public void when() throws Exception {
                MoveRecordTest.this.fileFolderService.move(MoveRecordTest.this.dmDocument, this.destinationRecordFolder, null);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(MoveRecordTest.this.dmDocument, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                DispositionAction dispositionAction = MoveRecordTest.this.dispositionService.getNextDispositionAction(MoveRecordTest.this.dmDocument);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertNotNull((String)"cutoff", (Object)dispositionAction.getName());
                TestCase.assertNotNull((Object)dispositionAction.getAsOfDate());
                TestCase.assertTrue((boolean)MoveRecordTest.this.dispositionService.isNextDispositionActionEligible(MoveRecordTest.this.dmDocument));
                TestCase.assertNull((Object)dispositionAction.getEventCompletionDetails("case_closed"));
                TestCase.assertTrue((boolean)MoveRecordTest.this.nodeService.hasAspect(MoveRecordTest.this.dmDocument, RecordsManagementModel.ASPECT_RM_SEARCH));
                TestCase.assertEquals((Object)"cutoff", (Object)MoveRecordTest.this.nodeService.getProperty(MoveRecordTest.this.dmDocument, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                TestCase.assertNotNull((Object)MoveRecordTest.this.nodeService.getProperty(MoveRecordTest.this.dmDocument, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                TestCase.assertNull((Object)((List)((Object)MoveRecordTest.this.nodeService.getProperty(MoveRecordTest.this.dmDocument, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS))));
                TestCase.assertNotNull((Object)MoveRecordTest.this.nodeService.getProperty(MoveRecordTest.this.dmDocument, RecordsManagementModel.PROP_RS_DISPOITION_INSTRUCTIONS));
                TestCase.assertNotNull((Object)MoveRecordTest.this.nodeService.getProperty(MoveRecordTest.this.dmDocument, RecordsManagementModel.PROP_RS_DISPOITION_AUTHORITY));
                TestCase.assertTrue((boolean)((Boolean)MoveRecordTest.this.nodeService.getProperty(MoveRecordTest.this.dmDocument, RecordsManagementModel.PROP_RS_HAS_DISPOITION_SCHEDULE)));
            }
        });
    }
}

