/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.capability;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.capability.Group;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CapabilitiesGet
extends DeclarativeWebScript {
    private FilePlanService filePlanService;
    private CapabilityService capabilityService;

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String storeType = (String)templateVars.get("store_type");
        String storeId = (String)templateVars.get("store_id");
        String nodeId = (String)templateVars.get("id");
        NodeRef nodeRef = null;
        if (StringUtils.isNotBlank((CharSequence)storeType) && StringUtils.isNotBlank((CharSequence)storeId) && StringUtils.isNotBlank((CharSequence)nodeId)) {
            nodeRef = new NodeRef(new StoreRef(storeType, storeId), nodeId);
        } else {
            nodeRef = this.filePlanService.getFilePlanBySiteId("rm");
            if (nodeRef == null) {
                throw new WebScriptException(500, "The default file plan node could not be found.");
            }
        }
        boolean grouped = false;
        String groupedString = req.getParameter("grouped");
        if (StringUtils.isNotBlank((CharSequence)groupedString)) {
            grouped = Boolean.parseBoolean(groupedString);
        }
        TreeMap<String, Object> model = new TreeMap<String, Object>();
        if (grouped) {
            TreeMap<String, GroupedCapabilities> groupedCapabilitiesMap = new TreeMap<String, GroupedCapabilities>();
            List<Group> groups = this.capabilityService.getGroups();
            for (Group group : groups) {
                String capabilityGroupTitle = group.getTitle();
                if (!StringUtils.isNotBlank((CharSequence)capabilityGroupTitle)) continue;
                String capabilityGroupId = group.getId();
                List<Capability> capabilities = this.capabilityService.getCapabilitiesByGroupId(capabilityGroupId);
                for (Capability capability : capabilities) {
                    String capabilityName = capability.getName();
                    String capabilityTitle = capability.getTitle();
                    if (groupedCapabilitiesMap.containsKey(capabilityGroupId)) {
                        ((GroupedCapabilities)groupedCapabilitiesMap.get(capabilityGroupId)).addCapability(capabilityName, capabilityTitle);
                        continue;
                    }
                    GroupedCapabilities groupedCapabilities = new GroupedCapabilities(capabilityGroupId, capabilityGroupTitle, capabilityName, capabilityTitle);
                    groupedCapabilities.addCapability(capabilityName, capabilityTitle);
                    groupedCapabilitiesMap.put(capabilityGroupId, groupedCapabilities);
                }
            }
            model.put("groupedCapabilities", groupedCapabilitiesMap);
        } else {
            boolean includePrivate = false;
            String includePrivateString = req.getParameter("includeAll");
            if (StringUtils.isNotBlank((CharSequence)includePrivateString)) {
                includePrivate = Boolean.parseBoolean(includePrivateString);
            }
            Map<Capability, AccessStatus> map = this.capabilityService.getCapabilitiesAccessState(nodeRef, includePrivate);
            ArrayList<String> list = new ArrayList<String>(map.size());
            for (Map.Entry<Capability, AccessStatus> entry : map.entrySet()) {
                AccessStatus accessStatus = entry.getValue();
                if (AccessStatus.DENIED.equals((Object)accessStatus)) continue;
                Capability capability = entry.getKey();
                list.add(capability.getName());
            }
            model.put("capabilities", list);
        }
        return model;
    }

    public class GroupedCapabilities {
        private String capabilityGroupId;
        private String capabilityGroupTitle;
        private String capabilityName;
        private String capabilityTitle;
        private Map<String, String> capabilities;

        public GroupedCapabilities(String capabilityGroupId, String capabilityGroupTitle, String capabilityName, String capabilityTitle) {
            this.capabilityGroupId = capabilityGroupId;
            this.capabilityGroupTitle = capabilityGroupTitle;
            this.capabilityName = capabilityName;
            this.capabilityTitle = capabilityTitle;
            this.capabilities = new TreeMap<String, String>();
        }

        public String getGroupId() {
            return this.capabilityGroupId;
        }

        public String getGroupTitle() {
            return this.capabilityGroupTitle;
        }

        public String getCapabilityName() {
            return this.capabilityName;
        }

        public String getCapabilityTitle() {
            return this.capabilityTitle;
        }

        public Map<String, String> getCapabilities() {
            return this.capabilities;
        }

        public void addCapability(String capabilityName, String capabilityTitle) {
            this.capabilities.put(capabilityName, capabilityTitle);
        }
    }
}

