/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.query.RecordsManagementQueryDAO;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.junit.Test;

public class RecordsManagementQueryDAOImplTest
extends BaseRMTestCase
implements RecordsManagementModel {
    protected RecordsManagementQueryDAO queryDAO;

    @Override
    protected void initServices() {
        super.initServices();
        this.queryDAO = (RecordsManagementQueryDAO)this.applicationContext.getBean("recordsManagementQueryDAO");
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testGetRecordMetaDataAspects() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                int count = RecordsManagementQueryDAOImplTest.this.queryDAO.getCountRmaIdentifier("abc-123");
                TestCase.assertEquals((int)0, (int)count);
                String existingID = (String)((Object)RecordsManagementQueryDAOImplTest.this.nodeService.getProperty(RecordsManagementQueryDAOImplTest.this.recordOne, RecordsManagementModel.PROP_IDENTIFIER));
                count = RecordsManagementQueryDAOImplTest.this.queryDAO.getCountRmaIdentifier(existingID);
                TestCase.assertEquals((int)1, (int)count);
                return null;
            }
        });
    }

    @Test
    public void testGetChildrenWithPropertyValues_childrenWithValues() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef parentFolder;
            NodeRef file1;
            NodeRef file2;
            NodeRef file3;
            String propValue1 = "descr1";
            String propValue2 = "descr2";
            String propValue3 = "descr3";
            Set<String> propertyValues;

            @Override
            public void given() throws Exception {
                RecordsManagementQueryDAOImplTest.this.setupCollaborationSiteTestDataImpl();
                this.parentFolder = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(RecordsManagementQueryDAOImplTest.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.file1 = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(this.parentFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.file2 = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(this.parentFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.file3 = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(this.parentFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                RecordsManagementQueryDAOImplTest.this.nodeService.setProperty(this.file1, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)this.propValue1));
                RecordsManagementQueryDAOImplTest.this.nodeService.setProperty(this.file2, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)this.propValue2));
                RecordsManagementQueryDAOImplTest.this.nodeService.setProperty(this.file3, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)this.propValue3));
            }

            @Override
            public void when() throws Exception {
                this.propertyValues = RecordsManagementQueryDAOImplTest.this.queryDAO.getChildrenStringPropertyValues(this.parentFolder, ContentModel.PROP_DESCRIPTION);
            }

            @Override
            public void then() throws Exception {
                ImmutableSet expectedValues = ImmutableSet.of((Object)this.propValue1, (Object)this.propValue2, (Object)this.propValue3);
                TestCase.assertEquals((int)this.propertyValues.size(), (int)expectedValues.size());
                TestCase.assertTrue((boolean)this.propertyValues.containsAll((Collection<?>)expectedValues));
            }

            @Override
            public void after() throws Exception {
                if (this.parentFolder != null && RecordsManagementQueryDAOImplTest.this.nodeService.exists(this.parentFolder)) {
                    RecordsManagementQueryDAOImplTest.this.nodeService.deleteNode(this.parentFolder);
                }
            }
        });
    }

    @Test
    public void testGetChildrenWithPropertyValues_someChildrenWithValues() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef parentFolder;
            NodeRef file1;
            NodeRef file2;
            NodeRef file3;
            String propValue1 = "descr1";
            String propValue2 = "descr2";
            Set<String> propertyValues;

            @Override
            public void given() throws Exception {
                RecordsManagementQueryDAOImplTest.this.setupCollaborationSiteTestDataImpl();
                this.parentFolder = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(RecordsManagementQueryDAOImplTest.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.file1 = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(this.parentFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.file2 = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(this.parentFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.file3 = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(this.parentFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                RecordsManagementQueryDAOImplTest.this.nodeService.setProperty(this.file1, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)this.propValue1));
                RecordsManagementQueryDAOImplTest.this.nodeService.setProperty(this.file2, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)this.propValue2));
            }

            @Override
            public void when() throws Exception {
                this.propertyValues = RecordsManagementQueryDAOImplTest.this.queryDAO.getChildrenStringPropertyValues(this.parentFolder, ContentModel.PROP_DESCRIPTION);
            }

            @Override
            public void then() throws Exception {
                ImmutableSet expectedValues = ImmutableSet.of((Object)this.propValue1, (Object)this.propValue2);
                TestCase.assertEquals((int)this.propertyValues.size(), (int)expectedValues.size());
                TestCase.assertTrue((boolean)this.propertyValues.containsAll((Collection<?>)expectedValues));
            }

            @Override
            public void after() throws Exception {
                if (this.parentFolder != null && RecordsManagementQueryDAOImplTest.this.nodeService.exists(this.parentFolder)) {
                    RecordsManagementQueryDAOImplTest.this.nodeService.deleteNode(this.parentFolder);
                }
            }
        });
    }

    @Test
    public void testGetChildrenWithPropertyValues_propertyNotSetOnChildren() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef parentFolder;
            NodeRef file1;
            NodeRef file2;
            NodeRef file3;
            Set<String> propertyValues;

            @Override
            public void given() throws Exception {
                RecordsManagementQueryDAOImplTest.this.setupCollaborationSiteTestDataImpl();
                this.parentFolder = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(RecordsManagementQueryDAOImplTest.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.file1 = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(this.parentFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.file2 = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(this.parentFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.file3 = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(this.parentFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            }

            @Override
            public void when() throws Exception {
                this.propertyValues = RecordsManagementQueryDAOImplTest.this.queryDAO.getChildrenStringPropertyValues(this.parentFolder, ContentModel.PROP_DESCRIPTION);
            }

            @Override
            public void then() throws Exception {
                TestCase.assertTrue((boolean)this.propertyValues.isEmpty());
            }

            @Override
            public void after() throws Exception {
                if (this.parentFolder != null && RecordsManagementQueryDAOImplTest.this.nodeService.exists(this.parentFolder)) {
                    RecordsManagementQueryDAOImplTest.this.nodeService.deleteNode(this.parentFolder);
                }
            }
        });
    }

    @Test
    public void testGetChildrenWithPropertyValues_noChildren() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef folder;
            String propValue = "descr";
            Set<String> propertyValues;

            @Override
            public void given() throws Exception {
                RecordsManagementQueryDAOImplTest.this.setupCollaborationSiteTestDataImpl();
                this.folder = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(RecordsManagementQueryDAOImplTest.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                RecordsManagementQueryDAOImplTest.this.nodeService.setProperty(this.folder, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)this.propValue));
            }

            @Override
            public void when() throws Exception {
                this.propertyValues = RecordsManagementQueryDAOImplTest.this.queryDAO.getChildrenStringPropertyValues(this.folder, ContentModel.PROP_DESCRIPTION);
            }

            @Override
            public void then() throws Exception {
                TestCase.assertTrue((boolean)this.propertyValues.isEmpty());
            }

            @Override
            public void after() throws Exception {
                if (this.folder != null && RecordsManagementQueryDAOImplTest.this.nodeService.exists(this.folder)) {
                    RecordsManagementQueryDAOImplTest.this.nodeService.deleteNode(this.folder);
                }
            }
        });
    }

    @Test
    public void testGetChildrenWithPropertyValues_propertyNotUsed() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef parentFolder;
            QName property;
            Set<String> propertyValues;

            @Override
            public void given() throws Exception {
                RecordsManagementQueryDAOImplTest.this.setupCollaborationSiteTestDataImpl();
                this.parentFolder = RecordsManagementQueryDAOImplTest.this.fileFolderService.create(RecordsManagementQueryDAOImplTest.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                RecordsManagementQueryDAOImplTest.this.fileFolderService.create(this.parentFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                RecordsManagementQueryDAOImplTest.this.fileFolderService.create(this.parentFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                this.property = QName.createQName((String)RecordsManagementQueryDAOImplTest.this.URI, (String)("customProp-" + GUID.generate()));
            }

            @Override
            public void when() throws Exception {
                this.propertyValues = RecordsManagementQueryDAOImplTest.this.queryDAO.getChildrenStringPropertyValues(RecordsManagementQueryDAOImplTest.this.folder, this.property);
            }

            @Override
            public void then() throws Exception {
                TestCase.assertTrue((boolean)this.propertyValues.isEmpty());
            }

            @Override
            public void after() throws Exception {
                if (RecordsManagementQueryDAOImplTest.this.folder != null && RecordsManagementQueryDAOImplTest.this.nodeService.exists(RecordsManagementQueryDAOImplTest.this.folder)) {
                    RecordsManagementQueryDAOImplTest.this.nodeService.deleteNode(RecordsManagementQueryDAOImplTest.this.folder);
                }
            }
        });
    }
}

