/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.relationship;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementCustomModel;
import org.alfresco.module.org_alfresco_module_rm.relationship.Relationship;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;

public class DeleteRelationshipTest
extends BaseRMTestCase {
    public void testDeleteRelationship() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef sourceNode;
            NodeRef targetNode;
            String associationName = RecordsManagementCustomModel.CUSTOM_REF_OBSOLETES.getLocalName();

            @Override
            public void given() {
                this.sourceNode = DeleteRelationshipTest.this.utils.createRecord(DeleteRelationshipTest.this.rmFolder, GUID.generate());
                this.targetNode = DeleteRelationshipTest.this.utils.createRecord(DeleteRelationshipTest.this.rmFolder, GUID.generate());
                DeleteRelationshipTest.this.relationshipService.addRelationship(this.associationName, this.sourceNode, this.targetNode);
            }

            @Override
            public void when() {
                DeleteRelationshipTest.this.relationshipService.removeRelationship(this.associationName, this.sourceNode, this.targetNode);
            }

            @Override
            public void then() {
                Set relationships = DeleteRelationshipTest.this.relationshipService.getRelationshipsFrom(this.sourceNode);
                for (Relationship r : relationships) {
                    TestCase.assertFalse((r.getTarget().equals((Object)this.targetNode) && r.getUniqueName().equals(this.associationName) ? 1 : 0) != 0);
                }
            }
        });
    }

    public void testReadOnlyPermissionOnSource() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class){
            private String roleName;
            private String user;
            private NodeRef sourceRecordCategory;
            private NodeRef targetRecordCategory;
            private NodeRef sourceRecordFolder;
            private NodeRef targetRecordFolder;
            private NodeRef sourceRecord;
            private NodeRef targetRecord;
            {
                this.roleName = GUID.generate();
                this.user = GUID.generate();
            }

            @Override
            public void given() throws Exception {
                this.sourceRecordCategory = DeleteRelationshipTest.this.filePlanService.createRecordCategory(DeleteRelationshipTest.this.filePlan, GUID.generate());
                this.sourceRecordFolder = DeleteRelationshipTest.this.recordFolderService.createRecordFolder(this.sourceRecordCategory, GUID.generate());
                this.sourceRecord = DeleteRelationshipTest.this.utils.createRecord(this.sourceRecordFolder, GUID.generate());
                this.targetRecordCategory = DeleteRelationshipTest.this.filePlanService.createRecordCategory(DeleteRelationshipTest.this.filePlan, GUID.generate());
                this.targetRecordFolder = DeleteRelationshipTest.this.recordFolderService.createRecordFolder(this.targetRecordCategory, GUID.generate());
                this.targetRecord = DeleteRelationshipTest.this.utils.createRecord(this.targetRecordFolder, GUID.generate());
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(DeleteRelationshipTest.this.capabilityService.getCapability("ViewRecords"));
                capabilities.add(DeleteRelationshipTest.this.capabilityService.getCapability("ChangeOrDeleteReferences"));
                DeleteRelationshipTest.this.filePlanRoleService.createRole(DeleteRelationshipTest.this.filePlan, this.roleName, this.roleName, capabilities);
                DeleteRelationshipTest.this.createPerson(this.user, true);
                DeleteRelationshipTest.this.filePlanRoleService.assignRoleToAuthority(DeleteRelationshipTest.this.filePlan, this.roleName, this.user);
                DeleteRelationshipTest.this.relationshipService.addRelationship("crossreference", this.sourceRecord, this.targetRecord);
            }

            @Override
            public void when() {
                DeleteRelationshipTest.this.filePlanPermissionService.setPermission(this.sourceRecord, this.user, "ReadRecords");
                DeleteRelationshipTest.this.filePlanPermissionService.setPermission(this.targetRecord, this.user, "Filing");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        DeleteRelationshipTest.this.relationshipService.removeRelationship("crossreference", sourceRecord, targetRecord);
                        return null;
                    }
                }, (String)this.user);
            }
        });
    }

    public void testReadOnlyPermissionOnTarget() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class){
            private String roleName;
            private String user;
            private NodeRef sourceRecordCategory;
            private NodeRef targetRecordCategory;
            private NodeRef sourceRecordFolder;
            private NodeRef targetRecordFolder;
            private NodeRef sourceRecord;
            private NodeRef targetRecord;
            {
                this.roleName = GUID.generate();
                this.user = GUID.generate();
            }

            @Override
            public void given() throws Exception {
                this.sourceRecordCategory = DeleteRelationshipTest.this.filePlanService.createRecordCategory(DeleteRelationshipTest.this.filePlan, GUID.generate());
                this.sourceRecordFolder = DeleteRelationshipTest.this.recordFolderService.createRecordFolder(this.sourceRecordCategory, GUID.generate());
                this.sourceRecord = DeleteRelationshipTest.this.utils.createRecord(this.sourceRecordFolder, GUID.generate());
                this.targetRecordCategory = DeleteRelationshipTest.this.filePlanService.createRecordCategory(DeleteRelationshipTest.this.filePlan, GUID.generate());
                this.targetRecordFolder = DeleteRelationshipTest.this.recordFolderService.createRecordFolder(this.targetRecordCategory, GUID.generate());
                this.targetRecord = DeleteRelationshipTest.this.utils.createRecord(this.targetRecordFolder, GUID.generate());
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(DeleteRelationshipTest.this.capabilityService.getCapability("ViewRecords"));
                capabilities.add(DeleteRelationshipTest.this.capabilityService.getCapability("ChangeOrDeleteReferences"));
                DeleteRelationshipTest.this.filePlanRoleService.createRole(DeleteRelationshipTest.this.filePlan, this.roleName, this.roleName, capabilities);
                DeleteRelationshipTest.this.createPerson(this.user, true);
                DeleteRelationshipTest.this.filePlanRoleService.assignRoleToAuthority(DeleteRelationshipTest.this.filePlan, this.roleName, this.user);
                DeleteRelationshipTest.this.relationshipService.addRelationship("crossreference", this.sourceRecord, this.targetRecord);
            }

            @Override
            public void when() {
                DeleteRelationshipTest.this.filePlanPermissionService.setPermission(this.sourceRecord, this.user, "Filing");
                DeleteRelationshipTest.this.filePlanPermissionService.setPermission(this.targetRecord, this.user, "ReadRecords");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        DeleteRelationshipTest.this.relationshipService.removeRelationship("crossreference", sourceRecord, targetRecord);
                        return null;
                    }
                }, (String)this.user);
            }
        });
    }

    public void testFillingPermissionOnSourceAndTarget() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private String roleName = GUID.generate();
            private String user = GUID.generate();
            private NodeRef sourceRecordCategory;
            private NodeRef targetRecordCategory;
            private NodeRef sourceRecordFolder;
            private NodeRef targetRecordFolder;
            private NodeRef sourceRecord;
            private NodeRef targetRecord;

            @Override
            public void given() throws Exception {
                this.sourceRecordCategory = DeleteRelationshipTest.this.filePlanService.createRecordCategory(DeleteRelationshipTest.this.filePlan, GUID.generate());
                this.sourceRecordFolder = DeleteRelationshipTest.this.recordFolderService.createRecordFolder(this.sourceRecordCategory, GUID.generate());
                this.sourceRecord = DeleteRelationshipTest.this.utils.createRecord(this.sourceRecordFolder, GUID.generate());
                this.targetRecordCategory = DeleteRelationshipTest.this.filePlanService.createRecordCategory(DeleteRelationshipTest.this.filePlan, GUID.generate());
                this.targetRecordFolder = DeleteRelationshipTest.this.recordFolderService.createRecordFolder(this.targetRecordCategory, GUID.generate());
                this.targetRecord = DeleteRelationshipTest.this.utils.createRecord(this.targetRecordFolder, GUID.generate());
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(DeleteRelationshipTest.this.capabilityService.getCapability("ViewRecords"));
                capabilities.add(DeleteRelationshipTest.this.capabilityService.getCapability("ChangeOrDeleteReferences"));
                DeleteRelationshipTest.this.filePlanRoleService.createRole(DeleteRelationshipTest.this.filePlan, this.roleName, this.roleName, capabilities);
                DeleteRelationshipTest.this.createPerson(this.user, true);
                DeleteRelationshipTest.this.filePlanRoleService.assignRoleToAuthority(DeleteRelationshipTest.this.filePlan, this.roleName, this.user);
                DeleteRelationshipTest.this.relationshipService.addRelationship("crossreference", this.sourceRecord, this.targetRecord);
            }

            @Override
            public void when() {
                DeleteRelationshipTest.this.filePlanPermissionService.setPermission(this.sourceRecordCategory, this.user, "Filing");
                DeleteRelationshipTest.this.filePlanPermissionService.setPermission(this.targetRecordCategory, this.user, "Filing");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        DeleteRelationshipTest.this.relationshipService.removeRelationship("crossreference", sourceRecord, targetRecord);
                        return null;
                    }
                }, (String)this.user);
            }

            @Override
            public void then() throws Exception {
                TestCase.assertEquals((int)0, (int)DeleteRelationshipTest.this.relationshipService.getRelationshipsFrom(this.sourceRecord).size());
                TestCase.assertEquals((int)0, (int)DeleteRelationshipTest.this.relationshipService.getRelationshipsTo(this.sourceRecord).size());
                TestCase.assertEquals((int)0, (int)DeleteRelationshipTest.this.relationshipService.getRelationshipsFrom(this.targetRecord).size());
                TestCase.assertEquals((int)0, (int)DeleteRelationshipTest.this.relationshipService.getRelationshipsTo(this.targetRecord).size());
            }
        });
    }
}

