/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM1008Test
extends BaseRMTestCase {
    private String myUser;

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setupTestUsersImpl(NodeRef filePlan) {
        super.setupTestUsersImpl(filePlan);
        this.myUser = GUID.generate();
        this.createPerson(this.myUser);
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "User", this.myUser);
    }

    public void testContainers() throws Exception {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef holdContainer = RM1008Test.this.filePlanService.getHoldContainer(RM1008Test.this.filePlan);
                TestCase.assertNotNull((Object)holdContainer);
                NodeRef transferContainer = RM1008Test.this.filePlanService.getTransferContainer(RM1008Test.this.filePlan);
                TestCase.assertNotNull((Object)transferContainer);
                Capability viewRecords = RM1008Test.this.capabilityService.getCapability("ViewRecords");
                TestCase.assertNotNull((Object)viewRecords);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)viewRecords.hasPermission(holdContainer));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)viewRecords.hasPermission(transferContainer));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RM1008Test.this.permissionService.hasPermission(holdContainer, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RM1008Test.this.permissionService.hasPermission(transferContainer, "Filing"));
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef holdContainer = RM1008Test.this.filePlanService.getHoldContainer(RM1008Test.this.filePlan);
                TestCase.assertNotNull((Object)holdContainer);
                NodeRef transferContainer = RM1008Test.this.filePlanService.getTransferContainer(RM1008Test.this.filePlan);
                TestCase.assertNotNull((Object)transferContainer);
                Capability viewRecords = RM1008Test.this.capabilityService.getCapability("ViewRecords");
                TestCase.assertNotNull((Object)viewRecords);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)viewRecords.hasPermission(holdContainer));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)viewRecords.hasPermission(transferContainer));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM1008Test.this.permissionService.hasPermission(holdContainer, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM1008Test.this.permissionService.hasPermission(transferContainer, "Filing"));
                return null;
            }
        }, this.myUser);
    }

    public void testHold() {
        final NodeRef hold = (NodeRef)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef hold = RM1008Test.this.holdService.createHold(RM1008Test.this.filePlan, "my hold", "my reason", "my description");
                RM1008Test.this.holdService.addToHold(hold, RM1008Test.this.rmFolder);
                return hold;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Capability viewRecords = RM1008Test.this.capabilityService.getCapability("ViewRecords");
                TestCase.assertNotNull((Object)viewRecords);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)viewRecords.hasPermission(hold));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RM1008Test.this.permissionService.hasPermission(hold, "Filing"));
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Capability viewRecords = RM1008Test.this.capabilityService.getCapability("ViewRecords");
                TestCase.assertNotNull((Object)viewRecords);
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)viewRecords.hasPermission(hold));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM1008Test.this.permissionService.hasPermission(hold, "Filing"));
                return null;
            }
        }, this.myUser);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM1008Test.this.filePlanPermissionService.setPermission(RM1008Test.this.filePlan, RM1008Test.this.myUser, "Filing");
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Capability viewRecords = RM1008Test.this.capabilityService.getCapability("ViewRecords");
                TestCase.assertNotNull((Object)viewRecords);
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)viewRecords.hasPermission(hold));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM1008Test.this.permissionService.hasPermission(hold, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM1008Test.this.permissionService.hasPermission(hold, "Filing"));
                return null;
            }
        }, this.myUser);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM1008Test.this.filePlanPermissionService.deletePermission(RM1008Test.this.filePlan, RM1008Test.this.myUser, "Filing");
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Capability viewRecords = RM1008Test.this.capabilityService.getCapability("ViewRecords");
                TestCase.assertNotNull((Object)viewRecords);
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)viewRecords.hasPermission(hold));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM1008Test.this.permissionService.hasPermission(hold, "Filing"));
                return null;
            }
        }, this.myUser);
    }

    public void testTransfer() {
        final NodeRef transferFolder = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef transferCat = RM1008Test.this.filePlanService.createRecordCategory(RM1008Test.this.filePlan, "transferCat");
                HashMap<QName, Object> dsProps = new HashMap<QName, Object>(3);
                dsProps.put(RecordsManagementModel.PROP_DISPOSITION_AUTHORITY, "test");
                dsProps.put(RecordsManagementModel.PROP_DISPOSITION_INSTRUCTIONS, "test");
                dsProps.put(RecordsManagementModel.PROP_RECORD_LEVEL_DISPOSITION, false);
                DispositionSchedule dispositionSchedule = RM1008Test.this.dispositionService.createDispositionSchedule(transferCat, dsProps);
                HashMap<QName, String> adParams = new HashMap<QName, String>(3);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "cutoff");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, "test");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, "immediately|0");
                RM1008Test.this.dispositionService.addDispositionActionDefinition(dispositionSchedule, adParams);
                adParams = new HashMap(3);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "transfer");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, "test");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, "immediately|0");
                RM1008Test.this.dispositionService.addDispositionActionDefinition(dispositionSchedule, adParams);
                return RM1008Test.this.recordFolderService.createRecordFolder(transferCat, "transferFolder");
            }
        });
        final NodeRef transfer = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                RM1008Test.this.rmActionService.executeRecordsManagementAction(transferFolder, "cutoff");
                RM1008Test.this.rmActionService.executeRecordsManagementAction(transferFolder, "transfer");
                NodeRef transferContainer = RM1008Test.this.filePlanService.getTransferContainer(RM1008Test.this.filePlan);
                List childAssocs = RM1008Test.this.nodeService.getChildAssocs(transferContainer, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                return ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
            }

            public void test(NodeRef result) throws Exception {
                TestCase.assertNotNull((Object)result);
                TestCase.assertEquals((Object)RecordsManagementModel.TYPE_TRANSFER, (Object)RM1008Test.this.nodeService.getType(result));
            }
        });
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Capability viewRecords = RM1008Test.this.capabilityService.getCapability("ViewRecords");
                TestCase.assertNotNull((Object)viewRecords);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)viewRecords.hasPermission(transfer));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RM1008Test.this.permissionService.hasPermission(transfer, "Filing"));
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Capability viewRecords = RM1008Test.this.capabilityService.getCapability("ViewRecords");
                TestCase.assertNotNull((Object)viewRecords);
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)viewRecords.hasPermission(transfer));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM1008Test.this.permissionService.hasPermission(transfer, "Filing"));
                return null;
            }
        }, this.myUser);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM1008Test.this.filePlanPermissionService.setPermission(RM1008Test.this.filePlan, RM1008Test.this.myUser, "Filing");
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Capability viewRecords = RM1008Test.this.capabilityService.getCapability("ViewRecords");
                TestCase.assertNotNull((Object)viewRecords);
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)viewRecords.hasPermission(transfer));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM1008Test.this.permissionService.hasPermission(transfer, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM1008Test.this.permissionService.hasPermission(transfer, "Filing"));
                return null;
            }
        }, this.myUser);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM1008Test.this.filePlanPermissionService.deletePermission(RM1008Test.this.filePlan, RM1008Test.this.myUser, "Filing");
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Capability viewRecords = RM1008Test.this.capabilityService.getCapability("ViewRecords");
                TestCase.assertNotNull((Object)viewRecords);
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)viewRecords.hasPermission(transfer));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)RM1008Test.this.permissionService.hasPermission(transfer, "Filing"));
                return null;
            }
        }, this.myUser);
    }
}

