/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementCustomModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;

public class RM1914Test
extends BaseRMTestCase {
    NodeRef record1;
    NodeRef transferFolder;

    public void testRM1914() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() {
                NodeRef category1 = RM1914Test.this.filePlanService.createRecordCategory(RM1914Test.this.filePlan, GUID.generate());
                NodeRef category2 = RM1914Test.this.filePlanService.createRecordCategory(RM1914Test.this.filePlan, GUID.generate());
                HashMap<QName, Object> dsProps = new HashMap<QName, Object>(3);
                dsProps.put(RecordsManagementModel.PROP_DISPOSITION_AUTHORITY, "disposition authority");
                dsProps.put(RecordsManagementModel.PROP_DISPOSITION_INSTRUCTIONS, GUID.generate());
                dsProps.put(RecordsManagementModel.PROP_RECORD_LEVEL_DISPOSITION, true);
                DispositionSchedule dispositionSchedule1 = RM1914Test.this.dispositionService.createDispositionSchedule(category1, dsProps);
                NodeRef folder1 = RM1914Test.this.recordFolderService.createRecordFolder(category1, GUID.generate());
                HashMap<QName, Object> dispositionAction1 = new HashMap<QName, Object>(3);
                dispositionAction1.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "cutoff");
                dispositionAction1.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, GUID.generate());
                ArrayList<String> events = new ArrayList<String>(1);
                events.add("related_record_trasfered_inactive_storage");
                dispositionAction1.put(RecordsManagementModel.PROP_DISPOSITION_EVENT, events);
                RM1914Test.this.dispositionService.addDispositionActionDefinition(dispositionSchedule1, dispositionAction1);
                RM1914Test.this.record1 = RM1914Test.this.recordService.createRecordFromContent(folder1, GUID.generate(), ContentModel.TYPE_CONTENT, null, null);
                DispositionSchedule dispositionSchedule2 = RM1914Test.this.dispositionService.createDispositionSchedule(category2, dsProps);
                HashMap<QName, String> dispositionAction2_1 = new HashMap<QName, String>(3);
                dispositionAction2_1.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "cutoff");
                dispositionAction2_1.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, GUID.generate());
                dispositionAction2_1.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, "immediately|0");
                RM1914Test.this.dispositionService.addDispositionActionDefinition(dispositionSchedule2, dispositionAction2_1);
                HashMap<QName, String> dispositionAction2_2 = new HashMap<QName, String>(4);
                dispositionAction2_2.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "transfer");
                dispositionAction2_2.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, GUID.generate());
                dispositionAction2_2.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, "immediately|0");
                dispositionAction2_2.put(RecordsManagementModel.PROP_DISPOSITION_LOCATION, "");
                RM1914Test.this.dispositionService.addDispositionActionDefinition(dispositionSchedule2, dispositionAction2_2);
                NodeRef folder2 = RM1914Test.this.recordFolderService.createRecordFolder(category2, GUID.generate());
                NodeRef record2 = RM1914Test.this.recordService.createRecordFromContent(folder2, GUID.generate(), ContentModel.TYPE_CONTENT, null, null);
                RM1914Test.this.utils.completeRecord(RM1914Test.this.record1);
                RM1914Test.this.utils.completeRecord(record2);
                RM1914Test.this.relationshipService.addRelationship(RecordsManagementCustomModel.CUSTOM_REF_CROSSREFERENCE.getLocalName(), RM1914Test.this.record1, record2);
                RM1914Test.this.rmActionService.executeRecordsManagementAction(record2, "cutoff", null);
                RM1914Test.this.transferFolder = (NodeRef)RM1914Test.this.rmActionService.executeRecordsManagementAction(record2, "transfer").getValue();
            }

            @Override
            public void when() {
                RM1914Test.this.rmActionService.executeRecordsManagementAction(RM1914Test.this.transferFolder, "transferComplete");
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)RM1914Test.this.dispositionService.isNextDispositionActionEligible(RM1914Test.this.record1));
            }
        });
    }
}

