/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.constraint;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.repo.action.constraint.BaseParameterConstraint;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class RecordTypeParameterConstraint
extends BaseParameterConstraint {
    public static final String NAME = "rm-ac-record-types";
    private RecordService recordService;
    private DictionaryService dictionaryService;
    private FilePlanService filePlanService;

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    protected Map<String, String> getAllowableValuesImpl() {
        return (Map)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, String>>(){

            public Map<String, String> doWork() {
                HashMap<String, String> result = Collections.EMPTY_MAP;
                NodeRef filePlan = RecordTypeParameterConstraint.this.filePlanService.getFilePlanBySiteId("rm");
                if (filePlan != null) {
                    Set<QName> recordTypes = RecordTypeParameterConstraint.this.recordService.getRecordMetadataAspects(filePlan);
                    result = new HashMap<String, String>(recordTypes.size());
                    for (QName recordType : recordTypes) {
                        AspectDefinition aspectDefinition = RecordTypeParameterConstraint.this.dictionaryService.getAspect(recordType);
                        if (aspectDefinition == null) continue;
                        result.put(aspectDefinition.getName().getLocalName(), aspectDefinition.getTitle((MessageLookup)new StaticMessageLookup()));
                    }
                }
                return result;
            }
        });
    }
}

