/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.HashMap;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.springframework.extensions.webscripts.GUID;

public class FilePlanPermissionServiceImplTest
extends BaseRMTestCase {
    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    private String createTestUser() {
        return (String)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<String>(){

            public String run() {
                String userName = GUID.generate();
                FilePlanPermissionServiceImplTest.this.createPerson(userName);
                FilePlanPermissionServiceImplTest.this.filePlanRoleService.assignRoleToAuthority(FilePlanPermissionServiceImplTest.this.filePlan, "User", userName);
                return userName;
            }
        }, AuthenticationUtil.getSystemUserName());
    }

    private void setPermission(final NodeRef nodeRef, final String userName, final String permission) {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                FilePlanPermissionServiceImplTest.this.filePlanPermissionService.setPermission(nodeRef, userName, permission);
                return null;
            }
        });
    }

    private void deletePermission(final NodeRef nodeRef, final String userName, final String permission) {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                FilePlanPermissionServiceImplTest.this.filePlanPermissionService.deletePermission(nodeRef, userName, permission);
                return null;
            }
        });
    }

    public void testSetDeletePermissionFilePlan() throws Exception {
        String userName = this.createTestUser();
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        this.setPermission(this.filePlan, userName, "Filing");
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        this.deletePermission(this.filePlan, userName, "Filing");
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        this.deletePermission(this.filePlan, userName, "ReadRecords");
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
    }

    public void testSetDeletePermissionRecordCategory() throws Exception {
        String userName = this.createTestUser();
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        this.setPermission(this.rmContainer, userName, "Filing");
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED);
        this.deletePermission(this.rmContainer, userName, "Filing");
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
    }

    public void testSetDeletePermissionRecordFolder() throws Exception {
        String userName = this.createTestUser();
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        this.setPermission(this.rmFolder, userName, "Filing");
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED);
        this.deletePermission(this.rmFolder, userName, "Filing");
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
    }

    public void testSetDeletePermissionRecord() throws Exception {
        String userName = this.createTestUser();
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        this.setPermission(this.recordOne, userName, "Filing");
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED);
        this.deletePermission(this.recordOne, userName, "Filing");
        this.assertPermissions(userName, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
    }

    public void testMoveRecord() throws Exception {
        String userOne = this.createTestUser();
        String userTwo = this.createTestUser();
        String userThree = this.createTestUser();
        final NodeRef otherFolder = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                return FilePlanPermissionServiceImplTest.this.recordFolderService.createRecordFolder(FilePlanPermissionServiceImplTest.this.rmContainer, "otherFolder");
            }
        });
        this.assertPermissions(userOne, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "Filing"));
                return null;
            }
        }, userOne);
        this.assertPermissions(userTwo, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "Filing"));
                return null;
            }
        }, userTwo);
        this.assertPermissions(userThree, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "Filing"));
                return null;
            }
        }, userThree);
        this.setPermission(this.rmFolder, userOne, "Filing");
        this.setPermission(otherFolder, userTwo, "Filing");
        this.setPermission(this.recordOne, userThree, "Filing");
        this.assertPermissions(userOne, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "Filing"));
                return null;
            }
        }, userOne);
        this.assertPermissions(userTwo, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "Filing"));
                return null;
            }
        }, userTwo);
        this.assertPermissions(userThree, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "Filing"));
                return null;
            }
        }, userThree);
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                FilePlanPermissionServiceImplTest.this.fileFolderService.move(FilePlanPermissionServiceImplTest.this.recordOne, otherFolder, "movedRecord.txt");
                return null;
            }
        });
        this.assertPermissions(userOne, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "Filing"));
                return null;
            }
        }, userOne);
        this.assertPermissions(userTwo, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "Filing"));
                return null;
            }
        }, userTwo);
        this.assertPermissions(userThree, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(otherFolder, "Filing"));
                return null;
            }
        }, userThree);
    }

    private void assertPermissions(String userName, final AccessStatus ... accessStatus) {
        FilePlanPermissionServiceImplTest.assertEquals((int)8, (int)accessStatus.length);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((String)"Everyone who has a role has read permissions on the file plan", (Object)accessStatus[0], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.filePlan, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[1], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.filePlan, "Filing"));
                TestCase.assertEquals((Object)accessStatus[2], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.rmContainer, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[3], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.rmContainer, "Filing"));
                TestCase.assertEquals((Object)accessStatus[4], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.rmFolder, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[5], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.rmFolder, "Filing"));
                TestCase.assertEquals((Object)accessStatus[6], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.recordOne, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[7], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.recordOne, "Filing"));
                return null;
            }
        }, userName);
    }

    private void assertPermissionsWithInheritance(String userName, final NodeRef subCategory, final NodeRef folder, final NodeRef record, final AccessStatus ... accessStatus) {
        FilePlanPermissionServiceImplTest.assertEquals((int)16, (int)accessStatus.length);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)accessStatus[0], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.filePlan, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[1], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.filePlan, "Filing"));
                TestCase.assertEquals((Object)accessStatus[2], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.transfersContainer, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[3], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.transfersContainer, "Filing"));
                TestCase.assertEquals((Object)accessStatus[4], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.holdsContainer, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[5], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.holdsContainer, "Filing"));
                TestCase.assertEquals((Object)accessStatus[6], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.unfiledContainer, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[7], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.unfiledContainer, "Filing"));
                TestCase.assertEquals((Object)accessStatus[8], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.rmContainer, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[9], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.rmContainer, "Filing"));
                TestCase.assertEquals((Object)accessStatus[10], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(subCategory, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[11], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(subCategory, "Filing"));
                TestCase.assertEquals((Object)accessStatus[12], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[13], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder, "Filing"));
                TestCase.assertEquals((Object)accessStatus[14], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                TestCase.assertEquals((Object)accessStatus[15], (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                return null;
            }
        }, userName);
    }

    public void testFilePlanComponentInheritance() {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertFalse((boolean)FilePlanPermissionServiceImplTest.this.permissionService.getInheritParentPermissions(FilePlanPermissionServiceImplTest.this.filePlan));
                TestCase.assertFalse((boolean)FilePlanPermissionServiceImplTest.this.permissionService.getInheritParentPermissions(FilePlanPermissionServiceImplTest.this.filePlanService.getTransferContainer(FilePlanPermissionServiceImplTest.this.filePlan)));
                TestCase.assertFalse((boolean)FilePlanPermissionServiceImplTest.this.permissionService.getInheritParentPermissions(FilePlanPermissionServiceImplTest.this.filePlanService.getHoldContainer(FilePlanPermissionServiceImplTest.this.filePlan)));
                TestCase.assertFalse((boolean)FilePlanPermissionServiceImplTest.this.permissionService.getInheritParentPermissions(FilePlanPermissionServiceImplTest.this.unfiledContainer));
                TestCase.assertFalse((boolean)FilePlanPermissionServiceImplTest.this.permissionService.getInheritParentPermissions(FilePlanPermissionServiceImplTest.this.rmContainer));
                TestCase.assertTrue((boolean)FilePlanPermissionServiceImplTest.this.permissionService.getInheritParentPermissions(FilePlanPermissionServiceImplTest.this.recordFolderService.createRecordFolder(FilePlanPermissionServiceImplTest.this.rmContainer, "subCategory")));
                TestCase.assertTrue((boolean)FilePlanPermissionServiceImplTest.this.permissionService.getInheritParentPermissions(FilePlanPermissionServiceImplTest.this.rmFolder));
                TestCase.assertTrue((boolean)FilePlanPermissionServiceImplTest.this.permissionService.getInheritParentPermissions(FilePlanPermissionServiceImplTest.this.recordOne));
                return null;
            }
        }, "admin");
    }

    public void testRolesSetByDefault() {
        NodeRef subCategory = this.filePlanService.createRecordCategory(this.rmContainer, "subCategory1");
        NodeRef folder = this.recordFolderService.createRecordFolder(subCategory, "rmFolder1");
        NodeRef record = this.utils.createRecord(folder, "record1.txt");
        this.assertPermissionsWithInheritance("admin", subCategory, folder, record, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED);
        this.assertPermissionsWithInheritance(this.createTestUser(), subCategory, folder, record, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
    }

    public void testAddUserToContainers() {
        NodeRef subCategory = this.filePlanService.createRecordCategory(this.rmContainer, "subCategory2");
        NodeRef folder = this.recordFolderService.createRecordFolder(subCategory, "rmFolder2");
        NodeRef record = this.utils.createRecord(folder, "record2.txt");
        String user1 = this.createTestUser();
        this.setPermission(this.filePlan, user1, "ReadRecords");
        this.assertPermissionsWithInheritance(user1, subCategory, folder, record, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        String user2 = this.createTestUser();
        this.setPermission(this.transfersContainer, user2, "Filing");
        this.assertPermissionsWithInheritance(user2, subCategory, folder, record, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        String user3 = this.createTestUser();
        this.setPermission(this.holdsContainer, user3, "ReadRecords");
        this.assertPermissionsWithInheritance(user3, subCategory, folder, record, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        String user4 = this.createTestUser();
        this.setPermission(this.unfiledContainer, user4, "Filing");
        this.assertPermissionsWithInheritance(user4, subCategory, folder, record, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED);
        String user5 = this.createTestUser();
        this.setPermission(this.rmContainer, user5, "ReadRecords");
        this.assertPermissionsWithInheritance(user5, subCategory, folder, record, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED);
        String user6 = this.createTestUser();
        this.setPermission(subCategory, user6, "Filing");
        this.assertPermissionsWithInheritance(user6, subCategory, folder, record, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED);
        String user7 = this.createTestUser();
        this.setPermission(folder, user7, "ReadRecords");
        this.assertPermissionsWithInheritance(user7, subCategory, folder, record, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED);
        String user8 = this.createTestUser();
        this.setPermission(record, user8, "Filing");
        this.assertPermissionsWithInheritance(user8, subCategory, folder, record, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.ALLOWED);
    }

    public void testAccessPermissionOnSingleRecordWithSeveralUsers() {
        final NodeRef subCategory = this.filePlanService.createRecordCategory(this.rmContainer, "subCategory3");
        final NodeRef folder = this.recordFolderService.createRecordFolder(subCategory, "rmFolder3");
        final NodeRef record = this.utils.createRecord(folder, "record3.txt");
        String user1 = this.createTestUser();
        String user2 = this.createTestUser();
        this.setPermission(this.rmContainer, user1, "ReadRecords");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.filePlan, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.rmContainer, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(subCategory, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                return null;
            }
        }, user1);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.filePlan, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.rmContainer, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(subCategory, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                return null;
            }
        }, user2);
    }

    public void testDenyPermissionsOnRecordsWithSeveralUsers() {
        final NodeRef subCategory = this.filePlanService.createRecordCategory(this.rmContainer, "subCategory4");
        final NodeRef folder = this.recordFolderService.createRecordFolder(subCategory, "rmFolder4");
        final NodeRef record4 = this.utils.createRecord(folder, "record4.txt");
        final NodeRef record5 = this.utils.createRecord(folder, "record5.txt");
        String user1 = this.createTestUser();
        String user2 = this.createTestUser();
        this.setPermission(this.rmContainer, user1, "ReadRecords");
        this.setPermission(this.rmContainer, user2, "ReadRecords");
        this.permissionService.setInheritParentPermissions(record4, false);
        this.permissionService.setInheritParentPermissions(record5, false);
        this.setPermission(record4, user1, "ReadRecords");
        this.setPermission(record5, user1, "ReadRecords");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.filePlan, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.rmContainer, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(subCategory, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record4, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record5, "ReadRecords"));
                return null;
            }
        }, user1);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.filePlan, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(FilePlanPermissionServiceImplTest.this.rmContainer, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(subCategory, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record4, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record5, "ReadRecords"));
                return null;
            }
        }, user2);
    }

    public void testMoveRootCategoryIntoAnotherRootCategory() {
        final NodeRef category5 = this.filePlanService.createRecordCategory(this.filePlan, "category5");
        final NodeRef category6 = this.filePlanService.createRecordCategory(this.filePlan, "category6");
        FilePlanPermissionServiceImplTest.assertFalse((boolean)this.permissionService.getInheritParentPermissions(category5));
        FilePlanPermissionServiceImplTest.assertFalse((boolean)this.permissionService.getInheritParentPermissions(category6));
        String user1 = this.createTestUser();
        String user2 = this.createTestUser();
        this.setPermission(category5, user1, "ReadRecords");
        this.setPermission(category6, user2, "Filing");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category5, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category5, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category6, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category6, "Filing"));
                return null;
            }
        }, user1);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category5, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category5, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category6, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category6, "Filing"));
                return null;
            }
        }, user2);
        final NodeRef movedCategory5 = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                return FilePlanPermissionServiceImplTest.this.fileFolderService.move(category5, category6, null).getNodeRef();
            }
        });
        FilePlanPermissionServiceImplTest.assertFalse((boolean)this.permissionService.getInheritParentPermissions(movedCategory5));
        FilePlanPermissionServiceImplTest.assertFalse((boolean)this.permissionService.getInheritParentPermissions(category6));
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(movedCategory5, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(movedCategory5, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category6, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category6, "Filing"));
                return null;
            }
        }, user1);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(movedCategory5, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(movedCategory5, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category6, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category6, "Filing"));
                return null;
            }
        }, user2);
    }

    public void testPermissionsForMovedRecord() {
        final NodeRef category7 = this.filePlanService.createRecordCategory(this.filePlan, "category7");
        final NodeRef folder7 = this.recordFolderService.createRecordFolder(category7, "rmFolder7");
        final NodeRef record7 = this.utils.createRecord(folder7, "record7.txt");
        final NodeRef category8 = this.filePlanService.createRecordCategory(this.filePlan, "category8");
        final NodeRef folder8 = this.recordFolderService.createRecordFolder(category8, "rmFolder8");
        final NodeRef record8 = this.utils.createRecord(folder8, "record8.txt");
        String user1 = this.createTestUser();
        String user2 = this.createTestUser();
        String user3 = this.createTestUser();
        this.setPermission(folder7, user1, "Filing");
        this.setPermission(record8, user2, "ReadRecords");
        this.setPermission(category7, user3, "Filing");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record8, "Filing"));
                return null;
            }
        }, user1);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record8, "Filing"));
                return null;
            }
        }, user2);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record8, "Filing"));
                return null;
            }
        }, user3);
        final NodeRef movedRecord8 = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                return FilePlanPermissionServiceImplTest.this.fileFolderService.move(record8, folder7, null).getNodeRef();
            }
        });
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(movedRecord8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(movedRecord8, "Filing"));
                return null;
            }
        }, user1);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(movedRecord8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(movedRecord8, "Filing"));
                return null;
            }
        }, user2);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(record7, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(category8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(folder8, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(movedRecord8, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FilePlanPermissionServiceImplTest.this.permissionService.hasPermission(movedRecord8, "Filing"));
                return null;
            }
        }, user3);
    }

    public void testSpecialRoles() {
        NodeRef category9 = this.filePlanService.createRecordCategory(this.filePlan, "category9");
        NodeRef subCategory9 = this.filePlanService.createRecordCategory(category9, "subCategory9");
        NodeRef folder9 = this.recordFolderService.createRecordFolder(subCategory9, "rmFolder9");
        NodeRef record9 = this.utils.createRecord(folder9, "record9.txt");
        this.assertExistenceOfSpecialRolesAndPermissions(category9);
        this.assertExistenceOfSpecialRolesAndPermissions(subCategory9);
        this.permissionService.setInheritParentPermissions(subCategory9, false);
        this.assertExistenceOfSpecialRolesAndPermissions(subCategory9);
        this.permissionService.setInheritParentPermissions(subCategory9, true);
        this.assertExistenceOfSpecialRolesAndPermissions(subCategory9);
        this.assertExistenceOfSpecialRolesAndPermissions(folder9);
        this.permissionService.setInheritParentPermissions(folder9, false);
        this.assertExistenceOfSpecialRolesAndPermissions(folder9);
        this.permissionService.setInheritParentPermissions(folder9, true);
        this.assertExistenceOfSpecialRolesAndPermissions(folder9);
        this.assertExistenceOfSpecialRolesAndPermissions(record9);
        this.permissionService.setInheritParentPermissions(record9, false);
        this.assertExistenceOfSpecialRolesAndPermissions(record9);
        this.permissionService.setInheritParentPermissions(record9, true);
        this.assertExistenceOfSpecialRolesAndPermissions(record9);
    }

    private void assertExistenceOfSpecialRolesAndPermissions(NodeRef node) {
        HashMap<String, String> accessPermissions = new HashMap<String, String>();
        Set permissions = this.permissionService.getAllSetPermissions(node);
        for (AccessPermission permission : permissions) {
            accessPermissions.put(permission.getAuthority(), permission.getPermission());
        }
        String adminRole = this.authorityService.getName(AuthorityType.GROUP, "Administrator" + this.filePlan.getId());
        FilePlanPermissionServiceImplTest.assertTrue((boolean)accessPermissions.containsKey(adminRole));
        FilePlanPermissionServiceImplTest.assertEquals((String)"Filing", (String)((String)accessPermissions.get(adminRole)));
    }

    public void testMoveSubCategoryIntoFilePlan() {
        NodeRef rootCategory = this.filePlanService.createRecordCategory(this.filePlan, GUID.generate());
        final NodeRef subCategory = this.filePlanService.createRecordCategory(rootCategory, GUID.generate());
        FilePlanPermissionServiceImplTest.assertFalse((boolean)this.permissionService.getInheritParentPermissions(rootCategory));
        FilePlanPermissionServiceImplTest.assertTrue((boolean)this.permissionService.getInheritParentPermissions(subCategory));
        NodeRef movedSubCategory = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                return FilePlanPermissionServiceImplTest.this.fileFolderService.move(subCategory, FilePlanPermissionServiceImplTest.this.filePlan, null).getNodeRef();
            }
        });
        FilePlanPermissionServiceImplTest.assertFalse((boolean)this.permissionService.getInheritParentPermissions(rootCategory));
        FilePlanPermissionServiceImplTest.assertFalse((boolean)this.permissionService.getInheritParentPermissions(movedSubCategory));
    }
}

