/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RecordsManagementServiceImplTest
extends BaseRMTestCase {
    public void testIsFilePlanComponent() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                TestCase.assertTrue((String)"The rm root container should be a rm component", (boolean)RecordsManagementServiceImplTest.this.filePlanService.isFilePlanComponent(RecordsManagementServiceImplTest.this.filePlan));
                TestCase.assertTrue((String)"The rm container should be a rm component", (boolean)RecordsManagementServiceImplTest.this.filePlanService.isFilePlanComponent(RecordsManagementServiceImplTest.this.rmContainer));
                TestCase.assertTrue((String)"The rm folder should be a rm component", (boolean)RecordsManagementServiceImplTest.this.filePlanService.isFilePlanComponent(RecordsManagementServiceImplTest.this.rmFolder));
                return null;
            }
        });
    }

    public void testGetFilePlanComponentKind() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                return RecordsManagementServiceImplTest.this.utils.createRecord(RecordsManagementServiceImplTest.this.rmFolder, "testRecord.txt");
            }

            public void test(NodeRef result) throws Exception {
                TestCase.assertEquals((Object)FilePlanComponentKind.FILE_PLAN, (Object)RecordsManagementServiceImplTest.this.filePlanService.getFilePlanComponentKind(RecordsManagementServiceImplTest.this.filePlan));
                TestCase.assertEquals((Object)FilePlanComponentKind.RECORD_CATEGORY, (Object)RecordsManagementServiceImplTest.this.filePlanService.getFilePlanComponentKind(RecordsManagementServiceImplTest.this.rmContainer));
                TestCase.assertEquals((Object)FilePlanComponentKind.RECORD_FOLDER, (Object)RecordsManagementServiceImplTest.this.filePlanService.getFilePlanComponentKind(RecordsManagementServiceImplTest.this.rmFolder));
                TestCase.assertEquals((Object)FilePlanComponentKind.RECORD, (Object)RecordsManagementServiceImplTest.this.filePlanService.getFilePlanComponentKind(result));
                TestCase.assertNull((Object)RecordsManagementServiceImplTest.this.filePlanService.getFilePlanComponentKind(RecordsManagementServiceImplTest.this.folder));
            }
        });
    }

    public void testIsFilePlan() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                TestCase.assertTrue((String)"This is a records management root", (boolean)RecordsManagementServiceImplTest.this.filePlanService.isFilePlan(RecordsManagementServiceImplTest.this.filePlan));
                TestCase.assertFalse((String)"This should not be a records management root", (boolean)RecordsManagementServiceImplTest.this.filePlanService.isFilePlan(RecordsManagementServiceImplTest.this.rmContainer));
                TestCase.assertFalse((String)"This should not be a records management root", (boolean)RecordsManagementServiceImplTest.this.filePlanService.isFilePlan(RecordsManagementServiceImplTest.this.rmFolder));
                return null;
            }
        });
    }

    public void testIsRecordCategory() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                TestCase.assertFalse((String)"This should not be a record category.", (boolean)RecordsManagementServiceImplTest.this.filePlanService.isRecordCategory(RecordsManagementServiceImplTest.this.filePlan));
                TestCase.assertTrue((String)"This is a record category.", (boolean)RecordsManagementServiceImplTest.this.filePlanService.isRecordCategory(RecordsManagementServiceImplTest.this.rmContainer));
                TestCase.assertFalse((String)"This should not be a record category.", (boolean)RecordsManagementServiceImplTest.this.filePlanService.isRecordCategory(RecordsManagementServiceImplTest.this.rmFolder));
                return null;
            }
        });
    }

    public void testIsRecordFolder() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                TestCase.assertFalse((String)"This should not be a record folder", (boolean)RecordsManagementServiceImplTest.this.recordFolderService.isRecordFolder(RecordsManagementServiceImplTest.this.filePlan));
                TestCase.assertFalse((String)"This should not be a record folder", (boolean)RecordsManagementServiceImplTest.this.recordFolderService.isRecordFolder(RecordsManagementServiceImplTest.this.rmContainer));
                TestCase.assertTrue((String)"This should be a record folder", (boolean)RecordsManagementServiceImplTest.this.recordFolderService.isRecordFolder(RecordsManagementServiceImplTest.this.rmFolder));
                return null;
            }
        });
    }

    public void testGetRecordsManagementRoot() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                TestCase.assertEquals((Object)RecordsManagementServiceImplTest.this.filePlan, (Object)RecordsManagementServiceImplTest.this.filePlanService.getFilePlan(RecordsManagementServiceImplTest.this.filePlan));
                TestCase.assertEquals((Object)RecordsManagementServiceImplTest.this.filePlan, (Object)RecordsManagementServiceImplTest.this.filePlanService.getFilePlan(RecordsManagementServiceImplTest.this.rmContainer));
                TestCase.assertEquals((Object)RecordsManagementServiceImplTest.this.filePlan, (Object)RecordsManagementServiceImplTest.this.filePlanService.getFilePlan(RecordsManagementServiceImplTest.this.rmFolder));
                return null;
            }
        });
    }

    public void testGetRecordsManagementRoots() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                ArrayList roots = new ArrayList(RecordsManagementServiceImplTest.this.filePlanService.getFilePlans());
                TestCase.assertNotNull(roots);
                TestCase.assertTrue((roots.size() != 0 ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)roots.contains(RecordsManagementServiceImplTest.this.filePlan));
                return null;
            }
        });
    }

    public void testCreateFilePlan() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                String id = this.setString("id", GUID.generate());
                return RecordsManagementServiceImplTest.this.filePlanService.createFilePlan(RecordsManagementServiceImplTest.this.folder, id);
            }

            public void test(NodeRef result) {
                TestCase.assertNotNull((String)"Unable to create records management root", (Object)result);
                RecordsManagementServiceImplTest.this.basicRMContainerCheck(result, this.getString("id"), RecordsManagementModel.TYPE_FILE_PLAN);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                String id = this.setString("id", GUID.generate());
                return RecordsManagementServiceImplTest.this.filePlanService.createFilePlan(RecordsManagementServiceImplTest.this.folder, id, RecordsManagementModel.TYPE_FILE_PLAN);
            }

            public void test(NodeRef result) {
                TestCase.assertNotNull((String)"Unable to create records management root", (Object)result);
                RecordsManagementServiceImplTest.this.basicRMContainerCheck(result, this.getString("id"), RecordsManagementModel.TYPE_FILE_PLAN);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                RecordsManagementServiceImplTest.this.filePlanService.createFilePlan(RecordsManagementServiceImplTest.this.rmContainer, GUID.generate());
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                RecordsManagementServiceImplTest.this.filePlanService.createFilePlan(RecordsManagementServiceImplTest.this.folder, GUID.generate(), ContentModel.TYPE_FOLDER);
            }
        });
    }

    public void testCreateRecordCategory() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                String id = this.setString("id", GUID.generate());
                return RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(RecordsManagementServiceImplTest.this.filePlan, id);
            }

            public void test(NodeRef result) {
                TestCase.assertNotNull((String)"Unable to create records management container", (Object)result);
                RecordsManagementServiceImplTest.this.basicRMContainerCheck(result, this.getString("id"), RecordsManagementModel.TYPE_RECORD_CATEGORY);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                String id = this.setString("id", GUID.generate());
                return RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(RecordsManagementServiceImplTest.this.rmContainer, id);
            }

            public void test(NodeRef result) {
                TestCase.assertNotNull((String)"Unable to create records management container", (Object)result);
                RecordsManagementServiceImplTest.this.basicRMContainerCheck(result, this.getString("id"), RecordsManagementModel.TYPE_RECORD_CATEGORY);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(RecordsManagementServiceImplTest.this.folder, GUID.generate());
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(RecordsManagementServiceImplTest.this.filePlan, GUID.generate(), ContentModel.TYPE_FOLDER);
            }
        });
    }

    public void testGetAllContained() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef series = RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(RecordsManagementServiceImplTest.this.rmContainer, "rmSeries");
                NodeRef seriesChildFolder = RecordsManagementServiceImplTest.this.recordFolderService.createRecordFolder(series, "seriesRecordFolder");
                NodeRef seriesChildContainer = RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(series, "childContainer");
                this.setNodeRef("series", series);
                this.setNodeRef("seriesChildFolder", seriesChildFolder);
                this.setNodeRef("seriesChildContainer", seriesChildContainer);
                return null;
            }

            public void test(Void result) throws Exception {
                List nodes = RecordsManagementServiceImplTest.this.filePlanService.getAllContained(RecordsManagementServiceImplTest.this.rmContainer);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)2, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                TestCase.assertTrue((boolean)nodes.contains(RecordsManagementServiceImplTest.this.rmFolder));
                nodes = RecordsManagementServiceImplTest.this.filePlanService.getAllContained(RecordsManagementServiceImplTest.this.rmContainer, false);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)2, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                TestCase.assertTrue((boolean)nodes.contains(RecordsManagementServiceImplTest.this.rmFolder));
                nodes = RecordsManagementServiceImplTest.this.filePlanService.getAllContained(RecordsManagementServiceImplTest.this.rmContainer, true);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)4, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                TestCase.assertTrue((boolean)nodes.contains(RecordsManagementServiceImplTest.this.rmFolder));
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("seriesChildFolder")));
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("seriesChildContainer")));
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                RecordsManagementServiceImplTest.this.filePlanService.getAllContained(RecordsManagementServiceImplTest.this.rmFolder);
            }
        });
    }

    public void testGetContainedRecordCategories() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef series = RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(RecordsManagementServiceImplTest.this.rmContainer, "rmSeries");
                NodeRef seriesChildFolder = RecordsManagementServiceImplTest.this.recordFolderService.createRecordFolder(series, "seriesRecordFolder");
                NodeRef seriesChildContainer = RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(series, "childContainer");
                this.setNodeRef("series", series);
                this.setNodeRef("seriesChildFolder", seriesChildFolder);
                this.setNodeRef("seriesChildContainer", seriesChildContainer);
                return null;
            }

            public void test(Void result) throws Exception {
                List nodes = RecordsManagementServiceImplTest.this.filePlanService.getContainedRecordCategories(RecordsManagementServiceImplTest.this.rmContainer);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)1, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                nodes = RecordsManagementServiceImplTest.this.filePlanService.getContainedRecordCategories(RecordsManagementServiceImplTest.this.rmContainer, false);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)1, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                nodes = RecordsManagementServiceImplTest.this.filePlanService.getContainedRecordCategories(RecordsManagementServiceImplTest.this.rmContainer, true);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)2, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("seriesChildContainer")));
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                RecordsManagementServiceImplTest.this.filePlanService.getContainedRecordCategories(RecordsManagementServiceImplTest.this.rmFolder);
            }
        });
    }

    public void testGetContainedRecordFolders() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef series = RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(RecordsManagementServiceImplTest.this.rmContainer, "rmSeries");
                NodeRef seriesChildFolder = RecordsManagementServiceImplTest.this.recordFolderService.createRecordFolder(series, "seriesRecordFolder");
                NodeRef seriesChildContainer = RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(series, "childContainer");
                this.setNodeRef("series", series);
                this.setNodeRef("seriesChildFolder", seriesChildFolder);
                this.setNodeRef("seriesChildContainer", seriesChildContainer);
                return null;
            }

            public void test(Void result) throws Exception {
                List nodes = RecordsManagementServiceImplTest.this.filePlanService.getContainedRecordFolders(RecordsManagementServiceImplTest.this.rmContainer);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)1, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(RecordsManagementServiceImplTest.this.rmFolder));
                nodes = RecordsManagementServiceImplTest.this.filePlanService.getContainedRecordFolders(RecordsManagementServiceImplTest.this.rmContainer, false);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)1, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(RecordsManagementServiceImplTest.this.rmFolder));
                nodes = RecordsManagementServiceImplTest.this.filePlanService.getContainedRecordFolders(RecordsManagementServiceImplTest.this.rmContainer, true);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)2, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(RecordsManagementServiceImplTest.this.rmFolder));
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("seriesChildFolder")));
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                RecordsManagementServiceImplTest.this.filePlanService.getContainedRecordFolders(RecordsManagementServiceImplTest.this.rmFolder);
            }
        });
    }

    public void testCreateRecordFolder() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                String id = this.setString("id", GUID.generate());
                return RecordsManagementServiceImplTest.this.recordFolderService.createRecordFolder(RecordsManagementServiceImplTest.this.rmContainer, id);
            }

            public void test(NodeRef result) {
                TestCase.assertNotNull((String)"Unable to create record folder", (Object)result);
                RecordsManagementServiceImplTest.this.basicRMContainerCheck(result, this.getString("id"), RecordsManagementModel.TYPE_RECORD_FOLDER);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                RecordsManagementServiceImplTest.this.recordFolderService.createRecordFolder(RecordsManagementServiceImplTest.this.rmContainer, GUID.generate(), ContentModel.TYPE_FOLDER);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                RecordsManagementServiceImplTest.this.recordFolderService.createRecordFolder(RecordsManagementServiceImplTest.this.filePlan, GUID.generate());
            }
        });
    }

    public void testCreateSimpleHierarchy() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef levelOne = this.setNodeRef("container1", RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(RecordsManagementServiceImplTest.this.filePlan, "container1"));
                TestCase.assertNotNull((String)"Unable to create container", (Object)levelOne);
                NodeRef levelTwo = this.setNodeRef("container2", RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(levelOne, "container2"));
                TestCase.assertNotNull((String)"Unable to create container", (Object)levelTwo);
                NodeRef levelThree = this.setNodeRef("container3", RecordsManagementServiceImplTest.this.filePlanService.createRecordCategory(levelTwo, "container3"));
                TestCase.assertNotNull((String)"Unable to create container", (Object)levelThree);
                NodeRef levelThreeRecordFolder = this.setNodeRef("recordFolder3", RecordsManagementServiceImplTest.this.recordFolderService.createRecordFolder(levelThree, "recordFolder3"));
                TestCase.assertNotNull((String)"Unable to create record folder", (Object)levelThreeRecordFolder);
                return null;
            }

            public void test(Void result) {
                RecordsManagementServiceImplTest.this.basicRMContainerCheck(this.getNodeRef("container1"), "container1", RecordsManagementModel.TYPE_RECORD_CATEGORY);
                RecordsManagementServiceImplTest.this.basicRMContainerCheck(this.getNodeRef("container2"), "container2", RecordsManagementModel.TYPE_RECORD_CATEGORY);
                RecordsManagementServiceImplTest.this.basicRMContainerCheck(this.getNodeRef("container3"), "container3", RecordsManagementModel.TYPE_RECORD_CATEGORY);
                RecordsManagementServiceImplTest.this.basicRMContainerCheck(this.getNodeRef("recordFolder3"), "recordFolder3", RecordsManagementModel.TYPE_RECORD_FOLDER);
            }
        });
    }

    private void basicRMContainerCheck(NodeRef nodeRef, String name, QName type) {
        RecordsManagementServiceImplTest.assertEquals((Object)name, (Object)this.nodeService.getProperty(nodeRef, PROP_NAME));
        RecordsManagementServiceImplTest.assertNotNull((String)"RM id has not been set", (Object)this.nodeService.getProperty(nodeRef, PROP_IDENTIFIER));
        RecordsManagementServiceImplTest.assertEquals((Object)type, (Object)this.nodeService.getType(nodeRef));
    }
}

