/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.email.CustomEmailMappingService;
import org.alfresco.module.org_alfresco_module_rm.email.CustomMapping;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class CustomEMailMappingServiceImplTest
extends BaseRMTestCase {
    private CustomEmailMappingService eMailMappingService;

    @Override
    protected void initServices() {
        super.initServices();
        this.eMailMappingService = (CustomEmailMappingService)this.applicationContext.getBean("customEmailMappingService");
    }

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.eMailMappingService.registerEMailMappingKey("EmailMappingKeyTest1");
        this.eMailMappingService.registerEMailMappingKey("EmailMappingKeyTest2");
    }

    public void testCRUD() throws Exception {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertTrue((boolean)CustomEMailMappingServiceImplTest.this.checkCustomMappingsSize(20));
                String firstKey = (String)CustomEMailMappingServiceImplTest.this.eMailMappingService.getEmailMappingKeys().get(0);
                CustomEMailMappingServiceImplTest.this.eMailMappingService.addCustomMapping(firstKey, "cm:monkeyFace");
                TestCase.assertTrue((boolean)CustomEMailMappingServiceImplTest.this.checkCustomMappingsSize(21));
                CustomMapping monkeyMapping = CustomEMailMappingServiceImplTest.this.getCustomMapping(firstKey, "cm:monkeyFace");
                TestCase.assertNotNull((Object)monkeyMapping);
                TestCase.assertEquals((String)firstKey, (String)monkeyMapping.getFrom());
                TestCase.assertEquals((String)"cm:monkeyFace", (String)monkeyMapping.getTo());
                CustomEMailMappingServiceImplTest.this.eMailMappingService.deleteCustomMapping(firstKey, "cm:monkeyFace");
                TestCase.assertTrue((boolean)CustomEMailMappingServiceImplTest.this.checkCustomMappingsSize(20));
                TestCase.assertNull((Object)CustomEMailMappingServiceImplTest.this.getCustomMapping(firstKey, "cm:monkeyFace"));
                TestCase.assertTrue((boolean)CustomEMailMappingServiceImplTest.this.checkEmailMappingKeysSize(8));
                try {
                    CustomEMailMappingServiceImplTest.this.eMailMappingService.addCustomMapping(" ", "cm:monkeyFace");
                    TestCase.fail((String)"Should not get here. Invalid data.");
                }
                catch (AlfrescoRuntimeException are) {
                    TestCase.assertNotNull((Object)((Object)are));
                    TestCase.assertTrue((boolean)are.getMessage().contains("Invalid values for"));
                }
                try {
                    CustomEMailMappingServiceImplTest.this.eMailMappingService.addCustomMapping("monkey", " ");
                    TestCase.fail((String)"Should not get here. Invalid data.");
                }
                catch (AlfrescoRuntimeException are) {
                    TestCase.assertNotNull((Object)((Object)are));
                    TestCase.assertTrue((boolean)are.getMessage().contains("Invalid values for"));
                }
                CustomEMailMappingServiceImplTest.this.eMailMappingService.addCustomMapping(firstKey, "cm:monkeyFace");
                return null;
            }
        }, "admin");
    }

    private CustomMapping getCustomMapping(String from, String to) {
        CustomMapping result = null;
        for (CustomMapping customMapping : this.eMailMappingService.getCustomMappings()) {
            if (!customMapping.getFrom().equalsIgnoreCase(from) || !customMapping.getTo().equalsIgnoreCase(to)) continue;
            result = customMapping;
            break;
        }
        return result;
    }

    private boolean checkCustomMappingsSize(int expected) {
        return expected == this.eMailMappingService.getCustomMappings().size();
    }

    private boolean checkEmailMappingKeysSize(int expected) {
        return expected == this.eMailMappingService.getEmailMappingKeys().size();
    }
}

