/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.vital;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class BroadcastVitalRecordDefinitionAction
extends RMActionExecuterAbstractBase {
    protected FilePlanService filePlanService;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    protected void executeImpl(Action action, final NodeRef actionedUponNodeRef) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                BroadcastVitalRecordDefinitionAction.this.propagateChangeToChildrenOf(actionedUponNodeRef);
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    private void propagateChangeToChildrenOf(NodeRef actionedUponNodeRef) {
        Map parentProps = this.getNodeService().getProperties(actionedUponNodeRef);
        boolean parentVri = false;
        Boolean parentVriValue = (Boolean)parentProps.get(PROP_VITAL_RECORD_INDICATOR);
        if (parentVriValue != null) {
            parentVri = parentVriValue;
        }
        Period parentReviewPeriod = (Period)parentProps.get(PROP_REVIEW_PERIOD);
        List assocs = this.getNodeService().getChildAssocs(actionedUponNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef nextAssoc : assocs) {
            NodeRef nextChild = nextAssoc.getChildRef();
            if (!this.filePlanService.isFilePlanComponent(nextChild) || this.getFreezeService().isFrozen(nextChild)) continue;
            if (this.getRecordService().isRecord(nextChild)) {
                if (parentVri) {
                    VitalRecordDefinition vrDefn = this.getVitalRecordService().getVitalRecordDefinition(nextChild);
                    HashMap<QName, Date> aspectProps = new HashMap<QName, Date>();
                    aspectProps.put(PROP_REVIEW_AS_OF, vrDefn.getNextReviewDate());
                    this.getNodeService().addAspect(nextChild, RecordsManagementModel.ASPECT_VITAL_RECORD, aspectProps);
                } else {
                    this.getNodeService().removeAspect(nextChild, RecordsManagementModel.ASPECT_VITAL_RECORD);
                }
            } else {
                Map childProps = this.getNodeService().getProperties(nextChild);
                childProps.put(PROP_REVIEW_PERIOD, parentReviewPeriod);
                childProps.put(PROP_VITAL_RECORD_INDICATOR, parentVri);
                this.getNodeService().setProperties(nextChild, childProps);
            }
            if (this.getRecordService().isRecord(nextChild)) continue;
            this.propagateChangeToChildrenOf(nextChild);
        }
    }
}

