/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.hold;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class HoldServiceImplUnitTest
extends BaseUnitTest {
    private static final String HOLD_NAME = "holdname";
    private static final String HOLD_REASON = "holdreason";
    private static final String HOLD_DELETION_REASON = "holddeletionreason";
    private static final String HOLD_DESCRIPTION = "holddescription";
    private static final String GENERIC_ERROR_MSG = "any error message text";
    protected NodeRef holdContainer;
    protected NodeRef hold;
    protected NodeRef hold2;
    protected NodeRef activeContent;
    @Mock
    private CapabilityService mockedCapabilityService;
    @Mock
    private ChildAssociationRef mockChildAssociationRef;
    @Spy
    @InjectMocks
    HoldServiceImpl holdService;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.holdContainer = this.generateNodeRef(TYPE_HOLD_CONTAINER);
        this.hold = this.generateNodeRef(TYPE_HOLD);
        this.hold2 = this.generateNodeRef(TYPE_HOLD);
        Mockito.when((Object)this.mockedCapabilityService.getCapabilityAccessState(this.hold, "AddToHold")).thenReturn((Object)AccessStatus.ALLOWED);
        Mockito.when((Object)this.mockedCapabilityService.getCapabilityAccessState(this.hold2, "AddToHold")).thenReturn((Object)AccessStatus.ALLOWED);
        Mockito.when((Object)this.mockedCapabilityService.getCapabilityAccessState(this.hold, "RemoveFromHold")).thenReturn((Object)AccessStatus.ALLOWED);
        Mockito.when((Object)this.mockedCapabilityService.getCapabilityAccessState(this.hold2, "RemoveFromHold")).thenReturn((Object)AccessStatus.ALLOWED);
        this.activeContent = this.generateNodeRef();
        QName contentSubtype = QName.createQName((String)"contentSubtype", (String)"contentSubtype");
        Mockito.when((Object)this.mockedNodeService.getType(this.activeContent)).thenReturn((Object)contentSubtype);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(contentSubtype, ContentModel.TYPE_CONTENT)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(this.activeContent)).thenReturn((Object)this.mockChildAssociationRef);
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(this.recordFolder)).thenReturn((Object)this.mockChildAssociationRef);
        ((FilePlanService)Mockito.doReturn((Object)this.holdContainer).when((Object)this.mockedFilePlanService)).getHoldContainer(this.filePlan);
    }

    @Test
    public void isHold() {
        Assert.assertTrue((boolean)this.holdService.isHold(this.hold));
        Assert.assertFalse((boolean)this.holdService.isHold(this.recordFolder));
    }

    @Test
    public void heldByMultipleResults() {
        ArrayList<ChildAssociationRef> holds = new ArrayList<ChildAssociationRef>(4);
        holds.add(new ChildAssociationRef(ASSOC_FROZEN_CONTENT, this.hold, ASSOC_FROZEN_CONTENT, this.recordFolder, true, 1));
        holds.add(new ChildAssociationRef(ASSOC_FROZEN_CONTENT, this.hold2, ASSOC_FROZEN_CONTENT, this.recordFolder, true, 2));
        holds.add(new ChildAssociationRef(ASSOC_FROZEN_CONTENT, this.hold, ASSOC_FROZEN_CONTENT, this.activeContent, true, 1));
        holds.add(new ChildAssociationRef(ASSOC_FROZEN_CONTENT, this.hold2, ASSOC_FROZEN_CONTENT, this.activeContent, true, 2));
        ((NodeService)Mockito.doReturn(holds).when((Object)this.mockedNodeService)).getParentAssocs(this.recordFolder, (QNamePattern)ASSOC_FROZEN_CONTENT, (QNamePattern)ASSOC_FROZEN_CONTENT);
        ((NodeService)Mockito.doReturn(holds).when((Object)this.mockedNodeService)).getParentAssocs(this.activeContent, (QNamePattern)ASSOC_FROZEN_CONTENT, (QNamePattern)ASSOC_FROZEN_CONTENT);
        ((FilePlanService)Mockito.doReturn(Collections.singleton(this.filePlan)).when((Object)this.mockedFilePlanService)).getFilePlans();
        List heldByHolds = this.holdService.heldBy(this.recordFolder, true);
        Assert.assertNotNull((Object)heldByHolds);
        Assert.assertEquals((long)2L, (long)heldByHolds.size());
        Assert.assertTrue((boolean)this.holdService.heldBy(this.recordFolder, false).isEmpty());
        heldByHolds = this.holdService.heldBy(this.record, true);
        Assert.assertNotNull((Object)heldByHolds);
        Assert.assertEquals((long)2L, (long)heldByHolds.size());
        Assert.assertTrue((boolean)this.holdService.heldBy(this.record, false).isEmpty());
        heldByHolds = this.holdService.heldBy(this.activeContent, true);
        Assert.assertNotNull((Object)heldByHolds);
        Assert.assertEquals((long)2L, (long)heldByHolds.size());
        Assert.assertTrue((boolean)this.holdService.heldBy(this.activeContent, false).isEmpty());
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testGetHold() {
        Mockito.when((Object)this.mockedNodeService.getChildByName((NodeRef)ArgumentMatchers.eq((Object)this.holdContainer), (QName)ArgumentMatchers.eq((Object)ContentModel.ASSOC_CONTAINS), ArgumentMatchers.anyString())).thenReturn(null).thenReturn((Object)this.hold).thenReturn((Object)this.recordFolder);
        NodeRef noHold = this.holdService.getHold(this.filePlan, "notAHold");
        Assert.assertNull((Object)noHold);
        NodeRef someHold = this.holdService.getHold(this.filePlan, "someHold");
        Assert.assertNotNull((Object)someHold);
        Assert.assertEquals((Object)TYPE_HOLD, (Object)this.mockedNodeService.getType(someHold));
        this.holdService.getHold(this.filePlan, "notHold");
    }

    @Test(expected=RuntimeException.class)
    public void testGetHeldNotAHold() {
        this.holdService.getHeld(this.recordFolder);
    }

    @Test
    public void testGetHeldNoResults() {
        Assert.assertTrue((boolean)this.holdService.getHeld(this.hold).isEmpty());
    }

    @Test
    public void testGetHeldWithResults() {
        ArrayList<ChildAssociationRef> holds = new ArrayList<ChildAssociationRef>(2);
        holds.add(new ChildAssociationRef(ASSOC_FROZEN_CONTENT, this.hold, ASSOC_FROZEN_CONTENT, this.recordFolder, true, 1));
        holds.add(new ChildAssociationRef(ASSOC_FROZEN_CONTENT, this.hold, ASSOC_FROZEN_CONTENT, this.activeContent, true, 1));
        ((NodeService)Mockito.doReturn(holds).when((Object)this.mockedNodeService)).getChildAssocs(this.hold, (QNamePattern)ASSOC_FROZEN_CONTENT, RegexQNamePattern.MATCH_ALL);
        List list = this.holdService.getHeld(this.hold);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)this.recordFolder, list.get(0));
        Assert.assertEquals((Object)this.activeContent, list.get(1));
    }

    @Test
    public void createHold() {
        Mockito.when((Object)this.mockedNodeService.createNode((NodeRef)ArgumentMatchers.eq((Object)this.holdContainer), (QName)ArgumentMatchers.eq((Object)ContentModel.ASSOC_CONTAINS), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)TYPE_HOLD), (Map)ArgumentMatchers.any(Map.class))).thenReturn((Object)new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.holdContainer, AlfMock.generateQName(), this.hold));
        this.mockPoliciesForCreateHold();
        NodeRef newHold = this.holdService.createHold(this.filePlan, HOLD_NAME, HOLD_REASON, HOLD_DESCRIPTION);
        Assert.assertNotNull((Object)newHold);
        Assert.assertEquals((Object)TYPE_HOLD, (Object)this.mockedNodeService.getType(newHold));
        Assert.assertEquals((Object)this.hold, (Object)newHold);
        ArgumentCaptor propertyMapCaptor = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor assocNameCaptor = ArgumentCaptor.forClass(QName.class);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).createNode((NodeRef)ArgumentMatchers.eq((Object)this.holdContainer), (QName)ArgumentMatchers.eq((Object)ContentModel.ASSOC_CONTAINS), (QName)assocNameCaptor.capture(), (QName)ArgumentMatchers.eq((Object)TYPE_HOLD), (Map)propertyMapCaptor.capture());
        Map propertyMap = (Map)propertyMapCaptor.getValue();
        Assert.assertNotNull((Object)propertyMap);
        Assert.assertEquals((long)3L, (long)propertyMap.size());
        Assert.assertTrue((boolean)propertyMap.containsKey(ContentModel.PROP_NAME));
        Assert.assertEquals((Object)HOLD_NAME, propertyMap.get(ContentModel.PROP_NAME));
        Assert.assertTrue((boolean)propertyMap.containsKey(ContentModel.PROP_DESCRIPTION));
        Assert.assertEquals((Object)HOLD_DESCRIPTION, propertyMap.get(ContentModel.PROP_DESCRIPTION));
        Assert.assertTrue((boolean)propertyMap.containsKey(PROP_HOLD_REASON));
        Assert.assertEquals((Object)HOLD_REASON, propertyMap.get(PROP_HOLD_REASON));
        Assert.assertNotNull((Object)assocNameCaptor.getValue());
        Assert.assertEquals((Object)"http://www.alfresco.org/model/content/1.0", (Object)((QName)assocNameCaptor.getValue()).getNamespaceURI());
        Assert.assertEquals((Object)HOLD_NAME, (Object)((QName)assocNameCaptor.getValue()).getLocalName());
    }

    @Test
    public void testGetHoldReason() {
        Mockito.when((Object)this.mockedNodeService.exists(this.hold)).thenReturn((Object)false).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.getProperty((NodeRef)ArgumentMatchers.eq((Object)this.hold), (QName)ArgumentMatchers.eq((Object)PROP_HOLD_REASON))).thenReturn(null).thenReturn((Object)HOLD_REASON);
        Assert.assertNull((Object)this.holdService.getHoldReason(this.hold));
        Assert.assertNull((Object)this.holdService.getHoldReason(this.recordFolder));
        Assert.assertNull((Object)this.holdService.getHoldReason(this.hold));
        Assert.assertEquals((Object)HOLD_REASON, (Object)this.holdService.getHoldReason(this.hold));
    }

    @Test
    public void setHoldReason() {
        Mockito.when((Object)this.mockedNodeService.exists(this.hold)).thenReturn((Object)false).thenReturn((Object)true).thenReturn((Object)true);
        this.holdService.setHoldReason(this.hold, HOLD_REASON);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).setProperty(this.hold, PROP_HOLD_REASON, (Serializable)((Object)HOLD_REASON));
        this.holdService.setHoldReason(this.recordFolder, HOLD_REASON);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).setProperty(this.hold, PROP_HOLD_REASON, (Serializable)((Object)HOLD_REASON));
        this.holdService.setHoldReason(this.hold, HOLD_REASON);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).setProperty(this.hold, PROP_HOLD_REASON, (Serializable)((Object)HOLD_REASON));
    }

    @Test
    public void setHoldDeletionReasonForNodeDoesNotExist() {
        Mockito.when((Object)this.mockedNodeService.exists(this.hold)).thenReturn((Object)false);
        this.holdService.setHoldDeletionReason(this.hold, HOLD_DELETION_REASON);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).setProperty(this.hold, PROP_HOLD_DELETION_REASON, (Serializable)((Object)HOLD_DELETION_REASON));
    }

    @Test
    public void setHoldDeletionReasonForNodeIsNotAHold() {
        Mockito.when((Object)this.mockedNodeService.exists(this.hold)).thenReturn((Object)true);
        this.holdService.setHoldDeletionReason(this.recordFolder, HOLD_DELETION_REASON);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).setProperty(this.hold, PROP_HOLD_DELETION_REASON, (Serializable)((Object)HOLD_DELETION_REASON));
    }

    @Test
    public void setHoldDeletionReason() {
        Mockito.when((Object)this.mockedNodeService.exists(this.hold)).thenReturn((Object)true);
        this.holdService.setHoldDeletionReason(this.hold, HOLD_DELETION_REASON);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).setProperty(this.hold, PROP_HOLD_DELETION_REASON, (Serializable)((Object)HOLD_DELETION_REASON));
    }

    @Test
    public void updateHoldThatDoesNotExist() {
        Mockito.when((Object)this.mockedNodeService.exists(this.hold)).thenReturn((Object)false);
        this.holdService.updateHold(this.hold, HOLD_NAME, HOLD_REASON, HOLD_DESCRIPTION);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).setProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.any(QName.class), (Serializable)ArgumentMatchers.any(String.class));
    }

    @Test
    public void updateHoldThatIsNotAHold() {
        Mockito.when((Object)this.mockedNodeService.exists(this.hold)).thenReturn((Object)true);
        this.holdService.updateHold(this.recordFolder, HOLD_NAME, HOLD_REASON, HOLD_DESCRIPTION);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).setProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.any(QName.class), (Serializable)ArgumentMatchers.any(String.class));
    }

    @Test
    public void updateHold() {
        Mockito.when((Object)this.mockedNodeService.exists(this.hold)).thenReturn((Object)true);
        this.holdService.updateHold(this.hold, HOLD_NAME, HOLD_REASON, HOLD_DESCRIPTION);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).setProperty(this.hold, ContentModel.PROP_NAME, (Serializable)((Object)HOLD_NAME));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).setProperty(this.hold, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)HOLD_DESCRIPTION));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).setProperty(this.hold, PROP_HOLD_REASON, (Serializable)((Object)HOLD_REASON));
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void deleteHoldNotAHold() {
        this.holdService.deleteHold(this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).deleteNode(this.hold);
    }

    @Test
    public void deleteHold() {
        this.mockPoliciesForDeleteHold();
        this.holdService.deleteHold(this.hold);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).deleteNode(this.hold);
    }

    @Test(expected=AccessDeniedException.class)
    public void deleteHoldNoPermissionsOnContent() {
        this.mockPoliciesForDeleteHold();
        ChildAssociationRef childAssociationRef = this.generateChildAssociationRef(this.hold, this.record);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(this.hold, (QNamePattern)ASSOC_FROZEN_CONTENT, RegexQNamePattern.MATCH_ALL)).thenReturn(Collections.singletonList(childAssociationRef));
        Mockito.when((Object)this.mockedPermissionService.hasPermission(this.record, "Filing")).thenReturn((Object)AccessStatus.DENIED);
        Mockito.when((Object)this.mockedNodeService.getProperty(this.record, ContentModel.PROP_NAME)).thenThrow(new Throwable[]{new AccessDeniedException(GENERIC_ERROR_MSG)});
        this.holdService.beforeDeleteNode(this.hold);
    }

    @Test(expected=IntegrityException.class)
    public void addToHoldNotAHold() {
        this.holdService.addToHold(this.recordFolder, this.recordFolder);
    }

    @Test(expected=IntegrityException.class)
    public void addToHoldNotARecordFolderOrRecordOrActiveContent() {
        NodeRef anotherThing = this.generateNodeRef(TYPE_RECORD_CATEGORY);
        this.holdService.addToHold(this.hold, anotherThing);
    }

    @Test
    public void addToHoldNotInHold() {
        this.mockPoliciesForAddToHold();
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(this.record)).thenReturn((Object)this.mockChildAssociationRef);
        this.holdService.addToHold(this.hold, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addChild(this.hold, this.recordFolder, ASSOC_FROZEN_CONTENT, ASSOC_FROZEN_CONTENT);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.recordFolder), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.record), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
        this.holdService.addToHold(this.hold, this.record);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addChild(this.hold, this.record, ASSOC_FROZEN_CONTENT, ASSOC_FROZEN_CONTENT);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.recordFolder), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)2))).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.record), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
        this.holdService.addToHold(this.hold, this.activeContent);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addChild(this.hold, this.activeContent, ASSOC_FROZEN_CONTENT, ASSOC_FROZEN_CONTENT);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.activeContent), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void addToHoldAlreadyInHold() {
        ((HoldServiceImpl)Mockito.doReturn(Arrays.asList(this.recordFolder, this.activeContent)).when((Object)this.holdService)).getHeld(this.hold);
        this.holdService.addToHold(this.hold, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).addChild(this.hold, this.recordFolder, ASSOC_FROZEN_CONTENT, ASSOC_FROZEN_CONTENT);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.recordFolder), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.record), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
        this.holdService.addToHold(this.hold, this.activeContent);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).addChild(this.hold, this.activeContent, ASSOC_FROZEN_CONTENT, ASSOC_FROZEN_CONTENT);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.activeContent), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test
    public void addToHoldAlreadyFrozen() {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.recordFolder, ASPECT_FROZEN);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.record, ASPECT_FROZEN);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.activeContent, ASPECT_FROZEN);
        this.mockPoliciesForAddToHold();
        this.holdService.addToHold(this.hold, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addChild(this.hold, this.recordFolder, ASSOC_FROZEN_CONTENT, ASSOC_FROZEN_CONTENT);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.recordFolder), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.record), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
        this.holdService.addToHold(this.hold, this.activeContent);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addChild(this.hold, this.activeContent, ASSOC_FROZEN_CONTENT, ASSOC_FROZEN_CONTENT);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.activeContent), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test(expected=AccessDeniedException.class)
    public void addActiveContentToHoldsNoPermissionsOnHold() {
        Mockito.when((Object)this.mockedCapabilityService.getCapabilityAccessState(this.hold, "AddToHold")).thenReturn((Object)AccessStatus.DENIED);
        ArrayList<NodeRef> holds = new ArrayList<NodeRef>(2);
        holds.add(this.hold);
        holds.add(this.hold2);
        this.holdService.addToHolds(holds, this.activeContent);
    }

    @Test(expected=AccessDeniedException.class)
    public void addActiveContentToHoldNoPermissionsOnContent() {
        Mockito.when((Object)this.mockedPermissionService.hasPermission(this.activeContent, "Write")).thenReturn((Object)AccessStatus.DENIED);
        this.holdService.addToHold(this.hold, this.activeContent);
    }

    @Test(expected=IntegrityException.class)
    public void addArchivedContentToHold() {
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.activeContent, RecordsManagementModel.ASPECT_ARCHIVED)).thenReturn((Object)true);
        this.holdService.addToHold(this.hold, this.activeContent);
    }

    @Test(expected=IntegrityException.class)
    public void addLockedContentToHold() {
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.activeContent, ContentModel.ASPECT_LOCKABLE)).thenReturn((Object)true);
        this.holdService.addToHold(this.hold, this.activeContent);
    }

    @Test
    public void addToHolds() {
        ((NodeService)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                NodeRef nodeRef = (NodeRef)invocation.getArguments()[0];
                ((NodeService)Mockito.doReturn((Object)true).when((Object)HoldServiceImplUnitTest.this.mockedNodeService)).hasAspect(nodeRef, RecordsManagementModel.ASPECT_FROZEN);
                return null;
            }
        }).when((Object)this.mockedNodeService)).addAspect((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
        this.mockPoliciesForAddToHold();
        ArrayList<NodeRef> holds = new ArrayList<NodeRef>(2);
        holds.add(this.hold);
        holds.add(this.hold2);
        this.holdService.addToHolds(holds, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addChild(this.hold, this.recordFolder, ASSOC_FROZEN_CONTENT, ASSOC_FROZEN_CONTENT);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addChild(this.hold2, this.recordFolder, ASSOC_FROZEN_CONTENT, ASSOC_FROZEN_CONTENT);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.recordFolder), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.record), (QName)ArgumentMatchers.eq((Object)ASPECT_FROZEN), (Map)ArgumentMatchers.any(Map.class));
    }

    @Test(expected=IntegrityException.class)
    public void removeFromHoldNotAHold() {
        this.holdService.removeFromHold(this.recordFolder, this.recordFolder);
    }

    @Test
    public void removeFromHoldNotInHold() {
        this.mockPoliciesForRemoveFromHold();
        this.holdService.removeFromHold(this.hold, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).removeChild(this.hold, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).removeAspect(this.recordFolder, ASPECT_FROZEN);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).removeAspect(this.record, ASPECT_FROZEN);
    }

    @Test
    public void removeFromHold() {
        ((HoldServiceImpl)Mockito.doReturn(Collections.singletonList(this.recordFolder)).when((Object)this.holdService)).getHeld(this.hold);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.recordFolder, ASPECT_FROZEN);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.record, ASPECT_FROZEN);
        this.mockPoliciesForRemoveFromHold();
        this.holdService.removeFromHold(this.hold, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeChild(this.hold, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeAspect(this.recordFolder, ASPECT_FROZEN);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeAspect(this.record, ASPECT_FROZEN);
    }

    @Test
    public void removeFromHolds() {
        ((HoldServiceImpl)Mockito.doReturn(Collections.singletonList(this.recordFolder)).when((Object)this.holdService)).getHeld(this.hold);
        ((HoldServiceImpl)Mockito.doReturn(Collections.singletonList(this.recordFolder)).when((Object)this.holdService)).getHeld(this.hold2);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.recordFolder, ASPECT_FROZEN);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.record, ASPECT_FROZEN);
        this.mockPoliciesForRemoveFromHold();
        ArrayList<NodeRef> holds = new ArrayList<NodeRef>(2);
        holds.add(this.hold);
        holds.add(this.hold2);
        this.holdService.removeFromHolds(holds, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeChild(this.hold, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeChild(this.hold2, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeAspect(this.recordFolder, ASPECT_FROZEN);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeAspect(this.record, ASPECT_FROZEN);
    }

    @Test
    public void removeFromAllHolds() {
        ArrayList<NodeRef> holds = new ArrayList<NodeRef>(2);
        holds.add(this.hold);
        holds.add(this.hold2);
        ((NodeService)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                ((HoldServiceImpl)Mockito.doReturn(Collections.singletonList(HoldServiceImplUnitTest.this.hold2)).when((Object)HoldServiceImplUnitTest.this.holdService)).heldBy(HoldServiceImplUnitTest.this.recordFolder, true);
                return null;
            }
        }).when((Object)this.mockedNodeService)).removeChild(this.hold, this.recordFolder);
        this.mockPoliciesForRemoveFromHold();
        ((NodeService)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                ((HoldServiceImpl)Mockito.doReturn(new ArrayList()).when((Object)HoldServiceImplUnitTest.this.holdService)).heldBy(HoldServiceImplUnitTest.this.recordFolder, true);
                return null;
            }
        }).when((Object)this.mockedNodeService)).removeChild(this.hold2, this.recordFolder);
        ((HoldServiceImpl)Mockito.doReturn(holds).when((Object)this.holdService)).heldBy(this.recordFolder, true);
        ((HoldServiceImpl)Mockito.doReturn(Collections.singletonList(this.recordFolder)).when((Object)this.holdService)).getHeld(this.hold);
        ((HoldServiceImpl)Mockito.doReturn(Collections.singletonList(this.recordFolder)).when((Object)this.holdService)).getHeld(this.hold2);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.recordFolder, ASPECT_FROZEN);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.record, ASPECT_FROZEN);
        this.holdService.removeFromAllHolds(this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeChild(this.hold, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeChild(this.hold2, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeAspect(this.recordFolder, ASPECT_FROZEN);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeAspect(this.record, ASPECT_FROZEN);
    }

    @Test(expected=AccessDeniedException.class)
    public void removeActiveContentFromHoldsNoPermissionsOnHold() {
        ((HoldServiceImpl)Mockito.doReturn(Collections.singletonList(this.activeContent)).when((Object)this.holdService)).getHeld(this.hold);
        ((HoldServiceImpl)Mockito.doReturn(Collections.singletonList(this.activeContent)).when((Object)this.holdService)).getHeld(this.hold2);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.activeContent, ASPECT_FROZEN);
        Mockito.when((Object)this.mockedCapabilityService.getCapabilityAccessState(this.hold, "RemoveFromHold")).thenReturn((Object)AccessStatus.DENIED);
        ArrayList<NodeRef> holds = new ArrayList<NodeRef>(2);
        holds.add(this.hold);
        holds.add(this.hold2);
        this.holdService.removeFromHolds(holds, this.activeContent);
    }

    @Test(expected=AccessDeniedException.class)
    public void testBeforeDeleteNodeThrowsExceptionForActiveContentWithoutReadPermission() {
        NodeRef heldContent = this.generateNodeRef(TYPE_CONTENT);
        this.mockPoliciesForExistingHoldWithHeldItems(this.hold, heldContent);
        Mockito.when((Object)this.mockedRecordService.isRecord(heldContent)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedRecordFolderService.isRecordFolder(heldContent)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedPermissionService.hasPermission(heldContent, "Read")).thenReturn((Object)AccessStatus.DENIED);
        Mockito.when((Object)this.mockedNodeService.getProperty(heldContent, ContentModel.PROP_NAME)).thenReturn((Object)"foo");
        this.holdService.beforeDeleteNode(this.hold);
    }

    @Test(expected=AccessDeniedException.class)
    public void testBeforeDeleteNodeThrowsExceptionForARecordWithoutReadPermission() {
        NodeRef heldContent = this.generateNodeRef();
        this.mockPoliciesForExistingHoldWithHeldItems(this.hold, heldContent);
        Mockito.when((Object)this.mockedRecordService.isRecord(heldContent)).thenThrow(new Throwable[]{new AccessDeniedException("")});
        this.holdService.beforeDeleteNode(this.hold);
    }

    @Test(expected=AccessDeniedException.class)
    public void testBeforeDeleteNodeThrowsExceptionForARecordWithoutFilePermission() {
        NodeRef heldContent = this.generateNodeRef();
        this.mockPoliciesForExistingHoldWithHeldItems(this.hold, heldContent);
        Mockito.when((Object)this.mockedRecordService.isRecord(heldContent)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedPermissionService.hasPermission(heldContent, "Filing")).thenReturn((Object)AccessStatus.DENIED);
        Mockito.when((Object)this.mockedNodeService.getProperty(heldContent, ContentModel.PROP_NAME)).thenReturn((Object)"foo");
        this.holdService.beforeDeleteNode(this.hold);
    }

    @Test
    public void testDeleteHoldChecksReadPermissionForActiveContent() {
        NodeRef heldContent = this.generateNodeRef(TYPE_CONTENT);
        List<ChildAssociationRef> holds = this.createListOfHoldAssociations(heldContent);
        this.mockPoliciesForDeleteHold();
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(this.hold, (QNamePattern)ASSOC_FROZEN_CONTENT, RegexQNamePattern.MATCH_ALL)).thenReturn(holds);
        Mockito.when((Object)this.mockedRecordService.isRecord(heldContent)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedRecordFolderService.isRecordFolder(heldContent)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedPermissionService.hasPermission(heldContent, "Read")).thenReturn((Object)AccessStatus.ALLOWED);
        Mockito.when((Object)this.mockedNodeService.getProperty(heldContent, ContentModel.PROP_NAME)).thenReturn((Object)"foo");
        this.holdService.deleteHold(this.hold);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).deleteNode(this.hold);
    }

    private List<ChildAssociationRef> createListOfHoldAssociations(NodeRef heldContent) {
        ArrayList<ChildAssociationRef> holds = new ArrayList<ChildAssociationRef>(2);
        holds.add(new ChildAssociationRef(ASSOC_FROZEN_CONTENT, this.hold, ASSOC_FROZEN_CONTENT, heldContent, true, 1));
        return holds;
    }

    private void mockPoliciesForExistingHoldWithHeldItems(NodeRef hold, NodeRef heldContent) {
        Mockito.when((Object)this.mockedNodeService.exists(hold)).thenReturn((Object)true);
        Mockito.when((Object)this.holdService.isHold(hold)).thenReturn((Object)true);
        List<ChildAssociationRef> holds = this.createListOfHoldAssociations(heldContent);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(hold, (QNamePattern)ASSOC_FROZEN_CONTENT, RegexQNamePattern.MATCH_ALL)).thenReturn(holds);
    }

    private void mockPoliciesForCreateHold() {
        ((HoldServiceImpl)Mockito.doNothing().when((Object)this.holdService)).invokeBeforeCreateHold((NodeRef)ArgumentMatchers.any(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((HoldServiceImpl)Mockito.doNothing().when((Object)this.holdService)).invokeOnCreateHold((NodeRef)ArgumentMatchers.any());
    }

    private void mockPoliciesForDeleteHold() {
        ((HoldServiceImpl)Mockito.doNothing().when((Object)this.holdService)).invokeBeforeDeleteHold((NodeRef)ArgumentMatchers.any());
        ((HoldServiceImpl)Mockito.doNothing().when((Object)this.holdService)).invokeOnDeleteHold((String)ArgumentMatchers.any(), (Set)ArgumentMatchers.any());
    }

    private void mockPoliciesForAddToHold() {
        ((HoldServiceImpl)Mockito.doNothing().when((Object)this.holdService)).invokeBeforeAddToHold((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any());
        ((HoldServiceImpl)Mockito.doNothing().when((Object)this.holdService)).invokeOnAddToHold((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any());
    }

    private void mockPoliciesForRemoveFromHold() {
        ((HoldServiceImpl)Mockito.doNothing().when((Object)this.holdService)).invokeBeforeRemoveFromHold((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any());
        ((HoldServiceImpl)Mockito.doNothing().when((Object)this.holdService)).invokeOnRemoveFromHold((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any());
    }
}

