/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.query.NodeRefEntity;
import org.alfresco.module.org_alfresco_module_rm.query.PropertyValuesOfChildrenQueryParams;
import org.alfresco.module.org_alfresco_module_rm.query.RecordsManagementQueryDAO;
import org.alfresco.repo.domain.contentdata.ContentUrlEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.propval.PropertyStringValueEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mybatis.spring.SqlSessionTemplate;

public class RecordsManagementQueryDAOImpl
implements RecordsManagementQueryDAO,
RecordsManagementModel {
    private static final Log logger = LogFactory.getLog(RecordsManagementQueryDAOImpl.class);
    private static final String COUNT_IDENTIFIER = "alfresco.query.rm.select_CountRMIndentifier";
    private static final String GET_CHILDREN_PROPERTY_VALUES = "select_GetStringPropertyValuesOfChildren";
    private static final String SELECT_NODE_IDS_WHICH_REFERENCE_CONTENT_URL = "select_NodeIdsWhichReferenceContentUrl";
    private static final String SCHEDULED_FOLDERS = "alfresco.query.rm.select_RecordFoldersWithSchedules";
    private static final String SCHEDULED_FOLDERS_COUNT = "alfresco.query.rm.select_RecordFoldersWithSchedulesCount";
    private static final String GET_PROP_STRING_VALUE = "alfresco.query.rm.select_PropertyStringValue";
    private static final String UPDATE_PROP_STRING_VALUE = "alfresco.query.rm.update_PropertyStringValue";
    protected SqlSessionTemplate template;
    protected QNameDAO qnameDAO;
    protected NodeDAO nodeDAO;
    protected TenantService tenantService;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    public final void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Override
    public int getCountRmaIdentifier(String identifierValue) {
        int result = 0;
        Pair pair = this.qnameDAO.getQName(PROP_IDENTIFIER);
        if (pair != null) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("qnameId", pair.getFirst());
            params.put("idValue", identifierValue);
            Integer count = (Integer)this.template.selectOne(COUNT_IDENTIFIER, params);
            if (count != null) {
                result = count;
            }
        }
        return result;
    }

    @Override
    public Set<String> getChildrenStringPropertyValues(NodeRef parent, QName property) {
        PropertyValuesOfChildrenQueryParams queryParams = new PropertyValuesOfChildrenQueryParams();
        Pair nodePair = this.nodeDAO.getNodePair(this.tenantService.getName(parent));
        if (nodePair == null) {
            throw new InvalidNodeRefException("The parent node does not exist.", parent);
        }
        Long parentNodeId = (Long)nodePair.getFirst();
        queryParams.setParentId(parentNodeId);
        Pair pair = this.qnameDAO.getQName(property);
        if (pair == null) {
            return Collections.emptySet();
        }
        queryParams.setPropertyQnameId((Long)pair.getFirst());
        return new HashSet<String>(this.template.selectList(GET_CHILDREN_PROPERTY_VALUES, (Object)queryParams));
    }

    @Override
    public Set<NodeRef> getNodeRefsWhichReferenceContentUrl(String contentUrl) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting nodes that reference content URL = " + contentUrl));
        }
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setContentUrl(contentUrl.toLowerCase());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Executing query select_NodeIdsWhichReferenceContentUrl");
        }
        List nodeIds = this.template.selectList(SELECT_NODE_IDS_WHICH_REFERENCE_CONTENT_URL, (Object)contentUrlEntity);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Query select_NodeIdsWhichReferenceContentUrl returned " + nodeIds.size() + " results"));
        }
        HashSet<NodeRef> nodesReferencingContentUrl = new HashSet<NodeRef>(nodeIds.size());
        for (Long nodeId : nodeIds) {
            StringBuilder logMessage = null;
            if (nodeId != null && this.nodeDAO.exists(nodeId)) {
                NodeRef nodeRefToAdd;
                NodeRef version2FrozenNodeRef;
                if (logger.isDebugEnabled()) {
                    logMessage = new StringBuilder("Adding noderef ");
                }
                if ((version2FrozenNodeRef = (NodeRef)this.nodeDAO.getNodeProperty(nodeId, Version2Model.PROP_QNAME_FROZEN_NODE_REF)) != null && this.nodeDAO.exists(version2FrozenNodeRef)) {
                    nodeRefToAdd = version2FrozenNodeRef;
                    if (logger.isDebugEnabled()) {
                        logMessage.append(nodeRefToAdd).append(" (from version)");
                    }
                } else {
                    nodeRefToAdd = this.nodeDAO.getNodeIdStatus(nodeId).getNodeRef();
                    if (logger.isDebugEnabled()) {
                        logMessage.append(nodeRefToAdd);
                    }
                }
                nodesReferencingContentUrl.add(nodeRefToAdd);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)logMessage.toString());
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Not adding " + nodeId + " (exist==false)"));
        }
        return nodesReferencingContentUrl;
    }

    @Override
    public List<NodeRef> getRecordFoldersWithSchedules(Long start, Long end) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("processed", this.qnameDAO.getQName(ASPECT_DISPOSITION_PROCESSED).getFirst());
        params.put("folderQnameId", this.qnameDAO.getQName(TYPE_RECORD_FOLDER).getFirst());
        params.put("start", start);
        params.put("end", end);
        List entities = this.template.selectList(SCHEDULED_FOLDERS, params);
        ArrayList<NodeRef> results = new ArrayList<NodeRef>();
        for (NodeRefEntity nodeRefEntity : entities) {
            results.add(new NodeRef(nodeRefEntity.getProtocol(), nodeRefEntity.getIdentifier(), nodeRefEntity.getUuid()));
        }
        return results;
    }

    @Override
    public PropertyStringValueEntity getPropertyStringValueEntity(String stringValue) {
        PropertyStringValueEntity propertyStringValueEntity = new PropertyStringValueEntity();
        propertyStringValueEntity.setValue(stringValue);
        return (PropertyStringValueEntity)this.template.selectOne(GET_PROP_STRING_VALUE, (Object)propertyStringValueEntity);
    }

    @Override
    public int updatePropertyStringValueEntity(PropertyStringValueEntity propertyStringValueEntity) {
        return this.template.update(UPDATE_PROP_STRING_VALUE, (Object)propertyStringValueEntity);
    }
}

