/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class ExtendedSecurityServiceImplTest
extends BaseRMTestCase {
    private NodeRef record;
    private NodeRef recordToo;
    private NodeRef moveRecordCategory;
    private NodeRef moveRecordFolder;

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setupTestDataImpl() {
        super.setupTestDataImpl();
        this.record = this.utils.createRecord(this.rmFolder, "record.txt");
        this.recordToo = this.utils.createRecord(this.rmFolder, "recordToo.txt");
        this.moveRecordCategory = this.filePlanService.createRecordCategory(this.filePlan, "moveRecordCategory");
        this.moveRecordFolder = this.recordFolderService.createRecordFolder(this.moveRecordCategory, "moveRecordFolder");
    }

    private String createTestUser() {
        return (String)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<String>(){

            public String run() {
                String userName = GUID.generate();
                ExtendedSecurityServiceImplTest.this.createPerson(userName);
                return userName;
            }
        }, AuthenticationUtil.getSystemUserName());
    }

    public void testExtendedSecurity() {
        final String monkey = this.createTestUser();
        final String elephant = this.createTestUser();
        final String snake = this.createTestUser();
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.filePlan));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.rmContainer));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.rmFolder));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.record));
                TestCase.assertTrue((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.getReaders(ExtendedSecurityServiceImplTest.this.record).isEmpty());
                TestCase.assertTrue((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.getWriters(ExtendedSecurityServiceImplTest.this.record).isEmpty());
                HashSet<String> extendedReaders = new HashSet<String>(2);
                extendedReaders.add(monkey);
                extendedReaders.add(elephant);
                ExtendedSecurityServiceImplTest.this.extendedSecurityService.set(ExtendedSecurityServiceImplTest.this.record, extendedReaders, null);
                ExtendedSecurityServiceImplTest.this.checkExtendedReaders(ExtendedSecurityServiceImplTest.this.record, extendedReaders);
                HashSet<String> extendedReadersToo = new HashSet<String>(2);
                extendedReadersToo.add(monkey);
                extendedReadersToo.add(snake);
                ExtendedSecurityServiceImplTest.this.extendedSecurityService.set(ExtendedSecurityServiceImplTest.this.recordToo, extendedReadersToo, null);
                ExtendedSecurityServiceImplTest.this.checkExtendedReaders(ExtendedSecurityServiceImplTest.this.recordToo, extendedReadersToo);
                ExtendedSecurityServiceImplTest.this.extendedSecurityService.remove(ExtendedSecurityServiceImplTest.this.recordToo);
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.recordToo));
                TestCase.assertTrue((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.getReaders(ExtendedSecurityServiceImplTest.this.recordToo).isEmpty());
                TestCase.assertTrue((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.getWriters(ExtendedSecurityServiceImplTest.this.recordToo).isEmpty());
                return null;
            }
        });
    }

    public void testMove() {
        final String monkey = this.createTestUser();
        final String elephant = this.createTestUser();
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){
            Set<String> extendedReaders;
            {
                super((RetryingTransactionHelperTestCase)ExtendedSecurityServiceImplTest.this);
                this.extendedReaders = new HashSet<String>(2);
            }

            public Void run() throws Exception {
                this.extendedReaders.add(monkey);
                this.extendedReaders.add(elephant);
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.filePlan));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.rmContainer));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.rmFolder));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.record));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.moveRecordCategory));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.moveRecordFolder));
                TestCase.assertTrue((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.getReaders(ExtendedSecurityServiceImplTest.this.record).isEmpty());
                ExtendedSecurityServiceImplTest.this.extendedSecurityService.set(ExtendedSecurityServiceImplTest.this.record, this.extendedReaders, null);
                ExtendedSecurityServiceImplTest.this.checkExtendedReaders(ExtendedSecurityServiceImplTest.this.record, this.extendedReaders);
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.moveRecordCategory));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.moveRecordFolder));
                ExtendedSecurityServiceImplTest.this.fileFolderService.move(ExtendedSecurityServiceImplTest.this.record, ExtendedSecurityServiceImplTest.this.moveRecordFolder, "movedRecord");
                return null;
            }

            public void test(Void result) throws Exception {
                ExtendedSecurityServiceImplTest.this.checkExtendedReaders(ExtendedSecurityServiceImplTest.this.record, this.extendedReaders);
            }
        });
    }

    private void checkExtendedReaders(NodeRef nodeRef, Set<String> testReaders) {
        ExtendedSecurityServiceImplTest.assertTrue((boolean)this.extendedSecurityService.hasExtendedSecurity(nodeRef));
        Set readers = this.extendedSecurityService.getReaders(nodeRef);
        ExtendedSecurityServiceImplTest.assertNotNull((Object)readers);
        ExtendedSecurityServiceImplTest.assertEquals(testReaders, (Object)readers);
    }

    public void testDifferentUsersDifferentPermissions() {
        final String userNone = this.createTestUser();
        final String userRead = this.createTestUser();
        final String userWrite = this.createTestUser();
        final String siteShortName = GUID.generate();
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                ExtendedSecurityServiceImplTest.this.siteService.createSite(null, siteShortName, "test", "test", SiteVisibility.PRIVATE);
                return null;
            }
        });
        final NodeRef documentLibrary = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                ExtendedSecurityServiceImplTest.this.siteService.setMembership(siteShortName, userRead, "SiteConsumer");
                ExtendedSecurityServiceImplTest.this.siteService.setMembership(siteShortName, userWrite, "SiteCollaborator");
                return ExtendedSecurityServiceImplTest.this.siteService.createContainer(siteShortName, "documentLibrary", null, null);
            }
        });
        final NodeRef record = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                NodeRef record = ExtendedSecurityServiceImplTest.this.fileFolderService.create(documentLibrary, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                ExtendedSecurityServiceImplTest.this.recordService.createRecord(ExtendedSecurityServiceImplTest.this.filePlan, record);
                return record;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userNone);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userRead);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userWrite);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userNone);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userRead);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userWrite);
                return null;
            }
        });
    }
}

