/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.retentionschedule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementServiceRegistry;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionScheduleImpl;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.disposition.property.DispositionProperty;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.UnprocessableContentException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.RetentionEvents;
import org.alfresco.rm.rest.api.model.RetentionPeriod;
import org.alfresco.rm.rest.api.model.RetentionScheduleActionDefinition;
import org.alfresco.rm.rest.api.model.RetentionSteps;
import org.alfresco.rm.rest.api.retentionschedule.RetentionScheduleEntityResource;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;

@RelationshipResource(name="retention-steps", entityResource=RetentionScheduleEntityResource.class, title="Retention Schedule Action")
public class RetentionScheduleActionRelation
implements RelationshipResourceAction.Read<RetentionScheduleActionDefinition>,
RelationshipResourceAction.Create<RetentionScheduleActionDefinition> {
    private FilePlanComponentsApiUtils apiUtils;
    protected NodeService nodeService;
    private RecordsManagementServiceRegistry service;
    private ApiNodesModelFactory nodesModelFactory;
    private DispositionService dispositionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setRecordsManagementServiceRegistry(RecordsManagementServiceRegistry service) {
        this.service = service;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    @WebApiDescription(title="Create a retention schedule step for the particular retention schedule using the 'retentionScheduleId'")
    public List<RetentionScheduleActionDefinition> create(String retentionScheduleId, List<RetentionScheduleActionDefinition> nodeInfos, Parameters parameters) {
        RMParameterCheck.checkNotBlank("retentionScheduleId", retentionScheduleId);
        ParameterCheck.mandatory((String)"entity", nodeInfos);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef retentionScheduleNodeRef = this.apiUtils.lookupAndValidateNodeType(retentionScheduleId, RecordsManagementModel.TYPE_DISPOSITION_SCHEDULE);
        RetentionScheduleActionDefinition retentionScheduleActionDefinition = nodeInfos.get(0);
        this.retentionScheduleStepValidation(retentionScheduleNodeRef, retentionScheduleActionDefinition);
        DispositionScheduleImpl dispositionSchedule = new DispositionScheduleImpl(this.service, this.nodeService, retentionScheduleNodeRef);
        boolean isRecordLevel = dispositionSchedule.isRecordLevelDisposition();
        this.retentionScheduleRequestValidation(retentionScheduleActionDefinition, isRecordLevel);
        Map<QName, Serializable> actionDefinitionParams = this.nodesModelFactory.createRetentionActionDefinitionParams(retentionScheduleActionDefinition);
        NodeRef actionNodeRef = this.nodeService.createNode(retentionScheduleNodeRef, RecordsManagementModel.ASSOC_DISPOSITION_ACTION_DEFINITIONS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)retentionScheduleActionDefinition.getName())), RecordsManagementModel.TYPE_DISPOSITION_ACTION_DEFINITION, actionDefinitionParams).getChildRef();
        DispositionActionDefinition dispositionActionDefinition = dispositionSchedule.getDispositionActionDefinition(actionNodeRef.getId());
        ArrayList<RetentionScheduleActionDefinition> responseActions = new ArrayList<RetentionScheduleActionDefinition>();
        if (dispositionActionDefinition != null) {
            responseActions.add(this.nodesModelFactory.mapRetentionScheduleActionDefData(dispositionActionDefinition));
        }
        return responseActions;
    }

    @WebApiDescription(title="Return a paged list of retention schedule action definition based on the 'retentionScheduleId'")
    public CollectionWithPagingInfo<RetentionScheduleActionDefinition> readAll(String retentionScheduleId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("retentionScheduleId", retentionScheduleId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef retentionScheduleNodeRef = this.apiUtils.lookupAndValidateNodeType(retentionScheduleId, RecordsManagementModel.TYPE_DISPOSITION_SCHEDULE);
        List<DispositionActionDefinition> actions = this.nodesModelFactory.getRetentionActions(retentionScheduleNodeRef);
        List actionDefinitionList = actions.stream().map(this.nodesModelFactory::mapRetentionScheduleActionDefData).collect(Collectors.toList());
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), actionDefinitionList, (boolean)false, (Integer)actionDefinitionList.size());
    }

    private void retentionScheduleStepValidation(NodeRef retentionScheduleNodeRef, RetentionScheduleActionDefinition retentionScheduleActionDefinition) {
        if (this.checkStepNameIsEmpty(retentionScheduleActionDefinition.getName())) {
            throw new IllegalArgumentException("'name' parameter is mandatory when creating a disposition action definition");
        }
        List<DispositionActionDefinition> actions = this.nodesModelFactory.getRetentionActions(retentionScheduleNodeRef);
        Set<String> completedActions = new HashSet<String>();
        if (!actions.isEmpty()) {
            completedActions = actions.stream().map(DispositionActionDefinition::getName).collect(Collectors.toSet());
        }
        if (completedActions.contains("destroy")) {
            throw new ConstraintViolatedException("Invalid Step - destroy action is already added. No other action is allowed after Destroy.");
        }
        if (this.checkStepAlreadyExists(completedActions, retentionScheduleActionDefinition.getName())) {
            throw new ConstraintViolatedException("Invalid Step - This step already exists. You can\u2019t create it again. Only transfer action is allowed multiple times.");
        }
        if (this.firstStepValidation(actions, retentionScheduleActionDefinition.getName())) {
            throw new UnprocessableContentException("Invalid Step - cutoff or retain should be the first step");
        }
        if (this.isCutOffStepAllowed(completedActions, retentionScheduleActionDefinition.getName())) {
            throw new ConstraintViolatedException("Invalid Step - Can't use cutoff after transfer or accession");
        }
    }

    private boolean checkStepNameIsEmpty(String name) {
        return name == null || name.isEmpty();
    }

    private void retentionScheduleRequestValidation(RetentionScheduleActionDefinition retentionScheduleActionDefinition, boolean isRecordLevel) {
        if (this.invalidStepNameCheck(retentionScheduleActionDefinition.getName())) {
            throw new InvalidArgumentException("name value is invalid : " + retentionScheduleActionDefinition.getName());
        }
        this.validatePeriodAndPeriodProperty(retentionScheduleActionDefinition, isRecordLevel);
        if (this.invalidEventNameCheck(retentionScheduleActionDefinition.getEvents())) {
            throw new InvalidArgumentException("event value is invalid: " + String.valueOf(retentionScheduleActionDefinition.getEvents()));
        }
        if (this.validateCombineRetentionStepConditionsForNonAccessionStep(retentionScheduleActionDefinition)) {
            throw new IllegalArgumentException("combineRetentionStepConditions property is only valid for accession step. Not valid for :" + retentionScheduleActionDefinition.getName());
        }
        if (this.validateLocationForNonTransferStep(retentionScheduleActionDefinition)) {
            throw new IllegalArgumentException("location property is only valid for transfer step. Not valid for :" + retentionScheduleActionDefinition.getName());
        }
    }

    private void validatePeriodAndPeriodProperty(RetentionScheduleActionDefinition retentionScheduleActionDefinition, boolean isRecordLevel) {
        if (this.invalidPeriodCheck(retentionScheduleActionDefinition.getPeriod())) {
            throw new InvalidArgumentException("period value is invalid : " + retentionScheduleActionDefinition.getPeriod());
        }
        Collection<DispositionProperty> validPeriodProperties = this.dispositionService.getDispositionProperties(isRecordLevel, retentionScheduleActionDefinition.getName());
        if (validPeriodProperties.stream().map(dp -> dp.getQName().toPrefixString()).noneMatch(retentionScheduleActionDefinition.getPeriodProperty()::equals)) {
            throw new InvalidArgumentException("periodProperty value is invalid: " + retentionScheduleActionDefinition.getPeriodProperty());
        }
    }

    private boolean validateCombineRetentionStepConditionsForNonAccessionStep(RetentionScheduleActionDefinition retentionScheduleActionDefinition) {
        return !retentionScheduleActionDefinition.getName().equals(RetentionSteps.ACCESSION.stepName) && retentionScheduleActionDefinition.isCombineRetentionStepConditions();
    }

    private boolean validateLocationForNonTransferStep(RetentionScheduleActionDefinition retentionScheduleActionDefinition) {
        return retentionScheduleActionDefinition.getLocation() != null && !retentionScheduleActionDefinition.getName().equals(RetentionSteps.TRANSFER.stepName) && !retentionScheduleActionDefinition.getLocation().isEmpty();
    }

    private boolean checkStepAlreadyExists(Set<String> completedActions, String stepName) {
        return completedActions.contains(stepName) && !stepName.equals(RetentionSteps.TRANSFER.stepName);
    }

    private boolean firstStepValidation(List<DispositionActionDefinition> actions, String stepName) {
        return actions.isEmpty() && !stepName.equals(RetentionSteps.CUTOFF.stepName) && !stepName.equals(RetentionSteps.RETAIN.stepName);
    }

    private boolean isCutOffStepAllowed(Set<String> completedActions, String stepName) {
        return (completedActions.contains(RetentionSteps.TRANSFER.stepName) || completedActions.contains(RetentionSteps.ACCESSION.stepName)) && stepName.equals(RetentionSteps.CUTOFF.stepName);
    }

    private boolean invalidStepNameCheck(String stepName) {
        return stepName != null && Arrays.stream(RetentionSteps.values()).noneMatch(retentionStep -> retentionStep.stepName.equals(stepName));
    }

    private boolean invalidPeriodCheck(String period) {
        return period != null && Arrays.stream(RetentionPeriod.values()).noneMatch(retentionPeriod -> retentionPeriod.periodName.equals(period));
    }

    private boolean invalidEventNameCheck(List<String> events) {
        return !events.isEmpty() && events.stream().anyMatch(event -> Arrays.stream(RetentionEvents.values()).noneMatch(retentionEvent -> retentionEvent.eventName.equals(event)));
    }
}

