/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.Date;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.behaviour.RecordsManagementSearchBehaviour;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class VitalRecordServiceImplTest
extends BaseRMTestCase {
    protected static final Period PERIOD_NONE = new Period("none|0");
    protected static final Period PERIOD_WEEK = new Period("week|1");
    protected static final Period PERIOD_MONTH = new Period("month|1");
    private NodeRef mhRecord51;
    private NodeRef mhRecord52;
    private NodeRef mhRecord53;
    private NodeRef mhRecord54;
    private NodeRef mhRecord55;

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isMultiHierarchyTest() {
        return true;
    }

    @Override
    protected void setupMultiHierarchyTestData() {
        super.setupMultiHierarchyTestData();
        this.setupVitalRecordDefinition(this.mhContainer21, true, PERIOD_WEEK);
        this.setupVitalRecordDefinition(this.mhContainer32, false, PERIOD_WEEK);
        this.setupVitalRecordDefinition(this.mhContainer33, true, PERIOD_WEEK);
        this.setupVitalRecordDefinition(this.mhContainer23, true, PERIOD_WEEK);
        this.setupVitalRecordDefinition(this.mhContainer35, true, PERIOD_MONTH);
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                VitalRecordServiceImplTest.this.mhRecord51 = VitalRecordServiceImplTest.this.utils.createRecord(VitalRecordServiceImplTest.this.mhRecordFolder41, "record51.txt");
                VitalRecordServiceImplTest.this.mhRecord52 = VitalRecordServiceImplTest.this.utils.createRecord(VitalRecordServiceImplTest.this.mhRecordFolder42, "record52.txt");
                VitalRecordServiceImplTest.this.mhRecord53 = VitalRecordServiceImplTest.this.utils.createRecord(VitalRecordServiceImplTest.this.mhRecordFolder43, "record53.txt");
                VitalRecordServiceImplTest.this.mhRecord54 = VitalRecordServiceImplTest.this.utils.createRecord(VitalRecordServiceImplTest.this.mhRecordFolder44, "record54.txt");
                VitalRecordServiceImplTest.this.mhRecord55 = VitalRecordServiceImplTest.this.utils.createRecord(VitalRecordServiceImplTest.this.mhRecordFolder45, "record55.txt");
                return null;
            }
        });
    }

    private void setupVitalRecordDefinition(final NodeRef nodeRef, final boolean enabled, final Period period) {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                VitalRecordServiceImplTest.this.vitalRecordService.setVitalRecordDefintion(nodeRef, enabled, period);
                return null;
            }
        });
    }

    public void testInit() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer11, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer12, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer21, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer22, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer23, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer31, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer32, false, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer33, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer34, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer35, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder41, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder42, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder43, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder44, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder45, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord51, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord52, false, null);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord53, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord54, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord55, true, PERIOD_MONTH);
                return null;
            }
        });
    }

    public void testValueInheritance() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                return VitalRecordServiceImplTest.this.filePlanService.createRecordCategory(VitalRecordServiceImplTest.this.mhContainer35, GUID.generate());
            }

            public void test(NodeRef result) throws Exception {
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(result, true, PERIOD_MONTH);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                return VitalRecordServiceImplTest.this.recordFolderService.createRecordFolder(VitalRecordServiceImplTest.this.mhContainer32, GUID.generate());
            }

            public void test(NodeRef result) throws Exception {
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(result, false, PERIOD_WEEK);
            }
        });
    }

    public void testFileNewContent() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef record = VitalRecordServiceImplTest.this.fileFolderService.create(VitalRecordServiceImplTest.this.mhRecordFolder41, "test101.txt", ContentModel.TYPE_CONTENT).getNodeRef();
                ContentWriter writer = VitalRecordServiceImplTest.this.contentService.getWriter(record, ContentModel.PROP_CONTENT, true);
                writer.setEncoding("UTF-8");
                writer.setMimetype("text/plain");
                writer.putContent("hello world this is some test content");
                return record;
            }

            public void test(NodeRef record) throws Exception {
                VitalRecordServiceImplTest.this.assertVitalRecord(record, true, PERIOD_WEEK);
            }
        });
    }

    public void testChangesToVitalRecordDefinitions() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                VitalRecordServiceImplTest.this.setupVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer31, true, PERIOD_MONTH);
                return null;
            }

            public void test(Void result) throws Exception {
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer11, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer12, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer21, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer22, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer23, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer31, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer32, false, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer33, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer34, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer35, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder41, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder42, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder43, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder44, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder45, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord51, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord52, false, null);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord53, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord54, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord55, true, PERIOD_MONTH);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                VitalRecordServiceImplTest.this.setupVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer31, false, PERIOD_NONE);
                return null;
            }

            public void test(Void result) throws Exception {
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer11, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer12, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer21, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer22, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer23, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer31, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer32, false, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer33, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer34, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer35, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder41, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder42, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder43, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder44, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder45, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord51, false, null);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord52, false, null);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord53, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord54, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord55, true, PERIOD_MONTH);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                VitalRecordServiceImplTest.this.setupVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer12, true, PERIOD_MONTH);
                return null;
            }

            public void test(Void result) throws Exception {
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer11, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer12, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer21, true, PERIOD_WEEK);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer22, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer23, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer31, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer32, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer33, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer34, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhContainer35, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder41, false, null);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder42, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder43, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder44, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertHasVitalRecordDefinition(VitalRecordServiceImplTest.this.mhRecordFolder45, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord51, false, null);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord52, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord53, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord54, true, PERIOD_MONTH);
                VitalRecordServiceImplTest.this.assertVitalRecord(VitalRecordServiceImplTest.this.mhRecord55, true, PERIOD_MONTH);
            }
        });
    }

    private void assertHasVitalRecordDefinition(NodeRef nodeRef, boolean enabled, Period period) {
        VitalRecordServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_VITAL_RECORD_DEFINITION));
        VitalRecordDefinition def = this.vitalRecordService.getVitalRecordDefinition(nodeRef);
        VitalRecordServiceImplTest.assertNotNull((Object)def);
        Boolean vitalRecordIndicator = (Boolean)this.nodeService.getProperty(nodeRef, PROP_VITAL_RECORD_INDICATOR);
        VitalRecordServiceImplTest.assertNotNull((Object)vitalRecordIndicator);
        VitalRecordServiceImplTest.assertEquals((boolean)enabled, (boolean)vitalRecordIndicator);
        VitalRecordServiceImplTest.assertEquals((boolean)enabled, (boolean)def.isEnabled());
        if (enabled) {
            Period reviewPeriod = (Period)this.nodeService.getProperty(nodeRef, PROP_REVIEW_PERIOD);
            VitalRecordServiceImplTest.assertNotNull((Object)reviewPeriod);
            VitalRecordServiceImplTest.assertEquals((Object)period, (Object)reviewPeriod);
            VitalRecordServiceImplTest.assertEquals((Object)period, (Object)def.getReviewPeriod());
            VitalRecordServiceImplTest.assertEquals((int)period.getNextDate(new Date()).getDate(), (int)def.getNextReviewDate().getDate());
        }
    }

    private void assertVitalRecord(NodeRef nodeRef, boolean enabled, Period period) {
        VitalRecordServiceImplTest.assertEquals((boolean)enabled, (boolean)this.nodeService.hasAspect(nodeRef, ASPECT_VITAL_RECORD));
        if (enabled) {
            Date reviewAsOf = (Date)this.nodeService.getProperty(nodeRef, PROP_REVIEW_AS_OF);
            VitalRecordServiceImplTest.assertNotNull((Object)reviewAsOf);
            VitalRecordServiceImplTest.assertEquals((int)period.getNextDate(new Date()).getDate(), (int)reviewAsOf.getDate());
            VitalRecordServiceImplTest.assertEquals((Object)period.getPeriodType(), (Object)this.nodeService.getProperty(nodeRef, RecordsManagementSearchBehaviour.PROP_RS_VITAL_RECORD_REVIEW_PERIOD));
            VitalRecordServiceImplTest.assertEquals((Object)period.getExpression(), (Object)this.nodeService.getProperty(nodeRef, RecordsManagementSearchBehaviour.PROP_RS_VITAL_RECORD_REVIEW_PERIOD_EXPRESSION));
        } else {
            VitalRecordServiceImplTest.assertNull((Object)this.nodeService.getProperty(nodeRef, RecordsManagementSearchBehaviour.PROP_RS_VITAL_RECORD_REVIEW_PERIOD));
            VitalRecordServiceImplTest.assertNull((Object)this.nodeService.getProperty(nodeRef, RecordsManagementSearchBehaviour.PROP_RS_VITAL_RECORD_REVIEW_PERIOD_EXPRESSION));
        }
    }
}

