/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.model;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rm.rest.api.model.RMSiteCompliance;
import org.alfresco.service.cmr.site.SiteInfo;

public class RMSite
extends Site {
    public static final String COMPLIANCE = "compliance";
    private RMSiteCompliance compliance;
    private Map<String, Boolean> setRMFields = new HashMap<String, Boolean>(7);

    public RMSiteCompliance getCompliance() {
        return this.compliance;
    }

    public void setCompliance(RMSiteCompliance compliance) {
        this.compliance = compliance;
        this.setRMFields.put(COMPLIANCE, true);
    }

    public boolean wasSet(String fieldName) {
        if (COMPLIANCE.equalsIgnoreCase(fieldName)) {
            Boolean b = this.setRMFields.get(fieldName);
            return b != null ? b : false;
        }
        return super.wasSet(fieldName);
    }

    public RMSite() {
    }

    public RMSite(Site site, RMSiteCompliance compliance) {
        this.setId(site.getId());
        this.setGuid(site.getGuid());
        this.setTitle(site.getTitle());
        this.setDescription(site.getDescription());
        this.setVisibility(site.getVisibility());
        this.setRole(site.getRole());
        this.setCompliance(compliance);
    }

    public RMSite(SiteInfo siteInfo, String role, RMSiteCompliance compliance) {
        super(siteInfo, role);
        this.setCompliance(compliance);
    }

    public String toString() {
        return "RMSite [id=" + this.id + ", guid=" + this.guid + ", title=" + this.title + ", description=" + this.description + ", visibility=" + String.valueOf(this.visibility) + ", role=" + this.role + ", compliance=" + String.valueOf((Object)this.compliance) + "]";
    }
}

