/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM3993Test
extends BaseRMTestCase {
    private static final int NUMBER_OF_BATCHES = 4;
    private static final int NUMBER_IN_BATCH = 500;
    private RuleService ruleService;
    private NodeRef ruleFolder;
    private NodeRef nodeRefCategory1;

    @Override
    protected void initServices() {
        super.initServices();
        this.ruleService = (RuleService)this.applicationContext.getBean("RuleService");
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testAutoDeclareAutoFileCreateRecordFolderOnly() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM3993Test.this.ruleFolder = RM3993Test.this.fileFolderService.create(RM3993Test.this.documentLibrary, "mytestfolder", ContentModel.TYPE_FOLDER).getNodeRef();
                RM3993Test.this.nodeRefCategory1 = RM3993Test.this.filePlanService.createRecordCategory(RM3993Test.this.filePlan, "category1");
                Action action = RM3993Test.this.actionService.createAction("create-record");
                action.setParameterValue("file-plan", (Serializable)RM3993Test.this.filePlan);
                Rule rule = new Rule();
                rule.setRuleType("inbound");
                rule.setTitle("my rule");
                rule.setAction(action);
                rule.setExecuteAsynchronously(true);
                RM3993Test.this.ruleService.saveRule(RM3993Test.this.ruleFolder, rule);
                Action fileAction = RM3993Test.this.actionService.createAction("fileTo");
                fileAction.setParameterValue("path", (Serializable)((Object)"/category1/{node.cm:description}"));
                fileAction.setParameterValue("createRecordPath", (Serializable)Boolean.valueOf(true));
                Rule fileRule = new Rule();
                fileRule.setRuleType("inbound");
                fileRule.setTitle("my rule");
                fileRule.setAction(fileAction);
                fileRule.setExecuteAsynchronously(true);
                RM3993Test.this.ruleService.saveRule(RM3993Test.this.filePlanService.getUnfiledContainer(RM3993Test.this.filePlan), fileRule);
                return null;
            }

            public void test(Void result) throws Exception {
                TestCase.assertFalse((boolean)RM3993Test.this.ruleService.getRules(RM3993Test.this.ruleFolder).isEmpty());
            }
        });
        ArrayList records = new ArrayList(2000);
        int i = 0;
        while (i < 4) {
            final int finali = i++;
            records.addAll(this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<List<NodeRef>>(){

                public List<NodeRef> run() throws Exception {
                    ArrayList<NodeRef> records = new ArrayList<NodeRef>(500);
                    for (int j = 0; j < 500; ++j) {
                        int count = finali * 500 + (j + 1);
                        String name = "content" + count + ".txt";
                        System.out.println(name + " - creating");
                        Random rand = new Random();
                        int descInt = rand.nextInt(2) + 1;
                        NodeRef record = RM3993Test.this.createFile(RM3993Test.this.ruleFolder, name, Integer.toString(descInt), ContentModel.TYPE_CONTENT);
                        records.add(record);
                    }
                    return records;
                }
            }));
        }
        try {
            while (!records.isEmpty()) {
                Thread.sleep(1000L);
                final Iterator temp = records.iterator();
                this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

                    public Void run() throws Exception {
                        while (temp.hasNext()) {
                            NodeRef record = (NodeRef)temp.next();
                            if (!RM3993Test.this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_RECORD) || !RM3993Test.this.recordService.isFiled(record)) continue;
                            String name = (String)((Object)RM3993Test.this.nodeService.getProperty(record, ContentModel.PROP_NAME));
                            System.out.println(name + " - complete");
                            temp.remove();
                        }
                        return null;
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        Integer numberOfRecords = (Integer)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Integer>(){

            public Integer doWork() throws Exception {
                List containedRecordFolders = RM3993Test.this.filePlanService.getContainedRecordFolders(RM3993Test.this.nodeRefCategory1);
                int numberOfRecords = 0;
                for (NodeRef recordFolder : containedRecordFolders) {
                    numberOfRecords += RM3993Test.this.fileFolderService.list(recordFolder).size();
                }
                return numberOfRecords;
            }
        });
        RM3993Test.assertTrue((numberOfRecords == 2000 ? 1 : 0) != 0);
    }

    private NodeRef createFile(NodeRef parentNodeRef, String name, String descrption, QName typeQName) {
        HashMap<QName, String> properties = new HashMap<QName, String>(11);
        properties.put(ContentModel.PROP_NAME, name);
        properties.put(ContentModel.PROP_DESCRIPTION, descrption);
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name));
        ChildAssociationRef assocRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, typeQName, properties);
        NodeRef nodeRef = assocRef.getChildRef();
        return nodeRef;
    }
}

