/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.aspect;

import java.util.Arrays;
import java.util.Collections;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.aspect.RecordAspect;
import org.alfresco.module.org_alfresco_module_rm.security.ExtendedSecurityService;
import org.alfresco.module.org_alfresco_module_rm.util.ContentBinDuplicationUtility;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QNamePattern;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RecordAspectUnitTest {
    private static final NodeRef NODE_REF = new NodeRef("node://Ref/");
    private static final NodeRef COPY_REF = new NodeRef("node://Copy/");
    private static final AssociationRef SOURCE_ASSOC_REF = new AssociationRef(COPY_REF, ContentModel.ASSOC_ORIGINAL, NODE_REF);
    private static final AssociationRef TARGET_ASSOC_REF = new AssociationRef(NODE_REF, ContentModel.ASSOC_ORIGINAL, COPY_REF);
    @InjectMocks
    private RecordAspect recordAspect;
    @Mock
    private NodeService mockNodeService;
    @Mock
    private ExtendedSecurityService mockExtendedSecurityService;
    @Mock
    private ContentBinDuplicationUtility mockContentBinDuplicationUtility;

    @Before
    public void setUp() {
        this.recordAspect.setNodeService(this.mockNodeService);
    }

    @Test
    public void testDuplicateBinBeforeAddingAspectForFileWithCopy() {
        Mockito.when((Object)this.mockNodeService.getSourceAssocs(NODE_REF, (QNamePattern)ContentModel.ASSOC_ORIGINAL)).thenReturn(Arrays.asList(SOURCE_ASSOC_REF));
        this.recordAspect.beforeAddAspect(NODE_REF, RecordsManagementModel.ASPECT_RECORD);
        ((ContentBinDuplicationUtility)Mockito.verify((Object)this.mockContentBinDuplicationUtility, (VerificationMode)Mockito.times((int)1))).duplicate(NODE_REF);
    }

    @Test
    public void testDuplicateBinBeforeAddingAspectForCopy() {
        Mockito.when((Object)this.mockNodeService.getTargetAssocs(NODE_REF, (QNamePattern)ContentModel.ASSOC_ORIGINAL)).thenReturn(Arrays.asList(TARGET_ASSOC_REF));
        this.recordAspect.beforeAddAspect(NODE_REF, RecordsManagementModel.ASPECT_RECORD);
        ((ContentBinDuplicationUtility)Mockito.verify((Object)this.mockContentBinDuplicationUtility, (VerificationMode)Mockito.times((int)1))).duplicate(NODE_REF);
    }

    @Test
    public void testNotDuplicateBinForFileWithNoCopies() {
        Mockito.when((Object)this.mockNodeService.getSourceAssocs(NODE_REF, (QNamePattern)ContentModel.ASSOC_ORIGINAL)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.mockNodeService.getTargetAssocs(NODE_REF, (QNamePattern)ContentModel.ASSOC_ORIGINAL)).thenReturn(Collections.emptyList());
        this.recordAspect.beforeAddAspect(NODE_REF, RecordsManagementModel.ASPECT_RECORD);
        ((ContentBinDuplicationUtility)Mockito.verify((Object)this.mockContentBinDuplicationUtility, (VerificationMode)Mockito.times((int)0))).duplicate(NODE_REF);
    }

    @Test
    public void testDuplicateBinWhenCopyingRecord() {
        Mockito.when((Object)this.mockNodeService.exists(COPY_REF)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeService.hasAspect(COPY_REF, RecordsManagementModel.ASPECT_RECORD)).thenReturn((Object)true);
        this.recordAspect.onCopyComplete(null, NODE_REF, COPY_REF, true, null);
        ((ExtendedSecurityService)Mockito.verify((Object)this.mockExtendedSecurityService, (VerificationMode)Mockito.times((int)1))).remove(COPY_REF);
        ((ContentBinDuplicationUtility)Mockito.verify((Object)this.mockContentBinDuplicationUtility, (VerificationMode)Mockito.times((int)1))).duplicate(COPY_REF);
    }
}

