/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.hold;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.util.NodeTypeUtility;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class BaseHold
extends DeclarativeWebScript {
    private HoldService holdService;
    private RecordFolderService recordFolderService;
    private NodeService nodeService;
    private NodeTypeUtility nodeTypeUtility;

    public void setHoldService(HoldService holdService) {
        this.holdService = holdService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeTypeUtility(NodeTypeUtility nodeTypeUtility) {
        this.nodeTypeUtility = nodeTypeUtility;
    }

    protected HoldService getHoldService() {
        return this.holdService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        JSONObject json = this.getJSONFromContent(req);
        List<NodeRef> holds = this.getHolds(json);
        List<NodeRef> nodeRefs = this.getItemNodeRefs(json);
        this.doAction(holds, nodeRefs);
        return new HashMap<String, Object>();
    }

    abstract void doAction(List<NodeRef> var1, List<NodeRef> var2);

    protected JSONObject getJSONFromContent(WebScriptRequest req) {
        JSONObject json = null;
        try {
            String content = req.getContent().getContent();
            json = new JSONObject(new JSONTokener(content));
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        return json;
    }

    protected List<NodeRef> getItemNodeRefs(JSONObject json) {
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>();
        try {
            JSONArray nodeRefsArray = json.getJSONArray("nodeRefs");
            for (int i = 0; i < nodeRefsArray.length(); ++i) {
                NodeRef nodeReference = new NodeRef(nodeRefsArray.getString(i));
                this.checkItemNodeRef(nodeReference);
                nodeRefs.add(nodeReference);
            }
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not get information from the json array.", (Throwable)je);
        }
        return nodeRefs;
    }

    private void checkItemNodeRef(NodeRef nodeRef) {
        if (!this.nodeService.exists(nodeRef)) {
            throw new WebScriptException(400, "Item being added to hold does not exist.");
        }
        if (!this.recordFolderService.isRecordFolder(nodeRef) && !this.nodeTypeUtility.instanceOf(this.nodeService.getType(nodeRef), ContentModel.TYPE_CONTENT)) {
            throw new WebScriptException(400, "Items added to a hold must be either a record, a record folder or active content.");
        }
    }

    protected List<NodeRef> getHolds(JSONObject json) {
        ArrayList<NodeRef> holds = new ArrayList<NodeRef>();
        try {
            JSONArray holdsArray = json.getJSONArray("holds");
            for (int i = 0; i < holdsArray.length(); ++i) {
                NodeRef nodeRef = new NodeRef(holdsArray.getString(i));
                this.checkHoldNodeRef(nodeRef);
                holds.add(nodeRef);
            }
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not get information from the json array.", (Throwable)je);
        }
        return holds;
    }

    private void checkHoldNodeRef(NodeRef nodeRef) {
        if (!this.nodeService.exists(nodeRef)) {
            throw new WebScriptException(400, "The hold does not exist.");
        }
        if (!this.holdService.isHold(nodeRef)) {
            throw new WebScriptException(400, "Items are being added to a node that isn't a hold.");
        }
    }
}

